<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	html/com_finder
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

$template = Factory::getApplication()->getTemplate();
require_once (JPATH_THEMES . '/' .$template. '/html/helpers/Filter.php');

$doc = Factory::getDocument();
$search_query = "";

if(isset($_GET['q'])):
$search_query = Text::sprintf('COM_FINDER_FILTER_BRANCH_LABEL', $_GET['q']);
endif;

if (!empty($search_query)) :
	$doc->setTitle( $doc->getTitle() . ' | ' . $search_query );
endif;

/*
* This segment of code sets up the autocompleter.
*/
if ($this->params->get('show_autosuggest', 1))
{
	$this->document->getWebAssetManager()->usePreset('awesomplete');
	$this->document->addScriptOptions('finder-search', array('url' => Route::_('index.php?option=com_finder&task=suggestions.suggest&format=json&tmpl=component')));
}

?>

<form action="<?php echo Route::_($this->query->toUri()); ?>" method="get" class="js-finder-searchform">
	<?php echo $this->getFields(); ?>
	<fieldset class="uk-fieldset">
		<legend class="com-finder__search-legend visually-hidden uk-legend">
			<?php echo Text::_('COM_FINDER_SEARCH_FORM_LEGEND'); ?>
		</legend>
		<div class="uk-margin">
			<label for="q" class="uk-form-label">
				<?php echo Text::_('COM_FINDER_SEARCH_TERMS'); ?>
			</label>
			<div class="input-group">
				<input type="text" name="q" id="q" class="js-finder-search-query form-control uk-input" value="<?php echo $this->escape($this->query->input); ?>">
				<button type="submit" class="uk-button uk-button-primary">
					<span uk-icon="icon: search" aria-hidden="true"></span>
					<?php echo Text::_('JSEARCH_FILTER_SUBMIT'); ?>
				</button>
				<?php if ($this->params->get('show_advanced', 1)) : ?>
					<button href="#advancedSearch" class="uk-button uk-button-text" type="button" uk-toggle="target: #advancedSearch; animation: uk-animation-fade">
						<?php echo Text::_('COM_FINDER_ADVANCED_SEARCH_TOGGLE'); ?></button>
				<?php endif; ?>
			</div>
		</div>
	</fieldset>

	<?php if ($this->params->get('show_advanced', 1)) : ?>
		<div id="advancedSearch" class="com-finder__advanced js-finder-advanced uk-margin" hidden="" uk-grid="">
			<?php if ($this->params->get('show_advanced_tips', 1)) : ?>
				<div>
					<div class="uk-card uk-card-default">
						<div class="uk-card-body">
						<h3 class="uk-card-title"><?php echo Text::_('COM_FINDER_SEARCH_ADVANCED_LEGEND'); ?></h3>
							<?php echo Text::_('COM_FINDER_ADVANCED_TIPS_INTRO'); ?>
							<?php echo Text::_('COM_FINDER_ADVANCED_TIPS_AND'); ?>
							<?php echo Text::_('COM_FINDER_ADVANCED_TIPS_NOT'); ?>
							<?php echo Text::_('COM_FINDER_ADVANCED_TIPS_OR'); ?>
							<?php if ($this->params->get('tuplecount', 1) > 1) : ?>
							<?php echo Text::_('COM_FINDER_ADVANCED_TIPS_PHRASE'); ?>
							<?php endif; ?>
							<?php echo Text::_('COM_FINDER_ADVANCED_TIPS_OUTRO'); ?>
						</div>
					</div>
				</div>
			<?php endif; ?>
			<div>
				<div id="finder-filter-window" class="uk-grid-small uk-child-width-auto" uk-grid="">
					<?php //echo HTMLHelper::_('filter.select', $this->query, $this->params); ?>
					<?php echo Filter::select($this->query, $this->params); ?>
				</div>
			</div>
		</div>
	<?php endif; ?>
</form>
