<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	html
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;


// include config and layout
$base = dirname(dirname(dirname(__FILE__)));
include($base.'/config.php');


use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\Component\Content\Site\Helper\RouteHelper;


// get view
$menu = Factory::getApplication()->getMenu()->getActive();
$view = is_object($menu) && isset($menu->query['view']) ? $menu->query['view'] : null;

if ($view == 'archive') $args['permalink'] = '';

if ($this->params->def('show_pagination_results', 1) && $this->pagination->pagesTotal > 1) :
$doc = Factory::getDocument();
$doc->setTitle( $doc->getTitle() . ' default_items.php' . Text::sprintf('JLIB_HTML_PAGE_CURRENT_OF_TOTAL', $this->pagination->pagesCurrent, $this->pagination->pagesTotal) );
$doc->setDescription( $doc->getMetaData('description') . ' default_items.php' . Text::sprintf('JLIB_HTML_PAGE_CURRENT_OF_TOTAL', $this->pagination->pagesCurrent, $this->pagination->pagesTotal) );
endif;

$params = $this->params; ?>

	<?php foreach ($this->items as $i => $item) : ?>
	<article class="uk-article <?php echo $view; ?>" itemscope itemtype="https://schema.org/Article">
		<?php $info = $item->params->get('info_block_position', 0); ?>
		<div>
			<div class="uk-container uk-container-expand uk-margin">
				<hr class="uk-divider-small uk-margin-small-bottom">
				<h2 class="uk-article-title uk-margin-remove-top" itemprop="headline">
					<?php if ($params->get('link_titles')) : ?>
						<a class="uk-link-reset" href="<?php echo Route::_(RouteHelper::getArticleRoute($item->slug, $item->catid, $item->language)); ?>" itemprop="url">
							<?php echo $this->escape($item->title); ?>
						</a>
					<?php else : ?>
						<?php echo $this->escape($item->title); ?>
					<?php endif; ?>
				</h2>

				<?php // Content is generated by content plugin event "onContentAfterTitle" ?>
				<?php echo $item->event->afterDisplayTitle; ?>

				<?php if ($params->get('show_author') && !empty($item->author )) : ?>
					<div class="createdby uk-text-small uk-text-muted" itemprop="author" itemscope itemtype="https://schema.org/Person">
					<?php $author = $item->created_by_alias ?: $item->author; ?>
					<?php $author = '<span itemprop="name">' . $author . '</span>'; ?>
						<?php if (!empty($item->contact_link) && $params->get('link_author') == true) : ?>
							<?php echo Text::sprintf('COM_CONTENT_WRITTEN_BY', HTMLHelper::_('link', $this->item->contact_link, $author, array('itemprop' => 'url'))); ?>
						<?php else : ?>
							<?php echo '<span class="uk-margin-small-right" uk-icon="icon: user; ratio: 0.8;"></span>' .Text::sprintf('COM_CONTENT_WRITTEN_BY', $author); ?>
						<?php endif; ?>
					</div>
				<?php endif; ?>
			</div>
		<?php $useDefList = ($params->get('show_modify_date') || $params->get('show_publish_date') || $params->get('show_create_date')
			|| $params->get('show_hits') || $params->get('show_category') || $params->get('show_parent_category')); ?>
		<?php if ($useDefList && ($info == 0 || $info == 2)) : ?>
			<div class="uk-container uk-container-expand uk-margin uk-article-meta">
			
				<div class="uk-grid-small uk-child-width-auto uk-flex-middle" uk-grid="">

				<?php if ($params->get('show_parent_category') && !empty($item->parent_id)) : ?>
						<div class="parent-category-name">
							<?php $title = $this->escape($item->parent_title); ?>
							<?php if ($params->get('link_parent_category') && !empty($item->parent_id)) : ?>
								<?php $url = '<a href="' . Route::_(
									RouteHelper::getCategoryRoute($item->parent_id, $item->parent_language)
									)
									. '" itemprop="genre">' . $title . '</a>'; ?>
								<?php echo Text::sprintf('COM_CONTENT_PARENT', $url); ?>
							<?php else : ?>
								<?php echo Text::sprintf('COM_CONTENT_PARENT', '<span itemprop="genre">' . $title . '</span>'); ?>
							<?php endif; ?>
						</div>
				<?php endif; ?>
				<?php if ($params->get('show_category')) : ?>
						<div class="category-name">
							<?php $title = $this->escape($item->category_title); ?>
							<?php if ($params->get('link_category') && $item->catid) : ?>
								<?php $url = '<a href="' . Route::_(
									RouteHelper::getCategoryRoute($item->catid, $item->category_language)
									)
									. '" itemprop="genre">' . $title . '</a>'; ?>
								<?php echo Text::sprintf('COM_CONTENT_CATEGORY', $url); ?>
							<?php else : ?>
								<?php echo Text::sprintf('COM_CONTENT_CATEGORY', '<span itemprop="genre">' . $title . '</span>'); ?>
							<?php endif; ?>
						</div>
				<?php endif; ?>

				<?php if ($params->get('show_publish_date')) : ?>
						<div class="published">
							<span class="uk-margin-small-right" uk-icon="icon: calendar;" aria-hidden="true"></span>
							<time datetime="<?php echo HTMLHelper::_('date', $item->publish_up, 'c'); ?>" itemprop="datePublished">
								<?php echo Text::sprintf('COM_CONTENT_PUBLISHED_DATE_ON', HTMLHelper::_('date', $item->publish_up, Text::_('DATE_FORMAT_LC3'))); ?>
							</time>
						</div>
				<?php endif; ?>

				<?php if ($info == 0) : ?>
					<?php if ($params->get('show_modify_date')) : ?>
							<div class="modified">
								<span class="uk-margin-small-right" uk-icon="icon: calendar;" aria-hidden="true"></span>
								<time datetime="<?php echo HTMLHelper::_('date', $item->modified, 'c'); ?>" itemprop="dateModified">
									<?php echo Text::sprintf('COM_CONTENT_LAST_UPDATED', HTMLHelper::_('date', $item->modified, Text::_('DATE_FORMAT_LC3'))); ?>
								</time>
							</div>
					<?php endif; ?>
					<?php if ($params->get('show_create_date')) : ?>
							<div class="create">
								<span class="uk-margin-small-right" uk-icon="icon: calendar;" aria-hidden="true"></span>
								<time datetime="<?php echo HTMLHelper::_('date', $item->created, 'c'); ?>" itemprop="dateCreated">
									<?php echo Text::sprintf('COM_CONTENT_CREATED_DATE_ON', HTMLHelper::_('date', $item->created, Text::_('DATE_FORMAT_LC3'))); ?>
								</time>
							</div>
					<?php endif; ?>

					<?php if ($params->get('show_hits')) : ?>
							<div class="hits">
								<span class="uk-margin-small-right fa fa-eye" aria-hidden="true"></span>
								<meta itemprop="interactionCount" content="UserPageVisits:<?php echo $item->hits; ?>">
								<?php echo $item->hits; ?>
							</div>
					<?php endif; ?>
				<?php endif; ?>
				</div>
				<hr class="uk-divider-icon">
			</div>
		<?php endif; ?>

		<?php // Content is generated by content plugin event "onContentBeforeDisplay" ?>
		<?php echo $item->event->beforeDisplayContent; ?>
		<?php if ($params->get('show_intro')) : ?>
			<div class="intro" itemprop="articleBody"> <?php echo HTMLHelper::_('string.truncateComplex', $item->introtext, $params->get('introtext_limit')); ?> </div>
		<?php endif; ?>

		<?php if ($useDefList && ($info == 1 || $info == 2)) : ?>
			<div class="uk-container uk-container-expand uk-margin uk-article-meta">
				<hr class="uk-divider-icon">
				<div class="uk-grid-small uk-child-width-auto uk-flex-middle" uk-grid="">
				<?php if ($info == 1) : ?>
					<?php if ($params->get('show_parent_category') && !empty($item->parent_id)) : ?>
							<div class="parent-category-name">
								<?php $title = $this->escape($item->parent_title); ?>
								<?php if ($params->get('link_parent_category') && $item->parent_id) : ?>
									<?php $url = '<a href="' . Route::_(
										RouteHelper::getCategoryRoute($item->parent_id, $item->parent_language)
										)
										. '" itemprop="genre">' . $title . '</a>'; ?>
									<?php echo Text::sprintf('COM_CONTENT_PARENT', $url); ?>
								<?php else : ?>
									<?php echo Text::sprintf('COM_CONTENT_PARENT', '<span itemprop="genre">' . $title . '</span>'); ?>
								<?php endif; ?>
							</div>
					<?php endif; ?>
					<?php if ($params->get('show_category')) : ?>
							<div class="category-name">
								<?php $title = $this->escape($item->category_title); ?>
								<?php if ($params->get('link_category') && $item->catid) : ?>
									<?php $url = '<a href="' . Route::_(
										RouteHelper::getCategoryRoute($item->catid, $item->category_language)
										)
										. '" itemprop="genre">' . $title . '</a>'; ?>
									<?php echo Text::sprintf('COM_CONTENT_CATEGORY', $url); ?>
								<?php else : ?>
									<?php echo Text::sprintf('COM_CONTENT_CATEGORY', '<span itemprop="genre">' . $title . '</span>'); ?>
								<?php endif; ?>
							</div>
					<?php endif; ?>
					<?php if ($params->get('show_publish_date')) : ?>
							<div class="published">
								<span class="icon-calendar-alt" aria-hidden="true"></span>
								<time datetime="<?php echo HTMLHelper::_('date', $item->publish_up, 'c'); ?>" itemprop="datePublished">
									<?php echo Text::sprintf('COM_CONTENT_PUBLISHED_DATE_ON', HTMLHelper::_('date', $item->publish_up, Text::_('DATE_FORMAT_LC3'))); ?>
								</time>
							</div>
					<?php endif; ?>
				<?php endif; ?>

				<?php if ($params->get('show_create_date')) : ?>
						<div class="create">
							<span class="uk-margin-small-right" uk-icon="icon: calendar;" aria-hidden="true"></span>
							<time datetime="<?php echo HTMLHelper::_('date', $item->created, 'c'); ?>" itemprop="dateCreated">
								<?php echo Text::sprintf('COM_CONTENT_CREATED_DATE_ON', HTMLHelper::_('date', $item->modified, Text::_('DATE_FORMAT_LC3'))); ?>
							</time>
						</div>
				<?php endif; ?>
				<?php if ($params->get('show_modify_date')) : ?>
						<div class="modified">
							<span class="uk-margin-small-right" uk-icon="icon: calendar;" aria-hidden="true"></span>
							<time datetime="<?php echo HTMLHelper::_('date', $item->modified, 'c'); ?>" itemprop="dateModified">
								<?php echo Text::sprintf('COM_CONTENT_LAST_UPDATED', HTMLHelper::_('date', $item->modified, Text::_('DATE_FORMAT_LC3'))); ?>
							</time>
						</div>
				<?php endif; ?>
				<?php if ($params->get('show_hits')) : ?>
						<div class="hits">
							<span class="uk-margin-small-right fa fa-eye" aria-hidden="true"></span>
							<meta content="UserPageVisits:<?php echo $item->hits; ?>" itemprop="interactionCount">
							<?php echo $item->hits; ?>
						</div>
				<?php endif; ?>
			</div>
		</div>
		<?php endif; ?>
		<?php // Content is generated by content plugin event "onContentAfterDisplay" ?>
		<?php echo $item->event->afterDisplayContent; ?>
	</div>
	</article>
	<?php endforeach; ?>
	
	<div class="uk-margin uk-grid-small" uk-grid="">
		<?php if ($this->params->def('show_pagination_results', 1)) : ?>
			<div class="uk-width-1-1">
				<p class="com-content-archive__counter counter float-end pt-3 pe-2">
					<?php echo $this->pagination->getPagesCounter(); ?>
				</p>
			</div>
		<?php endif; ?>
		<div class="com-content-archive__pagination uk-width-1-1 uk-flex uk-flex-center">
			<?php echo $this->pagination->getPagesLinks(); ?>
		</div>
	</div>
