<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	html
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;


// include config and layout
$base = dirname(dirname(dirname(__FILE__)));
include($base.'/config.php');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;


$doc = Factory::getDocument();
$month = array('', Text::_('JANUARY'), Text::_('FEBRUARY'), Text::_('MARCH'), Text::_('APRIL'), Text::_('MAY'), Text::_('JUNE'), Text::_('JULY'), Text::_('AUGUST'), Text::_('SEPTEMBER'), Text::_('OCTOBER'), Text::_('NOVEMBER'), Text::_('DECEMBER'));

// month
if(isset($_POST['month']) && $_POST['month']) {
	$selected_val_post_month = $month[$_POST['month']];
	$selected_val_get_month = '';
}
else if (isset($_GET['month']) && $_GET['month'])
{
	$selected_val_get_month = $month[$_GET['month']];
	$selected_val_post_month = '';
}

// year
if(isset($_POST['year']) && $_POST['year']) {
	$selected_val_post_year = ' ' . $_POST['year'];
	$selected_val_get_year = '';
}
else if (isset($_GET['year']) && $_GET['year'])
{ 
	$selected_val_get_year = ' ' . $_GET['year'];
	$selected_val_post_year = '';
}

if (!empty($selected_val_get_month) && !empty($selected_val_get_year) )
{
	$doc->setTitle( $doc->getTitle() . ' | ' . $selected_val_get_month . $selected_val_get_year );
	$doc->setDescription( $doc->getMetaData('description') . ' - ' . $selected_val_get_month . $selected_val_get_year );
}
else if (!empty($selected_val_post_month) && !empty($selected_val_post_year))
{
	$doc->setTitle( $doc->getTitle() . ' | ' . $selected_val_post_month . $selected_val_post_year );
	$doc->setDescription( $doc->getMetaData('description') . ' - ' . $selected_val_post_month . $selected_val_post_year );
}
else if (!empty($selected_val_post_month))
{
	$doc->setTitle( $doc->getTitle() . ' | ' . $selected_val_post_month );
	$doc->setDescription( $doc->getMetaData('description') . ' - ' . $selected_val_post_month );
}
else if (!empty($selected_val_get_month))
{
	$doc->setTitle( $doc->getTitle() . ' | ' . $selected_val_get_month );
	$doc->setDescription( $doc->getMetaData('description') . ' - ' . $selected_val_get_month );
}
else if (!empty($selected_val_post_year))
{
	$doc->setTitle( $doc->getTitle() . ' | ' . $selected_val_post_year );
	$doc->setDescription( $doc->getMetaData('description') . ' - ' . $selected_val_post_year );
}
else if (!empty($selected_val_get_year))
{
	$doc->setTitle( $doc->getTitle() . ' | ' . $selected_val_get_year );
	$doc->setDescription( $doc->getMetaData('description') . ' - ' . $selected_val_get_year );
}


?>
<div class="com-content-archive archive">
	<?php if ($this->params->get('show_page_heading')) : ?>
		<div class="page-header">
			<h1>
				<?php echo $this->escape($this->params->get('page_heading')); ?>
			</h1>
		</div>
	<?php endif; ?>

	<form id="adminForm" action="<?php echo Route::_('index.php'); ?>" method="post" class="com-content-archive__form">
		<fieldset class="uk-fieldset">
		<div class="uk-text-center" uk-grid="">
			<?php if ($this->params->get('filter_field') !== 'hide') : ?>
			<div class="uk-width-auto@m">
				<div>
					<div class="uk-form-controls"><input type="text" name="filter-search" id="filter-search" value="<?php echo $this->escape($this->filter); ?>" class="uk-input" onchange="document.getElementById('adminForm').submit();" placeholder="<?php echo Text::_('COM_CONTENT_TITLE_FILTER_LABEL'); ?>"></div>
				</div>
			</div>
			<?php endif; ?>

			<div class="uk-width-expand@m">
				<div class="uk-child-width-auto uk-grid-small uk-flex-right" uk-grid="">
					<div>
						<div uk-form-custom="target: > * > span:first-child">
							<?php echo $this->form->monthField; ?>
							<button class="uk-button uk-button-default" type="button" tabindex="-1">
								<span></span>
								<span uk-icon="icon: chevron-down"></span>
							</button>
						</div>
					</div>
					<div>
						<div uk-form-custom="target: > * > span:first-child">
							<?php echo $this->form->yearField; ?>
							<button class="uk-button uk-button-default" type="button" tabindex="-1">
								<span></span>
								<span uk-icon="icon: chevron-down"></span>
							</button>
						</div>
					</div>
					<div>
						<div uk-form-custom="target: > * > span:first-child">
							<?php echo $this->form->limitField; ?>
							<button class="uk-button uk-button-default" type="button" tabindex="-1">
								<span></span>
								<span uk-icon="icon: chevron-down"></span>
							</button>
						</div>
					</div>

					<div>
						<button type="submit" class="uk-button uk-button-primary"><?php echo Text::_('JGLOBAL_FILTER_BUTTON'); ?></button>
						<input type="hidden" name="view" value="archive">
						<input type="hidden" name="option" value="com_content">
						<input type="hidden" name="limitstart" value="0">
					</div>
				</div>
			</div>
		</div>
		</fieldset>
	</form>
	
	<div class="uk-margin-large">
		<?php echo $this->loadTemplate('items'); ?>
	</div>

</div>
