<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	html
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;


use Joomla\CMS\Language\Text;
use Joomla\CMS\String\PunycodeHelper;

/**
 * Marker_class: Class based on the selection of text, none, or icons
 * jicon-text, jicon-none, jicon-icon
 */ ?>
 
<dl class="com-contact__address contact-address uk-description-list" itemprop="address" itemscope itemtype="https://schema.org/PostalAddress">
	<?php if (($this->params->get('address_check') > 0) &&
		($this->item->address || $this->item->suburb  || $this->item->state || $this->item->country || $this->item->postcode)) : ?>
		<dt>
			<?php if (!$this->params->get('marker_address')) : ?>
				<span class="icon-address" aria-hidden="true"></span><span class="sr-only"><?php echo Text::_('COM_CONTACT_ADDRESS'); ?></span>
			<?php else : ?>
				<span class="<?php echo $this->params->get('marker_class'); ?>">
					<?php echo $this->params->get('marker_address'); ?>
				</span>
			<?php endif; ?>
		</dt>

		<?php if ($this->item->address && $this->params->get('show_street_address')) : ?>
			<dd>
				<span class="contact-street" itemprop="streetAddress">
					<?php echo nl2br($this->item->address); ?>
					<br>
				</span>
			</dd>
		<?php endif; ?>

		<?php if ($this->item->suburb && $this->params->get('show_suburb')) : ?>
			<dd>
				<span class="contact-suburb" itemprop="addressLocality">
					<?php echo $this->item->suburb; ?>
					<br>
				</span>
			</dd>
		<?php endif; ?>
		<?php if ($this->item->state && $this->params->get('show_state')) : ?>
			<dd>
				<span class="contact-state" itemprop="addressRegion">
					<?php echo $this->item->state; ?>
					<br>
				</span>
			</dd>
		<?php endif; ?>
		<?php if ($this->item->postcode && $this->params->get('show_postcode')) : ?>
			<dd>
				<span class="contact-postcode" itemprop="postalCode">
					<?php echo $this->item->postcode; ?>
					<br>
				</span>
			</dd>
		<?php endif; ?>
		<?php if ($this->item->country && $this->params->get('show_country')) : ?>
			<dd>
				<span class="contact-country" itemprop="addressCountry">
					<?php echo $this->item->country; ?>
					<br>
				</span>
			</dd>
		<?php endif; ?>
	<?php endif; ?>

<?php if ($this->item->email_to && $this->params->get('show_email')) : ?>
	<dt>
		<?php if (!$this->params->get('marker_email')) : ?>
			<span class="icon-envelope" aria-hidden="true"></span><span class="sr-only"><?php echo Text::_('COM_CONTACT_EMAIL'); ?>"></span>
		<?php else : ?>
			<span class="<?php echo $this->params->get('marker_class'); ?>">
				<?php echo $this->params->get('marker_email'); ?>
			</span>
		<?php endif; ?>
	</dt>
	<dd>
		<span class="contact-emailto">
			<?php echo $this->item->email_to; ?>
		</span>
	</dd>
<?php endif; ?>

<?php if ($this->item->telephone && $this->params->get('show_telephone')) : ?>
	<dt>
		<?php if (!$this->params->get('marker_telephone')) : ?>
				<span class="icon-phone" aria-hidden="true"></span><span class="sr-only"><?php echo Text::_('COM_CONTACT_TELEPHONE'); ?></span>
		<?php else : ?>
			<span class="<?php echo $this->params->get('marker_class'); ?>">
				<?php echo $this->params->get('marker_telephone'); ?>
			</span>
		<?php endif; ?>
	</dt>
	<dd>
		<span class="contact-telephone" itemprop="telephone">
			<?php echo $this->item->telephone; ?>
		</span>
	</dd>
<?php endif; ?>
<?php if ($this->item->fax && $this->params->get('show_fax')) : ?>
	<dt>
		<?php if (!$this->params->get('marker_fax')) : ?>
			<span class="icon-fax" aria-hidden="true"></span><span class="sr-only"><?php echo Text::_('COM_CONTACT_FAX'); ?></span>
		<?php else : ?>
			<span class="<?php echo $this->params->get('marker_class'); ?>">
				<?php echo $this->params->get('marker_fax'); ?>
			</span>
		<?php endif; ?>
	</dt>
	<dd>
		<span class="contact-fax" itemprop="faxNumber">
		<?php echo $this->item->fax; ?>
		</span>
	</dd>
<?php endif; ?>
<?php if ($this->item->mobile && $this->params->get('show_mobile')) : ?>
	<dt>
		<?php if (!$this->params->get('marker_mobile')) : ?>
			<span class="icon-mobile" aria-hidden="true"></span><span class="sr-only"><?php echo Text::_('COM_CONTACT_MOBILE'); ?></span>
		<?php else : ?>
			<span class="<?php echo $this->params->get('marker_class'); ?>">
				<?php echo $this->params->get('marker_mobile'); ?>
			</span>
		<?php endif; ?>
	</dt>
	<dd>
		<span class="contact-mobile" itemprop="telephone">
			<?php echo $this->item->mobile; ?>
			<br>
		</span>
	</dd>
<?php endif; ?>
<?php if ($this->item->webpage && $this->params->get('show_webpage')) : ?>
	<dt>
		<?php if (!$this->params->get('marker_webpage')) : ?>
			<span class="icon-home" aria-hidden="true"></span><span class="sr-only"><?php echo Text::_('COM_CONTACT_WEBPAGE'); ?></span>
		<?php else : ?>
			<span class="<?php echo $this->params->get('marker_class'); ?>">
				<?php echo $this->params->get('marker_webpage'); ?>
			</span>
		<?php endif; ?>
	</dt>
	<dd>
		<span class="contact-webpage">
			<a href="<?php echo $this->item->webpage; ?>" target="_blank" rel="noopener noreferrer" itemprop="url">
			<?php echo PunycodeHelper::urlToUTF8($this->item->webpage); ?></a>
		</span>
	</dd>
<?php endif; ?>
</dl>
