<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	html
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;


use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\Component\Contact\Site\Helper\RouteHelper;

if ($this->maxLevel != 0 && count($this->children[$this->category->id]) > 0) :
?>
<ul class="com-contact-category__children list-striped list-condensed">
<?php foreach ($this->children[$this->category->id] as $id => $child) : ?>
	<?php if ($this->params->get('show_empty_categories') || $child->numitems || count($child->getChildren())) : ?>
	<li>
		<h4 class="item-title">
			<a href="<?php echo Route::_(RouteHelper::getCategoryRoute($child->id, $child->language)); ?>">
			<?php echo $this->escape($child->title); ?>
			</a>

			<?php if ($this->params->get('show_cat_items') == 1) : ?>
				<span class="badge badge-info float-right" title="<?php echo Text::_('COM_CONTACT_CAT_NUM'); ?>"><?php echo $child->numitems; ?></span>
			<?php endif; ?>
		</h4>

		<?php if ($this->params->get('show_subcat_desc') == 1) : ?>
			<?php if ($child->description) : ?>
				<div class="category-desc">
					<?php echo HTMLHelper::_('content.prepare', $child->description, '', 'com_contact.category'); ?>
				</div>
			<?php endif; ?>
		<?php endif; ?>

		<?php if (count($child->getChildren()) > 0 ) :
			$this->children[$child->id] = $child->getChildren();
			$this->category = $child;
			$this->maxLevel--;
			echo $this->loadTemplate('children');
			$this->category = $child->getParent();
			$this->maxLevel++;
		endif; ?>
	</li>
	<?php endif; ?>
<?php endforeach; ?>
</ul>
<?php endif; ?>
