<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	Template
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;


use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

// get warp
$warp = require(__DIR__ . '/warp.php');

// set messages
$title   = $this->title;
$error   = $this->error->getCode();
$message = $this->error->getMessage();

// set 404 messages
if ($error === '404') {
	$title   = Text::_('TPL_WARP_404_PAGE_TITLE');
	$message = Text::sprintf('TPL_WARP_404_PAGE_MESSAGE', URI::root());
}

// render error layout
echo $warp['template']->render('error', compact('title', 'error', 'message'));
