<?php

/**
 * * @package J2Store
 * * @copyright Copyright (c)2014-17 Ramesh Elamathi / J2Store.org
 * * * *
 * @author    Stephan W.
 * @author    url   https://www.ui-themebuilder.com/
 *
 * @developer Stephan Wittling - https://www.ui-themebuilder.com/
 *               J2Store APP Plugin "UIKit 3" is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 *
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

use Joomla\CMS\Language\Text;

// No direct access
defined('_JEXEC') or die;

$columns = $this->params->get('item_related_product_columns', 3);
$total = count($this->up_sells);
$counter = 0;
$platform = J2Store::platform();
?>

<div class="product-upsells-container uk-grid-row-small" uk-grid="">
    <div class="uk-width-1-1">

        <div class="uk-flex uk-flex-center" uk-grid="">
            <div class="uk-width-3-4@l">
                <hr class="uk-divider-icon">
            </div>
        </div>

        <div class="uk-flex uk-flex-middle" uk-grid="">

            <div class="uk-width-auto">
                <h3 class="uk-heading-bullet"><?php echo Text::_('J2STORE_RELATED_PRODUCTS_UPSELLS'); ?></h3>
            </div>

            <div class="uk-width-expand">
            <?php foreach ($this->up_sells as $upsell_product) :?>
                <?php
                $upsell_product->product_link = $platform->getProductUrl(array('task' => 'view', 'id' => $upsell_product->j2store_product_id));
                if (!empty($upsell_product->addtocart_text)) {
                    $cart_text = Text::_($upsell_product->addtocart_text);
                } else {
                    $cart_text = Text::_('J2STORE_ADD_TO_CART');
                }
                $upsell_product_name = $this->escape($upsell_product->product_name);
                ?>


                <?php $rowcount = ((int) $counter % (int) $columns) + 1; ?>
                <?php if ($rowcount == 1) : ?>
                    <div class="upsell-product-row uk-grid-small" uk-grid="">
                <?php endif;?>

                <?php $upsell_css = ''?>
                <?php if (!in_array($upsell_product->product_type, array('variable','flexivariable'))) : ?>
                    <?php  $upsell_css = $upsell_product->params->get('product_css_class', '');?>
                <?php endif; ?>

                        <div class="uk-width-1-<?php echo $columns?> upsell-product product-<?php echo $upsell_product->j2store_product_id;?> <?php echo isset($upsell_css) ? $upsell_css : ''; ?>">

                            <div class="uk-card uk-card-small uk-card-default uk-card-hover">
                                <?php
                                $thumb_image = '';
                                $width = '';
                                $height = '';
                                if (isset($upsell_product->thumb_image) && $upsell_product->thumb_image) {
                                    $thumb_image = $platform->getImagePath($upsell_product->thumb_image);

                                    $imageInfo = getimagesize($thumb_image);
                                    if ($imageInfo !== false) {
                                        // Breite und Höhe aus dem Array extrahieren
                                        $width = $imageInfo[0];
                                        $height = $imageInfo[1];
                                    }
                                }

                                if (isset($thumb_image) &&  !empty($thumb_image)) :?>
                                    <div class="uk-card-media-top uk-cover-container">
                                        <img title="<?php echo $upsell_product_name ;?>"
                                             alt="<?php echo $upsell_product_name ;?>"
                                             class="j2store-product-thumb-image-<?php echo $upsell_product->j2store_product_id; ?>"
                                             src="<?php echo $thumb_image;?>"
                                             width="<?php echo $width;?>" height="<?php echo $height;?>" uk-img="" uk-cover=""/>
                                        <canvas class="uk-height-small"></canvas>
                                    </div>
                                <?php endif; ?>
                                <div class="uk-card-header">
                                    <div class="uk-grid-small uk-flex-middle" uk-grid>
                                        <div class="uk-width-auto">
                                            <?php if (J2Store::product()->canShowprice($this->params)) : ?>
                                                <?php
                                                $this->singleton_product = $upsell_product;
                                                $this->singleton_params = $this->params;
                                                echo $this->loadAnyTemplate('site:com_j2store/products/price');
                                                ?>
                                            <?php endif; ?>
                                        </div>
                                        <div class="uk-width-expand">
                                            <h4 class="uk-margin-remove-bottom uk-text-truncate"><?php echo $upsell_product_name; ?></h4>
                                            <?php if (!empty($upsell_product->variant->sku)) : ?>
                                                <p class="uk-text-meta uk-margin-remove-top"><?php echo $this->escape($upsell_product->variant->sku); ?></p>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="uk-card-body uk-text-center">
                                    <?php if (J2Store::product()->canShowCart($this->params)) : ?>
                                        <?php $upsell_option = isset($upsell_product->options) && is_array($upsell_product->options) ? count($upsell_product->options) : 0; ?>
                                        <?php if ($upsell_option || $upsell_product->product_type == 'variable') : ?>
                                            <a class="<?php echo $this->params->get('choosebtn_class', 'uk-button uk-button-primary'); ?>"
                                               href="<?php echo $upsell_product->product_link; ?>">
                                                <?php echo Text::_('J2STORE_CART_CHOOSE_OPTIONS'); ?>
                                            </a>
                                        <?php else : ?>
                                            <?php
                                            $this->singleton_product = $upsell_product;
                                            $this->singleton_params = $this->params;
                                            $this->singleton_cartext = $this->escape($cart_text);
                                            echo $this->loadAnyTemplate('site:com_j2store/products/cart');
                                            ?>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                <?php $counter++; ?>
                <?php if (($rowcount == $columns) or ($counter == $total)) : ?>
                    </div>
                <?php endif; ?>
            <?php endforeach;?>
            </div>
        </div>
    </div>
</div>
