<?php

/**
 * * @package J2Store
 * * @copyright Copyright (c)2014-17 Ramesh Elamathi / J2Store.org
 * * * *
 * @author    Stephan W.
 * @author    url   https://www.ui-themebuilder.com/
 *
 * @developer Stephan Wittling - https://www.ui-themebuilder.com/
 *               J2Store APP Plugin "UIKit 3" is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 *
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

// No direct access
defined('_JEXEC') or die;
?>
<div class="product-<?php echo $this->product->j2store_product_id; ?> <?php echo $this->product->product_type; ?>-product" uk-grid="">
    <div class="uk-width-1-1">
        <div uk-grid="">
            <div class="uk-width-1-2">
                <?php $images = $this->loadTemplate('images');
                J2Store::plugin()->event('BeforeDisplayImages', array(&$images, $this, 'com_j2store.products.view.uikit3'));
                echo $images;
                ?>
            </div>

            <div class="uk-width-1-2">
                <div uk-grid="">
                    <div class="uk-width-1-1">
                        <?php echo $this->loadTemplate('title'); ?>
                        <?php if (isset($this->product->source->event->afterDisplayTitle)) : ?>
                            <?php echo $this->product->source->event->afterDisplayTitle; ?>
                        <?php endif;?>
                    </div>

                    <div class="uk-width-1-1">
                        <div class="uk-grid-divider uk-flex-middle" uk-grid="">
                            <?php if (J2Store::product()->canShowprice($this->params)) : ?>
                                <div class="uk-width-1-2">
                                    <?php echo $this->loadTemplate('price'); ?>
                                </div>
                            <?php endif; ?>

                            <div class="uk-width-1-2 uk-text-meta">
                                <?php if (isset($this->product->source->event->beforeDisplayContent)) : ?>
                                    <?php echo $this->product->source->event->beforeDisplayContent; ?>
                                <?php endif;?>
                                <?php if (J2Store::product()->canShowSku($this->params)) : ?>
                                    <?php echo $this->loadTemplate('sku'); ?>
                                <?php endif; ?>
                                <?php echo $this->loadTemplate('brand'); ?>
                                <?php if ($this->params->get('item_show_product_stock', 1) && J2Store::product()->managing_stock($this->product->variant)) : ?>
                                    <?php echo $this->loadTemplate('stock'); ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <?php if (J2Store::product()->canShowCart($this->params)) : ?>
                        <div class="uk-width-1-1">
                            <form action="<?php echo $this->product->cart_form_action; ?>"
                                  method="post" class="j2store-addtocart-form"
                                  id="j2store-addtocart-form-<?php echo $this->product->j2store_product_id; ?>"
                                  name="j2store-addtocart-form-<?php echo $this->product->j2store_product_id; ?>"
                                  data-product_id="<?php echo $this->product->j2store_product_id; ?>"
                                  data-product_type="<?php echo $this->product->product_type; ?>"
                                  enctype="multipart/form-data">
                                <div class="uk-grid-small uk-grid-row-small" uk-grid="">
                                    <?php echo $this->loadTemplate('options'); ?>
                                    <?php echo $this->loadTemplate('cart'); ?>
                                </div>
                            </form>
                        </div>
                    <?php endif; ?>

                    <?php if ($this->params->get('item_use_tabs', 1)) : ?>
                        <?php echo $this->loadTemplate('tabs'); ?>
                    <?php else : ?>
                        <?php echo $this->loadTemplate('notabs'); ?>
                    <?php endif; ?>

                    <?php if (isset($this->product->source->event->afterDisplayContent)) : ?>
                        <?php echo $this->product->source->event->afterDisplayContent; ?>
                    <?php endif;?>
                </div>
            </div>
        </div>
    </div>

</div>

<?php if ($this->params->get('item_show_product_upsells', 0) && count($this->up_sells)) : ?>
    <?php echo $this->loadTemplate('upsells'); ?>
<?php endif;?>

<?php if ($this->params->get('item_show_product_cross_sells', 0) && count($this->cross_sells)) : ?>
    <?php echo $this->loadTemplate('crosssells'); ?>
<?php endif;?>

