<?php

/**
 * * @package J2Store
 * * @copyright Copyright (c)2014-17 Ramesh Elamathi / J2Store.org
 * * * *
 * @author    Stephan W.
 * @author    url   https://www.ui-themebuilder.com/
 *
 * @developer Stephan Wittling - https://www.ui-themebuilder.com/
 *               J2Store APP Plugin "UIKit 3" is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 *
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

use Joomla\CMS\Language\Text;

// No direct access
defined('_JEXEC') or die;

$columns = $this->params->get('item_related_product_columns', 3);
$total = count($this->cross_sells);
$counter = 0;
$cross_image_width = $this->params->get('item_product_cross_image_width', '100');
$platform = J2Store::platform();
?>

<div class="row product-crosssells-container" uk-grid="">
    <div class="uk-width-1-1">

        <div class="uk-flex uk-flex-center" uk-grid="">
            <div class="uk-width-3-4@l">
                <h3 class="uk-heading-line uk-text-center"><span><?php echo Text::_('J2STORE_RELATED_PRODUCTS_CROSS_SELLS'); ?></span></h3>
            </div>
        </div>

        <div class="" uk-grid="">

            <div class="uk-width-1-1">

                <?php foreach ($this->cross_sells as $cross_sell_product) :?>


                    <?php
                    $cross_sell_product->product_link = $platform->getProductUrl(array('task' => 'view', 'id' => $cross_sell_product->j2store_product_id));
                    //JRoute::_('index.php?option=com_j2store&view=products&task=view&id='.$cross_sell_product->j2store_product_id);
                    if (!empty($cross_sell_product->addtocart_text)) {
                        $cart_text = Text::_($cross_sell_product->addtocart_text);
                    } else {
                        $cart_text = Text::_('J2STORE_ADD_TO_CART');
                    }
                    $cross_product_name = $this->escape($cross_sell_product->product_name);
                    ?>

                    <?php $rowcount = ((int) $counter % (int) $columns) + 1; ?>
                    <?php if ($rowcount == 1) : ?>
                    <?php $row = $counter / $columns; ?>
                        <div class="crosssell-product-row <?php echo 'row-'.$row; ?>" uk-grid="">
                    <?php endif;?>

                            <?php $cross_sell_css = ''; ?>
                            <?php if (!in_array($cross_sell_product->product_type, array('variable','flexivariable'))) : ?>
                                <?php  $cross_sell_css = $cross_sell_product->params->get('product_css_class', '');?>
                            <?php endif; ?>
                            <div class="uk-width-1-<?php echo $columns;?> col-sm-<?php // echo round((12 / $columns));?> upsell-product product-<?php echo $cross_sell_product->j2store_product_id;?> <?php echo isset($cross_sell_css) ? $cross_sell_css : ''; ?>">

                                <?php
                                $thumb_image = '';
                                if (isset($cross_sell_product->thumb_image) && $cross_sell_product->thumb_image) {
                                    $thumb_image = $platform->getImagePath($cross_sell_product->thumb_image);
                                }
                                ?>

                                <div class="uk-flex-middle uk-grid-small" uk-grid="">
                                    <div class="uk-width-2-3@m">
                                        <h4 class="cross-sell-product-title uk-margin-small-bottom uk-text-truncate">
                                            <?php if (empty($thumb_image)) :?>
                                            <a href="<?php echo $cross_sell_product->product_link; ?>">
                                                <?php echo $cross_product_name; ?>
                                            </a>
                                            <?php else : ?>
                                                <?php echo $cross_product_name; ?>
                                            <?php endif; ?>
                                        </h4>
                                        <?php if (J2Store::product()->canShowprice($this->params)) : ?>
                                            <?php
                                            $this->singleton_product = $cross_sell_product;
                                            $this->singleton_params = $this->params;
                                            echo $this->loadAnyTemplate('site:com_j2store/products/price');
                                            ?>
                                        <?php endif; ?>

                                        <?php if (J2Store::product()->canShowCart($this->params)) : ?>
                                            <?php if (count($cross_sell_product->options) || $cross_sell_product->product_type == 'variable') : ?>
                                                <a class="<?php echo $this->params->get('choosebtn_class', 'uk-button uk-button-text'); ?>"
                                                   href="<?php echo $cross_sell_product->product_link; ?>">
                                                    <?php echo Text::_('J2STORE_CART_CHOOSE_OPTIONS'); ?>
                                                </a>
                                            <?php else : ?>
                                                <?php
                                                $this->singleton_product = $cross_sell_product;
                                                $this->singleton_params = $this->params;
                                                $this->singleton_cartext = $this->escape($cart_text);
                                                echo $this->loadAnyTemplate('site:com_j2store/products/cart');
                                                ?>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                    <?php if (!empty($thumb_image)) :?>
                                        <div class="uk-width-1-3@m uk-flex-first">
                                            <a href="<?php echo $cross_sell_product->product_link; ?>">
                                                <img title="<?php echo $cross_product_name ;?>"
                                                     alt="<?php echo $cross_product_name ;?>"
                                                     class="j2store-product-thumb-image-<?php echo $cross_sell_product->j2store_product_id; ?>"
                                                     src="<?php echo $thumb_image;?>"
                                                     width="<?php // echo intval($cross_image_width);?>"/>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                    <?php $counter++; ?>
                    <?php if (($rowcount == $columns) or ($counter == $total)) : ?>
                        </div>
                    <?php endif; ?>

                <?php endforeach;?>
            </div>
        </div>
    </div>
</div>
