<?php

/**
 * * @package J2Store
 * * @copyright Copyright (c)2014-17 Ramesh Elamathi / J2Store.org
 * * * *
 * @author    Stephan W.
 * @author    url   https://www.ui-themebuilder.com/
 *
 * @developer Stephan Wittling - https://www.ui-themebuilder.com/
 *               J2Store APP Plugin "UIKit 3" is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 *
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

// No direct access
defined('_JEXEC') or die;
?>
<div class="j2store-single-product <?php echo $this->product->product_type; ?> detail <?php echo $this->product->params->get('product_css_class', '');?>">
    <?php if ($this->params->get('item_show_page_heading')) : ?>
        <div class="page-header">
            <h1> <?php echo $this->escape($this->params->get('page_heading')); ?> </h1>
        </div>
    <?php endif; ?>
<?php echo J2Store::modules()->loadposition('j2store-single-product-top'); ?>
    <?php if ($this->params->get('item_show_back_to', 0) && isset($this->back_link) && !empty($this->back_link)) :?>
        <div class="uk-margin">
            <a href="<?php echo $this->back_link; ?>" class="uk-button uk-button-text">
                <i class="fa fa-chevron-left"> </i> <?php echo JText::_('J2STORE_PRODUCT_BACK_TO').' '.$this->back_link_title; ?>
            </a>
        </div>
    <?php endif;?>
    <?php echo $this->loadTemplate($this->product->product_type); ?>
    <?php echo J2Store::plugin()->eventWithHtml('AfterProductDisplay', array($this->product,$this))?>
<?php echo J2Store::modules()->loadposition('j2store-single-product-bottom'); ?>
</div>

