<?php

/**
 * * @package J2Store
 * * @copyright Copyright (c)2014-17 Ramesh Elamathi / J2Store.org
 * * * *
 * @author    Stephan W.
 * @author    url   https://www.ui-themebuilder.com/
 *
 * @developer Stephan Wittling - https://www.ui-themebuilder.com/
 *               J2Store APP Plugin "UIKit 3" is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 *
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

// No direct access
use Joomla\CMS\Language\Text;

defined('_JEXEC') or die;

?>
    <div class="product-stock-container">
        <?php if (J2Store::product()->managing_stock($this->product->variant)) :?>
            <?php if ($this->product->variant->availability) : ?>
            <span class="uk-label <?php echo $this->product->variant->availability ? 'uk-label-success':'uk-label-danger'; ?>">
                <?php echo J2Store::product()->displayStock($this->product->variant, $this->params); ?>
            </span>
            <?php elseif (!isset($this->product->all_sold_out) || (isset($this->product->all_sold_out) && $this->product->all_sold_out)) : ?>
                <span class="uk-label uk-label-danger">
                    <?php echo Text::_('J2STORE_OUT_OF_STOCK'); ?>
                </span>
            <?php endif; ?>
        <?php endif; ?>
    </div>

    <?php if ($this->product->variant->allow_backorder == 2 && !$this->product->variant->availability) : ?>
        <span class="backorder-notification">
            <?php echo Text::_('J2STORE_BACKORDER_NOTIFICATION'); ?>
        </span>
    <?php endif; ?>
