<?php

/**
 * * @package J2Store
 * * @copyright Copyright (c)2014-17 Ramesh Elamathi / J2Store.org
 * * * *
 * @author    Stephan W.
 * @author    url   https://www.ui-themebuilder.com/
 *
 * @developer Stephan Wittling - https://www.ui-themebuilder.com/
 *               J2Store APP Plugin "UIKit 3" is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 *
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

// No direct access
defined('_JEXEC') or die;
$session = Factory::getApplication()->getSession();
$filter_catid = isset($this->filter_catid) ? $this->filter_catid : '';
?>
<?php  $currency = $this->currency->getSymbol();?>
<form class="uk-form-horizontal uk-margin" id="productFilters" name="productfilters"  action="<?php echo JRoute::_('index.php');?>" data-link="<?php echo JRoute::_($this->active_menu->link.'&Itemid='.$this->active_menu->id);?>" method="post">
        <input type="hidden" name="filter_catid" id="sort_filter_catid"  value ="<?php echo $filter_catid;?>" />
        <?php if ($this->params->get('list_show_filter_search')) :?>
            <?php $search = htmlspecialchars($this->state->search);?>
            <?php echo J2html::text('search', $search, array('class' => 'j2store-product-search-input uk-input uk-form-width-medium'));?>
            <input type="button" value="<?php echo Text::_('J2STORE_FILTER_GO');?>"
                                    class="uk-button uk-button-primary"
                                    onclick="jQuery(this.form).submit();" />
                <input type="button" value="<?php echo Text::_('J2STORE_FILTER_RESET');?>"
                            class="uk-button uk-button-default"
                            onclick="resetJ2storeFilter();" />

        <?php endif;?>
        <!-- Sorting -->
        <?php if ($this->params->get('list_show_filter_sorting')) :?>
            <?php
            echo J2Html::select()->clearState()
                    ->type('genericlist')
                    ->name('sortby')
                    ->attribs(array('class' => 'input uk-select','onchange' => 'jQuery(this.form).submit()'))
                    ->value($this->state->sortby)
                    ->setPlaceHolders($this->filters['sorting'])->getHtml();
            ?>
        <?php endif;?>

    <?php echo J2Html::hidden('option', 'com_j2store');?>
    <?php echo J2Html::hidden('view', 'products');?>
    <?php echo J2Html::hidden('task', 'browse');?>
    <?php echo J2Html::hidden('Itemid', Factory::getApplication()->input->getUint('Itemid'));?>
    <?php echo JHTML::_('form.token'); ?>
</form>

<script type="text/javascript">
function resetJ2storeFilter(){
    jQuery(".j2store-product-search-input").val("");
    jQuery("#productFilters").submit();
}
</script>