<?php

/**
 * * @package J2Store
 * * @copyright Copyright (c)2014-17 Ramesh Elamathi / J2Store.org
 * * * *
 * @author    Stephan W.
 * @author    url   https://www.ui-themebuilder.com/
 *
 * @developer Stephan Wittling - https://www.ui-themebuilder.com/
 *               J2Store APP Plugin "UIKit 3" is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 *
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

// No direct access
defined('_JEXEC') or die;

$image_path = Uri::root();
$main_image = "";
$main_image_width = $this->params->get('item_product_main_image_width', '200');
$additional_image_width = $this->params->get('item_product_additional_image_width', '100');
$platform = J2Store::platform();
$width = '';
$height = '';
?>
<div class="uk-grid-row-small" uk-grid="">
    <?php J2Store::plugin()->event('BeforeDisplayImages', array(&$images, $this, 'com_j2store.products.list.uikit3'));
    if ($this->params->get('item_show_product_main_image', 1) && !empty($this->product->main_image)) :
        $main_image = $platform->getImagePath($this->product->main_image);
        $imageInfo = getimagesize($main_image);
        if ($imageInfo !== false) {
            // Breite und Höhe aus dem Array extrahieren
            $width = $imageInfo[0];
            $height = $imageInfo[1];
        }
        ?>
        <?php if (!empty($main_image)) :?>
        <div class="uk-width-1-1">
            <div class="uk-text-center">
                <div class="uk-inline-clip" tabindex="0">
                    <img src="<?php echo $main_image;?>" width="<?php echo $width;?>" height="<?php echo $height;?>" title="<?php echo $this->escape($this->product->product_name);?>" alt="<?php echo (!empty($this->product->main_image_alt)) ? $this->escape($this->product->main_image_alt) : $this->escape($this->product->product_name); ?>">

                    <?php if ($this->params->get('list_show_product_stock', 1) && J2Store::product()->managing_stock($this->product->variant)) : ?>
                        <div class="uk-transition-slide-right uk-position-top-right uk-position-small"><?php echo $this->loadTemplate('stock'); ?></div>
                    <?php endif; ?>

                    <div class="uk-transition-slide-bottom uk-position-bottom uk-overlay uk-overlay-default uk-padding-small">
                        <div class="uk-text-small uk-margin-remove"><?php echo $this->loadTemplate('description'); ?></div>
                    </div>
                </div>
                <?php if ($this->params->get('list_show_title', 1)) : ?>
                    <h2 class="uk-margin-small-top uk-h4">
                        <?php if ($this->params->get('list_link_title', 1)) : ?>
                        <a class="uk-link-heading" href="<?php echo Route::_('index.php?option=com_j2store&view=products&task=view&id='.$this->product->j2store_product_id.'&Itemid='.$this->active_menu->id); ?>"
                           title="<?php echo $this->escape($this->product->product_name); ?>" >
                        <?php endif; ?>

                            <?php echo $this->product->product_name; ?>
                            <?php if ($this->params->get('list_link_title', 1)) : ?>
                        </a>
                            <?php endif; ?>
                    </h2>
                <?php endif; ?>
            </div>

        </div>
        <?php elseif (!empty($this->product->main_image)) :?>
            <?php echo J2Store::product()->displayImage($this->product, array('type' => 'ViewMain','params' => $this->params,'alt' => $this->escape($this->product->main_image_alt))); ?>
        <?php endif; ?>
    <?php endif; ?>

    <?php if (isset($this->product->event->afterDisplayTitle)) : ?>
        <?php echo $this->product->event->afterDisplayTitle; ?>
    <?php endif;?>

    <?php if (isset($this->product->event->beforeDisplayContent)) : ?>
        <?php echo $this->product->event->beforeDisplayContent; ?>
    <?php endif;?>

    <?php if ($this->params->get('list_show_product_sku', 1) && J2Store::product()->canShowSku($this->params)) : ?>
        <div class="uk-width-1-1"><?php echo $this->loadTemplate('sku'); ?></div>
    <?php endif; ?>

    <div class="uk-width-1-1">
        <div class="uk-grid-small uk-flex-middle" uk-grid="">
            <?php if (J2Store::product()->canShowprice($this->params)) : ?>
                <div><?php echo $this->loadTemplate('price'); ?></div>
            <?php endif; ?>

            <?php if (J2Store::product()->canShowCart($this->params)) : ?>
                <div class="uk-margin-auto-left">
                    <form action="<?php echo $this->product->cart_form_action; ?>"
                            method="post" class="j2store-addtocart-form uk-margin-remove"
                            id="j2store-addtocart-form-<?php echo $this->product->j2store_product_id; ?>"
                            name="j2store-addtocart-form-<?php echo $this->product->j2store_product_id; ?>"
                            data-product_id="<?php echo $this->product->j2store_product_id; ?>"
                            data-product_type="<?php echo $this->product->product_type; ?>"
                            enctype="multipart/form-data">

                    <?php $cart_type = $this->params->get('list_show_cart', 1); ?>
                    <?php if ($cart_type == 1) : ?>
                        <?php echo $this->loadTemplate('options'); ?>
                        <?php echo $this->loadTemplate('cart'); ?>

                    <?php elseif (($cart_type == 2 && count($this->product->options)) || $cart_type == 3) :?>
                    <!-- we have options so we just redirect -->
                        <a href="<?php echo $this->product->product_link; ?>" class="<?php echo $this->params->get('choosebtn_class', 'uk-button uk-button-text'); ?>"><?php echo JText::_('J2STORE_VIEW_PRODUCT_DETAILS'); ?></a>
                    <?php else : ?>
                        <?php echo $this->loadTemplate('cart'); ?>
                    <?php endif; ?>

                    </form>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <?php if (isset($this->product->event->afterDisplayContent)) : ?>
        <?php echo $this->product->event->afterDisplayContent; ?>
    <?php endif;?>
</div>
