<?php

/**
 * * @package J2Store
 * * @copyright Copyright (c)2014-17 Ramesh Elamathi / J2Store.org
 * * * *
 * @author    Stephan W.
 * @author    url   https://www.ui-themebuilder.com/
 *
 * @developer Stephan Wittling - https://www.ui-themebuilder.com/
 *               J2Store APP Plugin "UIKit 3" is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 *
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

// No direct access
defined('_JEXEC') or die;

$image_path = Uri::root();
$main_image = "";
$platform = J2Store::platform();
?>

<?php J2Store::plugin()->event('BeforeDisplayImages', array(&$images, $this, 'com_j2store.products.list.uikit3')); ?>
<?php if($this->params->get('item_show_product_main_image', 1) && !empty($this->product->main_image)):?>
    <div class="uk-tile uk-padding-small">
        <div class="uk-card uk-card-default uk-card-small">

            <?php $main_image = $platform->getImagePath($this->product->main_image);
                $imageInfo = getimagesize($main_image);
                if ($imageInfo !== false) {
                    // Breite und Höhe aus dem Array extrahieren
                    $width = $imageInfo[0];
                    $height = $imageInfo[1];
                }
            ?>
            <div class="uk-card-media-top">
                <div class="uk-transition-toggle uk-cover-container" tabindex="0">
                    <img src="<?php echo $main_image;?>" title="<?php echo $this->escape($this->product->product_name);?>" alt="<?php echo (!empty($this->product->main_image_alt)) ? $this->escape($this->product->main_image_alt) : $this->escape($this->product->product_name); ?>" uk-img="" uk-cover="">
                    <canvas width="<?php echo $width; ?>" height="<?php echo $height; ?>"></canvas>
                    <div class="uk-transition-fade uk-position-cover uk-position-small uk-overlay uk-overlay-default uk-text-center uk-flex uk-flex-center uk-flex-middle">
                        <div>

                            <?php if(J2Store::product()->canShowprice($this->params)): ?>
                                <?php echo $this->loadTemplate('price'); ?>
                            <?php endif; ?>

                            <?php if(J2Store::product()->canShowCart($this->params)): ?>

                                <form action="<?php echo $this->product->cart_form_action; ?>"
                                      method="post" class="j2store-addtocart-form"
                                      id="j2store-addtocart-form-<?php echo $this->product->j2store_product_id; ?>"
                                      name="j2store-addtocart-form-<?php echo $this->product->j2store_product_id; ?>"
                                      data-product_id="<?php echo $this->product->j2store_product_id; ?>"
                                      data-product_type="<?php echo $this->product->product_type; ?>"
                                      enctype="multipart/form-data">

                                    <?php $cart_type = $this->params->get('list_show_cart', 1); ?>

                                    <?php if($cart_type == 1) : ?>
                                        <?php echo $this->loadTemplate('options'); ?>
                                        <?php echo $this->loadTemplate('cart'); ?>

                                    <?php elseif(($cart_type == 2 && count($this->product->options)) || $cart_type == 3):?>
                                        <!-- we have options so we just redirect -->
                                        <a href="<?php echo $this->product->product_link; ?>" class="<?php echo $this->params->get('choosebtn_class', 'uk-button uk-button-text'); ?>"><?php echo JText::_('J2STORE_VIEW_PRODUCT_DETAILS'); ?></a>
                                    <?php else: ?>
                                        <?php echo $this->loadTemplate('cart'); ?>
                                    <?php endif; ?>

                                </form>

                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="uk-card-body">
                <?php if($this->params->get('list_show_title', 1)): ?>
                    <h3 class="uk-card-title">
                        <?php if($this->params->get('list_link_title', 1)): ?>
                        <a class="uk-link-heading" href="<?php echo Route::_('index.php?option=com_j2store&view=products&task=view&id='.$this->product->j2store_product_id.'&Itemid='.$this->active_menu->id); ?>"
                           title="<?php echo $this->escape($this->product->product_name); ?>" >
                            <?php endif; ?>

                            <?php echo $this->product->product_name; ?>
                            <?php if($this->params->get('list_link_title', 1)): ?>
                        </a>
                    <?php endif; ?>
                    </h3>
                <?php endif; ?>

                <?php echo $this->loadTemplate('description'); ?>
            </div>
        </div>
    </div>
<?php else: ?>
    <div class="uk-tile uk-padding-small">
        <?php if($this->params->get('list_show_title', 1)): ?>
            <h2 class="uk-heading-line">
                <?php if($this->params->get('list_link_title', 1)): ?>
                <a class="uk-link-heading" href="<?php echo Route::_('index.php?option=com_j2store&view=products&task=view&id='.$this->product->j2store_product_id.'&Itemid='.$this->active_menu->id); ?>"
                   title="<?php echo $this->escape($this->product->product_name); ?>" >
                    <?php endif; ?>

                    <span><?php echo $this->product->product_name; ?></span>
                    <?php if($this->params->get('list_link_title', 1)): ?>
                </a>
            <?php endif; ?>
            </h2>
        <?php endif; ?>

        <?php if(isset($this->product->event->afterDisplayTitle)) : ?>
                <?php echo $this->product->event->afterDisplayTitle; ?>
        <?php endif;?>

        <?php if(isset($this->product->event->beforeDisplayContent)) : ?>
            <?php echo $this->product->event->beforeDisplayContent; ?>
        <?php endif;?>

        <?php echo $this->loadTemplate('description'); ?>

        <?php if(J2Store::product()->canShowprice($this->params)): ?>
        <?php echo $this->loadTemplate('price'); ?>
        <?php endif; ?>

        <?php if($this->params->get('list_show_product_sku', 1) &&  J2Store::product()->canShowSku($this->params)): ?>
            <?php echo $this->loadTemplate('sku'); ?>
        <?php endif; ?>

        <?php if($this->params->get('list_show_product_stock', 1) && J2Store::product()->managing_stock($this->product->variant)) : ?>
            <?php echo $this->loadTemplate('stock'); ?>
        <?php endif; ?>

        <?php if(J2Store::product()->canShowCart($this->params)): ?>

        <form action="<?php echo $this->product->cart_form_action; ?>"
                method="post" class="j2store-addtocart-form"
                id="j2store-addtocart-form-<?php echo $this->product->j2store_product_id; ?>"
                name="j2store-addtocart-form-<?php echo $this->product->j2store_product_id; ?>"
                data-product_id="<?php echo $this->product->j2store_product_id; ?>"
                data-product_type="<?php echo $this->product->product_type; ?>"
                enctype="multipart/form-data">

        <?php $cart_type = $this->params->get('list_show_cart', 1); ?>

        <?php if($cart_type == 1) : ?>
            <?php echo $this->loadTemplate('options'); ?>
            <?php echo $this->loadTemplate('cart'); ?>

        <?php elseif(($cart_type == 2 && count($this->product->options)) || $cart_type == 3):?>
        <!-- we have options so we just redirect -->
            <a href="<?php echo $this->product->product_link; ?>" class="<?php echo $this->params->get('choosebtn_class', 'uk-button uk-button-text'); ?>"><?php echo JText::_('J2STORE_VIEW_PRODUCT_DETAILS'); ?></a>
        <?php else: ?>
            <?php echo $this->loadTemplate('cart'); ?>
        <?php endif; ?>

        </form>

        <?php endif; ?>

        <?php if(isset($this->product->event->afterDisplayContent)) : ?>
            <?php echo $this->product->event->afterDisplayContent; ?>
        <?php endif;?>
    </div>
<?php endif; ?>
