<?php
/**
 * @package J2Store
 * @copyright Copyright (c)2014-17 Ramesh Elamathi / J2Store.org
 * @license GNU GPL v3 or later
 *
 * Bootstrap 2 layout of products
 */
// No direct access
use Joomla\CMS\Language\Text;

defined('_JEXEC') or die;
$platform = J2Store::platform();
$platform->addScript('j2store-filter', '/media/j2store/js/filter.js');
$url_params = array();
$item_id = '';
$active_link = $platform->getProductUrl($url_params, true);
if (isset($this->active_menu->id)) {
    $item_id = $this->active_menu->id;
    $url_params['Itemid'] = $this->active_menu->id;
    $active_link = $platform->getProductUrl($url_params, true);
}
$actionURL = $active_link;
$filter_position = $this->params->get('list_filter_position', 'right');
?>

<div class="j2store-product-list" data-link="<?php echo $active_link;?>">

    <?php echo J2Store::plugin()->eventWithHtml('BeforeViewProductListDisplay', array($this->products));?>
    <?php echo J2Store::modules()->loadposition('j2store-product-list-top'); ?>
    <?php if ($this->params->get('show_page_heading')) : ?>
        <div class="page-header">
            <h1> <?php echo $this->escape($this->params->get('page_heading')); ?> </h1>
        </div>
    <?php endif; ?>


    <div uk-grid>
    <?php
        //make sure filter is enable
    if ($this->params->get('list_show_filter', 0)) :?>
        <?php if ($filter_position == 'left') : ?>
            <div class="j2store-sidebar-filters-container uk-width-1-3">
                <?php echo J2Store::modules()->loadposition('j2store-filter-left-top'); ?>
                <?php echo $this->loadTemplate('filters');?>
                <?php echo J2Store::modules()->loadposition('j2store-filter-left-bottom'); ?>
            </div>
        <?php endif; ?>
    <?php endif; ?>

    <?php
        //make sure filter is enable
    if ($this->params->get('list_show_filter', 0)) :?>
        <div class="uk-width-expand">
    <?php else :?>
            <div class="uk-width-expand">
    <?php endif;?>

            <?php if ($this->params->get('list_show_top_filter', 1)) :?>
                <?php echo $this->loadTemplate('sortfilter');?>
            <?php endif; ?>

            <?php if (isset($this->products) && $this->products) :?>
                <?php
                    $col = $this->params->get('list_no_of_columns', 3);

                $total = count($this->products);
                $counter = 0;?>

                    <?php foreach ($this->products as $product) :?>
                        <?php $product->params = $platform->getRegistry($product->params); ?>
                        <!-- Make sure product is enabled and visible @front end -->
                        <?php //  if($product->enabled && $product->visibility):?>
                            <?php $rowcount = ((int) $counter % (int) $col) + 1; ?>
                                <?php if ($rowcount == 1) : ?>
                                    <?php $row = $counter / $col; ?>
                                        <div class="j2store-products-row uk-child-width-expand@s uk-child-width-1-3@m <?php echo 'row-'.$row; ?> row" uk-grid>
                                <?php endif;?>
                                            <div class="col-sm-<?php echo round((12 / $col));?>">
                                                <div class="j2store-single-product multiple j2store-single-product-<?php echo $product->j2store_product_id; ?> product-<?php echo $product->j2store_product_id; ?> pcolumn-<?php echo $rowcount;?> <?php echo $product->params->get('product_css_class', '');?> uk-transition-toggle">
                                                    <?php $this->product = $product;
                                                    $this->product_link = $this->product->product_link = $platform->getProductUrl(array('task' => 'view', 'id' => $this->product->j2store_product_id,'Itemid' => $item_id), true);
                                                    ?>
                                                    <?php
                                                    try {
                                                        $type = $product->product_type;
                                                        if (isset($type) && !empty($type)) {
                                                            echo $this->loadTemplate(strtolower($type));

                                                        }
                                                    } catch (Exception $e) {
                                                        echo $e->getMessage();
                                                    }

                                                    ?>
                                                    <!-- QUICK VIEW OPTION -->
                                                    <?php if ($this->params->get('list_enable_quickview', 0)) :?>
                                                        <div uk-lightbox>
                                                            <a class="uk-button uk-button-default" href="<?php echo $platform->getProductUrl(array('task' => 'view', 'id' => $this->product->j2store_product_id,'tmpl' => 'component'), true); ?>" data-type="iframe" data-caption="<?php echo Text::_('J2STORE_PRODUCT_QUICKVIEW');?>"><?php echo Text::_('J2STORE_PRODUCT_QUICKVIEW');?></a>
                                                        </div>

                                                        <a data-fancybox data-type="iframe" class="btn btn-default" data-src="<?php echo $platform->getProductUrl(array('task' => 'view', 'id' => $this->product->j2store_product_id,'tmpl' => 'component'), true); ?>" href="javascript:;">
                                                            <i class="fa fa-eye"></i> <?php echo Text::_('J2STORE_PRODUCT_QUICKVIEW');?>
                                                        </a>
                                                    <?php endif;?>
                                                </div>
                                            </div>
                                    <?php $counter++; ?>
                                <?php if (($rowcount == $col) or ($counter == $total)) : ?>
                                    </div>
                                <?php endif; ?>
                            <?php // endif;?>
                    <?php endforeach;?>

                    <form id="j2store-pagination" name="j2storepagination" action="<?php echo  $platform->getProductUrl(array('filter_catid' => $this->filter_catid,'Itemid' => $item_id), true); ?>" method="post">
                        <?php echo J2Html::hidden('option', 'com_j2store');?>
                        <?php echo J2Html::hidden('view', 'producttags');?>
                        <?php echo J2Html::hidden('task', 'browse', array('id' => 'task'));?>
                        <?php echo J2Html::hidden('boxchecked', '0');?>
                        <?php echo J2Html::hidden('filter_order', '');?>
                        <?php echo J2Html::hidden('filter_order_Dir', '');?>
                        <?php echo J2Html::hidden('filter_tag', $this->filter_tag);?>

                        <?php echo JHTML::_('form.token'); ?>
                        <div class="pagination">
                            <?php  echo $this->pagination->getPagesLinks(); ?>
                        </div>
                    </form>

            <?php else :?>
                <div class="row">
                        <div class="col-sm-12">
                            <p> <?php echo Text::_('J2STORE_NO_RESULTS_FOUND');?></p>
                            </div>
                        </div>
            <?php endif;?>
        </div>
    <?php
        //make sure filter is enable
    if ($this->params->get('list_show_filter')) :?>
        <?php if ($filter_position == 'right') : ?>
            <div class="j2store-sidebar-filters-container uk-width-1-3">
                <?php echo J2Store::modules()->loadposition('j2store-filter-right-top'); ?>
                <?php echo $this->loadTemplate('filters');?>
                <?php echo J2Store::modules()->loadposition('j2store-filter-right-bottom'); ?>
            </div>
        <?php endif; ?>
    <?php endif; ?>

    </div> <!-- end of row-fluid -->
    <?php echo J2Store::modules()->loadposition('j2store-product-list-bottom'); ?>
</div> <!-- end of product list -->