<?php

/**
 * @author    Stephan W.
 * @author    url   https://www.ui-themebuilder.com/
 * @copyright Copyright (C) 2024 ui-themebuilder.com, All rights reserved.
 *
 * @developer Stephan Wittling - https://www.ui-themebuilder.com/
 *               J2Store APP Plugin "UIKit 3" is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 *
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

use Joomla\CMS\Language\Text;

// No direct access
defined('_JEXEC') or die;

$product = $this->singleton_product;
$params = $this->singleton_params;
$action = 'index.php?option=com_j2store&view=carts&task=addItem&product_id='.$product->j2store_product_id;
?>
<?php echo J2Store::plugin()->eventWithHtml('BeforeAddToCartButton', array($product, J2Store::utilities()->getContext('cart'))); ?>
<div class="cart-action-complete" style="display:none;">
		<p class="uk-text-success">
			<?php echo Text::_('J2STORE_ITEM_ADDED_TO_CART');?>
			<a href="<?php echo $product->checkout_link; ?>" class="j2store-checkout-link">
				<?php echo Text::_('J2STORE_CHECKOUT'); ?>
			</a>
		</p>
</div>
<a class="<?php echo $params->get('addtocart_button_class', 'uk-button uk-button-primary');?> j2store_add_to_cart_button"
href="<?php echo JRoute::_($action); ?>" data-quantity="1" data-product_id="<?php echo $product->j2store_product_id;?>"
rel="nofollow">
<?php echo $this->singleton_cartext; ?>
</a>
<?php echo J2Store::plugin()->eventWithHtml('AfterAddToCartButton', array($product, J2Store::utilities()->getContext('cart'))); ?>

