<?php

/**
 * @author    Stephan W.
 * @author    url   https://www.ui-themebuilder.com/
 * @copyright Copyright (C) 2024 ui-themebuilder.com, All rights reserved.
 *
 * @developer Stephan Wittling - https://www.ui-themebuilder.com/
 *               J2Store APP Plugin "UIKit 3" is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 *
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

/** ensure this file is being included by a parent file */

use Joomla\CMS\Language\Text;

defined('_JEXEC') or die('Restricted access');
require_once(JPATH_ADMINISTRATOR.'/components/com_j2store/library/plugins/app.php');
class plgJ2StoreApp_uikit3 extends J2StoreAppPlugin
{
    /**
     * @var $_element  string  Should always correspond with the plugin's filename,
     *                         forcing it to be unique
     * @since v1.0.0
     */
    public $_element   = 'app_uikit3';

    /**
     * Overriding
     *
     * @param $row
     * @return string
     *
     * @since v1.0.0
     */
    public function onJ2StoreGetAppView($row): ?string
    {
        if (!$this->_isMe($row)) {
            return null;
        }
        return $this->viewList();
    }

    /**
     * @param $element
     *
     * @return true|null
     *
     * @since @since v1.0.0
     */
    public function onJ2StoreIsJ2Store4($element)
    {
        if (!$this->_isMe($element)) {
            return null;
        }
        return true;
    }
    /**
     * Validates the data submitted based on the suffix provided
     * A controller for this plugin, you could say
     * @return string
     *
     * @since v1.0.0
     */
    public function viewList(): string
    {
        $app = J2Store::platform()->application();
        JToolBarHelper::title(Text::_('J2STORE_APP').'-'.Text::_('PLG_J2STORE_'.strtoupper($this->_element)), 'j2store-logo');
        JToolBarHelper::back('J2STORE_BACK_TO_DASHBOARD', 'index.php?option=com_j2store');
        $vars = new \stdClass();
        $id = $app->input->getInt('id', '0');
        $vars->id = $id;
        return $this->_getLayout('backend', $vars);
    }

    /**
     * @param $var
     *
     * @return string
     *
     * @since v1.0.0
     */
    public function escape($var): string
    {
        return htmlspecialchars_decode($var, ENT_COMPAT);
    }

    /**
     * @param $folder
     *
     *
     * @since v1.0.0
     */
    public function onJ2StoreTemplateFolderList(&$folder): void
    {
        if (!in_array('uikit3', $folder)) {
            $folder[] = 'uikit3';
        }
        if (!in_array('tag_uikit3', $folder)) {
            $folder[] = 'tag_uikit3';
        }
    }

    /**
     * @param $view_html
     * @param $view
     * @param $model
     *
     * @return Exception|void
     *
     * @since v1.0.0
     */
    public function onJ2StoreViewProductListHtml(&$view_html, &$view, $model)
    {
        F0FPlatform::getInstance()->setErrorHandling(E_ALL, 'ignore');
        $view = $this->setTemplatePath($view);
        $result = $view->loadTemplate();

        if ($result instanceof Exception) {
            F0FPlatform::getInstance()->raiseError($result->getCode(), $result->getMessage());

            return $result;
        }
        $view_html = $result;
    }

    /**
     * @param $view
     * @param string $default
     *
     * @return mixed
     *
     * @since v1.0.0
     */
    public function setTemplatePath($view, string $default = 'uikit3'): mixed
    {
        $app = J2Store::platform()->application();
        if (!defined('DS')) {
            define('DS', DIRECTORY_SEPARATOR);
        }

        // Look for template files in component folders
        $view->addTemplatePath(JPATH_SITE.DS.'plugins'.DS.'j2store'.DS.$this->_element.DS.$this->_element.DS.'tmpl'.DS.$default);

        // Look for overrides in template folder (J2 template structure)
        $view->addTemplatePath(JPATH_SITE.DS.'templates'.DS.$app->getTemplate().DS.'html'.DS.'com_j2store'.DS.'templates');
        $view->addTemplatePath(JPATH_SITE.DS.'templates'.DS.$app->getTemplate().DS.'html'.DS.'com_j2store'.DS.'templates'.DS.$default);

        // Look for overrides in template folder (Joomla! template structure)
        $view->addTemplatePath(JPATH_SITE.DS.'templates'.DS.$app->getTemplate().DS.'html'.DS.'com_j2store'.DS.$default);
        $view->addTemplatePath(JPATH_SITE.DS.'templates'.DS.$app->getTemplate().DS.'html'.DS.'com_j2store');

        // Look for specific J2 theme files
        if ($view->params->get('subtemplate')) {
            $view->addTemplatePath(JPATH_SITE.DS.'templates'.DS.$app->getTemplate().DS.'html'.DS.'com_j2store'.DS.'templates'.DS.$view->params->get('subtemplate'));
            $view->addTemplatePath(JPATH_SITE.DS.'templates'.DS.$app->getTemplate().DS.'html'.DS.'com_j2store'.DS.$view->params->get('subtemplate'));
        }
        return $view;
    }

    /**
     * @param $view_html
     * @param $view
     * @param $model
     *
     * @return Exception|void
     *
     * @since v1.0.0
     */
    public function onJ2StoreViewProductListTagHtml(&$view_html, &$view, $model)
    {
        F0FPlatform::getInstance()->setErrorHandling(E_ALL, 'ignore');
        $view = $this->setTemplatePath($view, 'tag_uikit3');
        $result = $view->loadTemplate();

        if ($result instanceof Exception) {
            F0FPlatform::getInstance()->raiseError($result->getCode(), $result->getMessage());

            return $result;
        }
        $view_html = $result;
    }

    /**
     * @param $view_html
     * @param $view
     * @param $model
     *
     * @return Exception|void
     *
     * @since v1.0.0
     */
    public function onJ2StoreViewProductHtml(&$view_html, &$view, $model)
    {
        $view->setLayout('view');
        F0FPlatform::getInstance()->setErrorHandling(E_ALL, 'ignore');
        $view = $this->setTemplatePath($view);
        $result = $view->loadTemplate();

        if ($result instanceof Exception) {
            F0FPlatform::getInstance()->raiseError($result->getCode(), $result->getMessage());

            return $result;
        }
        $view_html = $result;
    }

    /**
     * @param $view_html
     * @param $view
     * @param $model
     *
     * @return Exception|void
     *
     * @since v1.0.0
     */
    public function onJ2StoreViewProductTagHtml(&$view_html, &$view, $model)
    {
        $view->setLayout('view');
        F0FPlatform::getInstance()->setErrorHandling(E_ALL, 'ignore');
        $view = $this->setTemplatePath($view, 'tag_uikit3');
        $result = $view->loadTemplate();

        if ($result instanceof Exception) {
            F0FPlatform::getInstance()->raiseError($result->getCode(), $result->getMessage());

            return $result;
        }
        $view_html = $result;
    }
}
