<?php
/**
* @package      mod ui/Theme-Builder Lite
* @author       Stephan W.
* @author url   https://www.ui-themebuilder.com/
* @copyright Copyright (C) 2021 - 2023 ui-themebuilder.com, All rights reserved.
* @developer Stephan Wittling - https://www.ui-themebuilder.com/

*               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
*               but WITHOUT ANY WARRANTY; without even the implied warranty of
*               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*               See the GNU General Public License for more details.

* @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die('Restricted access');


use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Editor\Editor;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\HTML\HTMLHelper;
use SW\Component\uiThemeBuilderLite\Administrator\Helper\PageHelper;

HTMLHelper::_('jquery.framework');

class JFormFieldUiComponents extends FormField
{

    /**
     * The form field type.
     *
     * @var     string
     *
     * @since   v1.0.0
     */
    protected $type = 'uicomponents';

    /**
     * Method to get the field label markup.
     *
     * @return  false  The field label markup.
     *
     * @since   v1.0.0
     */
    public function getLabel()
    {
        return false;
    }

    /**
     * Method to get the field input markup.
     *
     * @return  string  The field input markup.
     *
     * @throws \JsonException
     * @throws \Exception
     *
     * @since   v1.0.0
     */
    protected function getInput(): string
    {

        $html = '';

        if (!empty($this->value)) {
            $components = json_decode($this->value, false, 512, JSON_THROW_ON_ERROR);
        } else {
            $components             = [];
        }

        $default_components     = PageHelper::getComponents();
        $components_category    = [];
        $components_category[]  = Text::_('MOD_UITHEMEBUILDERLITE_ALL_COMPONENTS');

        // Load editor
        $editorType     = Factory::getApplication()->get('editor');
        $editor         = Editor::getInstance($editorType);

        switch ($editorType) {
            case 'codemirror':
                // Initialize CodeMirror
                $editor->display('codemirror', '', 0, 250, 0, 0, false);
                break;

            case 'none':
                $editor->display('none', '', 0, 250, 0, 0, false);
                break;

            case 'tinymce':
                $editor->display('tinymce', '', 0, 250, 0, 0, false);
                break;

            default:
                // Initialize Editor
                $editor->display('none', '', 0, 250, 0, 0, false);
        }

        // Get components categories
        foreach ($default_components as $i => $component) {
            $component_categories = explode(',', $component['category']);
            foreach ($component_categories as $component_category) {
                $components_category[] = strtolower(trim(str_replace(',', ' ', $component_category)));
//              var_dump($component_category);
            }
        }

        $components_category = array_map('trim', $components_category);
        $components_category = array_unique($components_category);
        ksort($components_category);

        // Messages translations
        Text::script('MOD_UITHEMEBUILDERLITE_ERROR');
        Text::script('MOD_UITHEMEBUILDERLITE_INVALID_FIELD');
        Text::script('MOD_UITHEMEBUILDERLITE_SURE_REMOVE_ELEMENT');
        Text::script('MOD_UITHEMEBUILDERLITE_CANCEL');
        Text::script('MOD_UITHEMEBUILDERLITE_OK');
        Text::script('MOD_UITHEMEBUILDERLITE_RESET');
        Text::script('MOD_UITHEMEBUILDERLITE_SURE_REMOVE_ITEM');
        Text::script('MOD_UITHEMEBUILDERLITE_REMOVE_LAST_ITEM');

        Text::script('WARNING');

        // Actions translations
        Text::script('MOD_UITHEMEBUILDERLITE_BUTTON');
        Text::script('MOD_UITHEMEBUILDERLITE_SURE_REMOVE_ELEMENT');
        Text::script('MOD_UITHEMEBUILDERLITE_SURE_REMOVE_ITEM');
        Text::script('MOD_UITHEMEBUILDERLITE_REMOVE_LAST_ITEM');
        Text::script('MOD_UITHEMEBUILDERLITE_ICON_SEARCH_ICON');
        Text::script('MOD_UITHEMEBUILDERLITE_ADD_COMPONENT');

        // Components
        Text::script('MOD_UITHEMEBUILDERLITE_ACCORDION');
        Text::script('MOD_UITHEMEBUILDERLITE_ALERTS');
        Text::script('MOD_UITHEMEBUILDERLITE_ARTICLES');
        Text::script('MOD_UITHEMEBUILDERLITE_ARTICLES_PRO');
        Text::script('MOD_UITHEMEBUILDERLITE_BUTTON');
        Text::script('MOD_UITHEMEBUILDERLITE_BUTTON_PRO');
        Text::script('MOD_UITHEMEBUILDERLITE_COUNTDOWN');
        Text::script('MOD_UITHEMEBUILDERLITE_DIVIDER');
        Text::script('MOD_UITHEMEBUILDERLITE_FILTERING');
        Text::script('MOD_UITHEMEBUILDERLITE_FLICKR');
        Text::script('MOD_UITHEMEBUILDERLITE_GALLERY_PRO');
        Text::script('MOD_UITHEMEBUILDERLITE_ICON_BOX_PRO');
        Text::script('MOD_UITHEMEBUILDERLITE_IMAGE');
        Text::script('MOD_UITHEMEBUILDERLITE_IMAGE_PRO');
        Text::script('MOD_UITHEMEBUILDERLITE_LIGHTBOX');
        Text::script('MOD_UITHEMEBUILDERLITE_LIGHTBOX_PRO');
        Text::script('MOD_UITHEMEBUILDERLITE_LIST');
        Text::script('MOD_UITHEMEBUILDERLITE_MEDIA_CARD');
        Text::script('MOD_UITHEMEBUILDERLITE_MEDIA_CARD_PRO');
        Text::script('MOD_UITHEMEBUILDERLITE_MODULE');
        Text::script('MOD_UITHEMEBUILDERLITE_MODULE_PRO');
        Text::script('MOD_UITHEMEBUILDERLITE_NAVBAR_PRO');
        Text::script('MOD_UITHEMEBUILDERLITE_NUM_SCROLLER_PRO');
        Text::script('MOD_UITHEMEBUILDERLITE_PERSONAL_CARD');
        Text::script('MOD_UITHEMEBUILDERLITE_PRICE_TABLE');
        Text::script('MOD_UITHEMEBUILDERLITE_PROGRESS_BARS');
        Text::script('MOD_UITHEMEBUILDERLITE_SLIDER');
        Text::script('MOD_UITHEMEBUILDERLITE_SLIDER_PRO');
        Text::script('MOD_UITHEMEBUILDERLITE_SPACER');
        Text::script('MOD_UITHEMEBUILDERLITE_TAB');
        Text::script('MOD_UITHEMEBUILDERLITE_TEXT_BLOCK');
        Text::script('MOD_UITHEMEBUILDERLITE_TEXT_BLOCK_PRO');
        Text::script('MOD_UITHEMEBUILDERLITE_TIMELINE_PRO');
        Text::script('MOD_UITHEMEBUILDERLITE_VIDEO');

        // Infield class
        !empty($this->class) ? $this->class = ' '.$this->class : $this->class = '';
        $column_title = Text::_('MOD_UITHEMEBUILDERLITE_COLUMN');

        // Build field HTML
        $html .= '<div class="mod-uithemebuilderlite">';
        $html .= '	<div class="ui-themebuilder-wrapper uk-container uk-container-small">';
        $html .=        '<div class="column uk-background-secondary">';

        $html .=            '<div class="uk-padding-small uk-flex uk-flex-middle">
								<h5 class="uk-h5 uk-drag uk-text-bold uk-light uk-text-uppercase uk-margin-remove">
									<i class="uk-drag uk-icon" data-uk-icon="move"></i>
									<span class="uk-margin-small-left uk-text-bold ui-column-title">' . $column_title . '</span>
								</h5>
								<div class="uk-margin-auto-left">
									<ul class="uk-iconnav">
										<li uk-tooltip="' . Text::_('MOD_UITHEMEBUILDERLITE_CONFIGURE_COLUMN') . '">
											<a class="btn-column-config uk-disabled" href="javascript:void(0)"><i uk-icon="cog"></i></a>
										</li>
										<li uk-tooltip="' . Text::_('MOD_UITHEMEBUILDERLITE_ADD_COMPONENT') . '">
											<a class="btn-add-component" href="javascript:void(0)"><i uk-icon="ui-component"></i></a>
										</li>
									</ul>
								</div>
							</div>';

        $html .=            '<div class="uk-panel uk-padding-small" uk-sortable="handle: .uk-drag.uk-grid; group: sortable-component-group">';
        if ($components && count($components)) {
            foreach ($components as $component) {
                $srcsets    = array();
                $icons      = $component->type;

                $component_background_image_srcset = (!isset($component->options->background_image_srcset) || (isset($component->options->background_image_srcset) && ($component->options->background_image_srcset == '1'))) ? '1' : '0';

                if (isset($component->options->background_image) && ($component_background_image_srcset == 1) && isset($component->options->image_width_srcset)) {
                    $ex                     = '.' . pathinfo($component->options->background_image, PATHINFO_EXTENSION);
                    $file_name              = 'th_'.pathinfo($component->options->background_image, PATHINFO_FILENAME);

                    // great thumbnails only on admin view
                    $type               = PageHelper::toArray($component);
                    $typeitem           = str_replace('_', '-', $type['type']);
                    $thumbnail_folder   = 'media/com_uithemebuilderlite/ui-themebuilder-thumb/'.$typeitem;

                    $tmp_srcset     = explode(',', $component->options->image_width_srcset);
                    $merge_srcsets  = array_merge($srcsets, $tmp_srcset);
                    $srcsets        = array_map('trim', $merge_srcsets);
                    $srcsets        = array_unique($srcsets);

                    $filter     = range(1, 4000);
                    $result     = array_diff($filter, $srcsets);
                    $results    = array_unique($result);
                    $file       = '';

                    foreach ($srcsets as $i => $val) {
                        if (is_numeric($val) && $val < 4000) {
                            unset($srcsets[$i]);
                            if ($val < 500) {
                                PageHelper::image_resize('../' . $component->options->background_image, $val, 0, 60, 0, '../'.$thumbnail_folder, false);
                            } else {
                                PageHelper::image_resize('../' . $component->options->background_image, $val, 0, 90, 0, '../'.$thumbnail_folder, false);
                            }

                            // delete files if srcset value not exists
                            foreach ($results as $v => $value) {
                                unset($results[$v]);
                                $file = '../' . $thumbnail_folder.'/'.$file_name.'_'.$value.$ex;

                                if (file_exists($file)) {
                                    chmod($file, 0777);
                                    unlink($file);
                                    break;
                                }
                            }
                        }
                    }
                }

                if (isset($component->options->title) && $component->options->title) {
                    $title = PageHelper::escapeHtml($component->options->title);
                } elseif (isset($component->options->admin_label) && $component->options->admin_label) {
                    $title = PageHelper::escapeHtml($component->options->admin_label);
                } else {
                    $title = PageHelper::componentModTypeToTitle($component->type);
                }

                $subtitle = PageHelper::componentModTypeToTitle($component->type);

                $html .=    '<div id="ui-component-container" class="ui-component-container uk-margin-small" >';
                    $html .=    '<div class="uk-flex uk-flex-middle uk-card uk-card-small uk-card-secondary">';
                        $html .=    '<div class="uk-flex-middle uk-grid-small uk-drag uk-grid edit-drag">';
                            $html .=    '<div class="uk-width-auto@m">';
                                $html .=    '<div class="uk-padding-small">';
                                    $html .=    '<span class="uk-text-muted component-title">' . $title . '</span>';
                                    $html .=    '<p class="uk-text-small uk-text-muted uk-margin-remove component-type' .(($title === $subtitle) ? ' hidden' : '') . '" data-type="' . $component->type . '">';
                                        $html .=    $subtitle;
                                    $html .=    '</p>';
                                $html .=    '</div>';
                            $html .=    '</div>';
                            $html .=    '<div class="uk-width-auto@m uk-flex-first">';
                                $html .=    '<img class="uk-margin-small-left uk-preserve ' . $component->type . '" src="' . Uri::root(true) . '/media/com_uithemebuilderlite/images/icons/icons.min.svg#' . $icons . '" width="70" height="70" uk-svg>';
                            $html .=    '</div>';
                        $html .=    '</div>';
                        $html .=    '<div class="uk-margin-auto-left edit-left-actions">';
                            $html .=    '<div class="uk-margin-small-right">';
                                $html .=    '<ul class="uk-iconnav uk-text-small">';
                                    $html .=    '<li><a class="btn-edit-component" href="javascript:void(0)" uk-tooltip="' . Text::_('MOD_UITHEMEBUILDERLITE_EDIT_ELEMENT') . '"><i uk-icon="pencil"></i></a></li>';
                                    $html .=    '<li><a class="btn-duplicate-component" href="javascript:void(0)" uk-tooltip="' . Text::_('MOD_UITHEMEBUILDERLITE_DUPLICATE_ELEMENT') . '"><i uk-icon="copy"></i></a></li>';
                                    $html .=    '<li><a class="btn-delete-component" href="javascript:void(0)" uk-tooltip="' . Text::_('MOD_UITHEMEBUILDERLITE_REMOVE_ELEMENT') . '"><i uk-icon="trash"></i></a></li>';
                                $html .=    '</ul>';
                            $html .=    '</div>';
                        $html .=    '</div>';

                        $html .=    '<div class="component-options uk-hidden"></div>';
                        $html .=    '<input class="json-component" type="hidden" value="'.self::escape(json_encode(PageHelper::toArray($component), JSON_THROW_ON_ERROR)).'">';
                    $html .=    '</div>';
                $html .=    '</div>';
            }
        }
        $html .=            '</div>';
        $html .=        '</div>';
        $html .=    '</div>';

        $html .=    '<input id="'.$this->id.'" type="hidden" name="'.$this->name.'" class="'.$this->class.'" value="' . str_replace('"', '\'', $this->value) . '">';

        // Components modal
        $dir = JPATH_ADMINISTRATOR . '/components/com_uithemebuilderlite/forms/components/';
        $files = glob("$dir*.xml");
        $componentsFilesCount = $files !== false ? count($files) : 0;

        $html .=    '<div id="ui-modal-components-list" class="uk-modal-container uk-flex-top" uk-modal="container: false; escClose: false; bgClose: false;">';
                $html .= '<div class="uk-modal-dialog uk-width-auto uk-margin-auto-vertical">';
                    $html .= '<button class="uk-modal-close-default" type="button" uk-close></button>';
                    $html .= '<div class="uk-modal-header">';
                        $html .= '<h2 class="uk-modal-title modal-title">' . Text::_('MOD_UITHEMEBUILDERLITE_COMPONENTS_LIST') . ' <sup>(' . $componentsFilesCount . ')</sup></h2>';
                    $html .= '</div>';

                    $html .= '<div class="uk-modal-body" uk-overflow-auto>';
                        $html .= '<div uk-filter="target: .components">';
                            $html .= '<div class="uk-grid-small uk-grid-divider" uk-grid uk-height-match=".components-wrapper">';
                                $html .= '<div class="uk-width-1-4@l">';
                                    $html .= '<div class="uk-height-medium">';
                                        $html .= '<ul class="uk-nav uk-nav-default">';
        foreach ($components_category as $key => $component_category) {
            $category_title_replace = PageHelper::componentModCategoryToTitle($component_category);
            $category_title = ucwords(str_replace('_', ' ', $category_title_replace));

            $html .= '<li ';
            if ($key == 0) {
                                                $html .='class="uk-active" uk-filter-control';
            } else {
                                                    $html .= 'class="" uk-filter-control="filter: .' . $component_category . '"';
            }
                                                                                    $html .= '><a href="javascript:void(0)">' . $category_title . '</a></li>';
        }
                                        $html .= '</ul>';
                                    $html .= '</div>';
                                $html .= '</div>';
                                $html .= '<div class="uk-width-expand@l">';
                                    $html .= '<div class="components-wrapper"></div>';
                                $html .= '</div>';
                            $html .= '</div>';
                        $html .= '</div>';
                        $html .= '<div class="loader"><span class="uk-position-center" uk-spinner="ratio: 4.5"></span></div>';
                    $html .= '</div>';
                    $html .= '<div class="uk-modal-footer">';
                        $html .= '<div class="uk-inline">';
                            $html .= '<span class="uk-form-icon" uk-icon="icon: search"></span>';
                            $html .= '<a id="btn-component-filter-clear" class="uk-form-icon uk-form-icon-flip uk-hidden" href="javascript:void(0)" uk-icon="icon: close; ratio: 0.8"></a>';
                            $html .= '<input id="ui-component-filter" class="uk-input uk-form-width-large list-filter" type="text" placeholder="' . Text::_('MOD_UITHEMEBUILDERLITE_SEARCH_COMPONENT') . '">';
                        $html .= '</div>';
                    $html .= '</div>';
                $html .= '</div>';
            $html .= '</div>';

            // Components modal edit
            $html .=    '<div id="ui-modal-component" class="uk-modal-container uk-flex-top" uk-modal="container: false; escClose: false; bgClose: false;">';
                $html .=    '<div class="uk-modal-dialog uk-width-auto uk-margin-auto-vertical">';
                    $html .=    '<div class="uk-modal-header">';
                        $html .=    '<h2 class="uk-modal-title modal-title"></h2>';
                    $html .=    '</div>';

                    $html .=    '<div class="component-preview"></div>';
                    $html .=    '<div class="loader uk-height-large"><span class="uk-position-center" uk-spinner="ratio: 4.5"></span></div>';

                    $html .=    '<div class="uk-modal-footer">';
                        $html .=    '<div class="uk-button-group">';
                            // $html .= '<button href="#options" id="options-toggle" class="uk-button uk-button-secondary" uk-toggle="target: #ui-modal-component #options; animation: uk-animation-fade"><span uk-icon="icon: menu" uk-tooltip="title: ' . Text::_('MOD_UITHEMEBUILDERLITE_HIDE_OPTIONS_TABS') . '; pos: right"></span></button>';
                            $html .=    '<a href="javascript:void(0)" class="uk-button uk-button-primary" id="btn-save-component">' . Text::_('MOD_UITHEMEBUILDERLITE_APPLY') . '</a>';
                            $html .=    '<a class="uk-button uk-button-danger" id="btn-cancel-component-settings">' . Text::_('JCANCEL') . '</a>';
                        $html .=    '</div>';
                    $html .=    '</div>';
                $html .=    '</div>';
            $html .=    '</div>';

            // Image upload modal
            $html .=    '<div id="ui-modal-upload-image" class="uk-modal-full" uk-modal="container: false; escClose: false; bgClose: false; stack: true">';
                $html .=    '<div class="uk-modal-dialog">';
                    $html .=    '<div class="uk-modal-header">';
                        $html .=    '<h2 class="uk-modal-title">'.Text::_('JLIB_FORM_CHANGE_IMAGE').'</h2>';
                    $html .=    '</div>';
                    $html .=    '<div class="uk-modal-body uk-padding-remove" uk-height-viewport="offset-top: true;"></div>';
                    $html .=    '<div class="uk-modal-footer">';
                        $html .=    '<div class="uk-button-group">';
                            $html .=    '<a class="uk-button uk-button-primary button-select" id="btn-add-image">' . Text::_('JSELECT') . '</a>';
                            $html .=    '<a class="uk-button uk-button-danger" id="btn-cancel-image">' . Text::_('JCANCEL') . '</a>';
                        $html .=    '</div>';
                    $html .=    '</div>';
                    $html .=    '<div class="loader"><span class="uk-position-center" uk-spinner="ratio: 4.5"></span></div>';
                $html .=    '</div>';
            $html .=    '</div>';

            $html .=    '<div id="ui-components" class="uk-hidden" hidden>';
                $html .=    '<ul class="components uk-child-width-1-1@s uk-child-width-1-3@m uk-child-width-1-4@l uk-grid-collapse uk-grid-match" uk-grid>';
        foreach ($default_components as $component) {
            $icons  = $component['type'];
            $desc   = PageHelper::componentModDesc($component['type']);

            if (isset($component['options']['title']) && $component['options']['title']) {
                $title = PageHelper::escapeHtml($component['options']['title']);
            } elseif (isset($component['options']['text']) && $component['options']['text']) {
                $title = PageHelper::escapeHtml($component['options']['text']);
            } elseif (isset($component['options']['admin_label']) && $component['options']['admin_label']) {
                $title = PageHelper::escapeHtml($component['options']['admin_label']);
            } else {
                $title = PageHelper::componentModTypeToTitle($component['type']);
            }

            $subtitle = PageHelper::componentModTypeToTitle($component['type']);

            $html .=    '<li class="' . trim(str_replace(',', ' ', $component['category'])) . ' uk-padding-small uk-text-center">';

                $html .=    '<div class="uk-card uk-card-small uk-card-hover" hidden uk-tooltip="title:' . $desc . '">';
                    $html .=    '<div class="uk-card-media-top">';
                        $html .=    '<img class="' . $component['type'] . ' uk-preserve" src="' . Uri::root(true) . '/media/com_uithemebuilderlite/images/icons/icons.min.svg#' . $icons . '" width="70" height="70" uk-svg>';
                    $html .=    '</div>';
                    $html .=    '<div class="uk-card-footer">';
                        $html .=    '<a id="' . $component['type'] . '" class="uk-link-reset uk-link-muted uk-text-small component-title" href="javascript:void(0)">' . $title . '</a>';
                    $html .=    '</div>';
                $html .=    '</div>';

                $html .=    '<div id="ui-component-container" class="ui-component-container uk-margin-small" hidden>';
                    $html .=    '<div class="uk-flex uk-flex-middle uk-card uk-card-small uk-card-secondary">';
                        $html .=    '<div class="uk-flex-middle uk-grid-small uk-drag uk-grid edit-drag" hidden>';
                            $html .=    '<div class="uk-width-auto@m">';
                                $html .=    '<div class="uk-padding-small">';
                                    $html .=    '<span class="uk-text-muted component-title">' . $title . '</span>';
                                    $html .=    '<p class="uk-text-small uk-text-muted uk-margin-remove component-type' .(($title === $subtitle) ? ' hidden' : '') . '" data-type="' . $component['type'] . '">';
                                        $html .=    $subtitle;
                                    $html .=    '</p>';
                                $html .=    '</div>';
                            $html .=    '</div>';
                            $html .=    '<div class="uk-width-auto@m uk-flex-first">';
                                $html .=    '<img class="uk-margin-small-left uk-preserve ' . $component['type'] . '" src="' . Uri::root(true) . '/media/com_uithemebuilderlite/images/icons/icons.min.svg#' . $icons . '" width="70" height="70" uk-svg>';
                            $html .=    '</div>';
                        $html .=    '</div>';
                        $html .=    '<div class="uk-margin-auto-left edit-left-actions" hidden>';
                            $html .=    '<div class="uk-margin-small-right">';
                                $html .=    '<ul class="uk-iconnav uk-text-small">';
                                    $html .=    '<li><a class="btn-edit-component" href="javascript:void(0)" uk-tooltip="' . Text::_('MOD_UITHEMEBUILDERLITE_EDIT_ELEMENT') . '"><i uk-icon="pencil"></i></a></li>';
                                    $html .=    '<li><a class="btn-duplicate-component" href="javascript:void(0)" uk-tooltip="' . Text::_('MOD_UITHEMEBUILDERLITE_DUPLICATE_ELEMENT') . '"><i uk-icon="copy"></i></a></li>';
                                    $html .=    '<li><a class="btn-delete-component" href="javascript:void(0)" uk-tooltip="' . Text::_('MOD_UITHEMEBUILDERLITE_REMOVE_ELEMENT') . '"><i uk-icon="trash"></i></a></li>';
                                $html .=    '</ul>';
                            $html .=    '</div>';
                        $html .=    '</div>';

                        $html .=    '<div class="component-options uk-hidden"></div>';
                        $html .=    '<input class="json-component" type="hidden" value="' . self::escape(json_encode(PageHelper::toArray($component), JSON_THROW_ON_ERROR)) . '">';
                    $html .=    '</div>';
                $html .=    '</div>';

            $html .=    '</li>';
        }
                $html .=    '</ul>';
            $html .=    '</div>';

        $html .= '</div>';

        return $html;
    }

    /**
     *
     *
     * @return  string
     *
     * @since   v1.0.0
     */
    public static function escape($content)
    {
        return htmlspecialchars($content, ENT_COMPAT, 'UTF-8');
    }
}
