<?php
/**
* @package      mod ui/Theme-Builder Lite
* @author       Stephan W.
* @author url   https://www.ui-themebuilder.com/
* @copyright Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
* @developer Stephan Wittling - https://www.ui-themebuilder.com/

*               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
*               but WITHOUT ANY WARRANTY; without even the implied warranty of
*               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*               See the GNU General Public License for more details.

* @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die('Restricted access');

extract($displayData);

$classes = array_filter((array) $classes);

$id = $for . '-lbl';
$title = '';

if (!empty($description)) {
    if ($text && $text !== $description) {
        $classes[] = 'uk-form-label';
        $title     = ' title="' . htmlspecialchars(trim($text, ':')) . '"' . ' uk-tooltip="title:'. htmlspecialchars($description) . '; pos: top-left"';

        if (!$position && JFactory::getLanguage()->isRtl()) {
            $position = ' data-placement="left" ';
        }
    } else {
        $classes[] = 'uk-form-label';
        $title     = ' uk-tooltip="title:' . JHtml::_('tooltipText', trim($text, ':'), $description, 0) . '; pos: top-left"';
    }
}

if ($required) {
    $classes[] = 'required';
} ?>
<label id="<?php echo $id; ?>" for="<?php echo $for; ?>"<?php if (!empty($classes)) {
    echo ' class="' . implode(' ', $classes) . '"';
           } ?><?php echo $title; ?><?php echo $position; ?>>
    <?php echo $text; ?><?php if ($required) :
        ?><span class="uk-text-danger">&#160;*</span><?php
    endif; ?>
</label>
