<?php
/**
* @package		Warp Theme Framework* +, UIKit* v3, default_links.php**
* *@copyright	Copyright (C) YOOtheme GmbH
*
* @modified**	Stephan W. http://www.3d-hobby-art.de
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*/
// no direct access
defined('_JEXEC') or die;


// Create shortcut
$urls = json_decode($this->item->urls, false, 512, JSON_THROW_ON_ERROR);

// Create shortcuts to some parameters.
$params = $this->item->params;
if ($urls && (!empty($urls->urla) || !empty($urls->urlb) || !empty($urls->urlc))) :
	?>
	<div class="com-content-article__links content-links">
		<ul class="com-content-article__links content-list uk-list uk-list-circle">
			<?php
			$urlarray = [
				[$urls->urla, $urls->urlatext, $urls->targeta, 'a'],
				[$urls->urlb, $urls->urlbtext, $urls->targetb, 'b'],
				[$urls->urlc, $urls->urlctext, $urls->targetc, 'c']
			];
			foreach ($urlarray as $url) :
				$link = $url[0];
				$label = $url[1];
				$target = $url[2];
				$id = $url[3];

				if (! $link) :
					continue;
				endif;

				// If no label is present, take the link
				$label = $label ?: $link;

				// If no target is present, use the default
				$target = $target ?: $params->get('target' . $id);
				?>
				<li class="com-content-article__link content-links-<?php echo $id; ?>">
					<?php
					// Compute the correct link

					switch ($target) {
						case 1:
							// Open in a new window
							echo '<a class="uk-button uk-button-text" href="' . htmlspecialchars($link, ENT_COMPAT, 'UTF-8') . '" target="_blank" rel="nofollow noopener noreferrer">' .
								htmlspecialchars($label, ENT_COMPAT, 'UTF-8') . '</a>';
							break;

						case 2:
							// Open in a popup window
							$attribs = 'toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width=600,height=600';
							echo "<a class=\"uk-button uk-button-text\" href=\"" . htmlspecialchars($link, ENT_COMPAT, 'UTF-8') . "\" onclick=\"window.open(this.href, 'targetWindow', '" . $attribs . "'); return false;\" rel=\"noopener noreferrer\">" .
								htmlspecialchars($label, ENT_COMPAT, 'UTF-8') . '</a>';
							break;
						case 3:
							echo '<div uk-lightbox>
							    <a class="uk-button uk-button-text" href="' . htmlspecialchars($link, ENT_COMPAT, 'UTF-8') . '" data-caption="' . htmlspecialchars($label, ENT_COMPAT, 'UTF-8') . '" data-type="iframe" rel=\"noopener noreferrer\">' .
									htmlspecialchars($label, ENT_COMPAT, 'UTF-8') . '</a>
								</div>';
							break;

						default:
							// Open in parent window
							echo '<a class="uk-button uk-button-text" href="' . htmlspecialchars($link, ENT_COMPAT, 'UTF-8') . '" rel="nofollow">' .
								htmlspecialchars($label, ENT_COMPAT, 'UTF-8') . ' </a>';
							break;
					}
					?>
				</li>
			<?php endforeach; ?>
		</ul>
	</div>
<?php endif; ?>
