<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	Warp/Menu/Post.php
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
namespace Warp\Menu;

// No direct access
defined ('_JEXEC') or die ('Restricted access');


/**
 * Post menu renderer.
 */
class Post {

	protected $scrollspy = false;
	protected $scroll = false;
	protected $active_url = '';

	/**
	 * Process menu
	 *
	 * @param  object $module
	 * @param  object $element
	 * @return object
	 */
	public function process($module, $element) {

		$use_scrollspy  = true;
		$active_url     = true;

		//assuming the first active menu item is the current page
		if ($module->position == 'dotnav' && $module->nav_settings['scrollspy'] && $active = $element->first('li.uk-active')) {
			$active     = $active->first('a');
			$active_url = preg_replace('/#(.+)$/', '', $active->attr('href'));
		}

		foreach ($element->find('a') as $ele) {

			$ele->attr('itemprop', 'url');

			// is active ?
			$li = $ele->parent();
			if ($ele->hasAttribute('aria-current')) {
				$li->addClass("uk-active");
			}

			// add parent icon
			if ($li->hasClass('uk-parent') && $module->nav_settings['accordion']) {
				$ele->html($ele->text().' <span uk-nav-parent-icon=""></span>');
			}

			// check if Load Modules on Navbar Pro Component
			if (str_contains($ele->attr('href'), '[modid=')) {
				$li->removeChild($ele);
				$li->removeAttr('itemprop');
			}

			// check if custom columns on Navbar Pro Component
			if (str_contains($ele->attr('title'), '{col ')) {
				$col_regex = '/{col\s([1-5]*)}/i';
				$title = preg_replace($col_regex, '', $ele->attr('title'));
				$ele->attr('title', trim($title));
			}

			// check if scrollspy needs to be applied
			$url_fragment = parse_url($ele->attr('href'), PHP_URL_FRAGMENT);
			if ((isset($module->nav_settings["scroll"]) && $module->nav_settings["scroll"]) && !empty($url_fragment) && isset($module->nav_settings["scroll_offset"]) && $module->nav_settings["scroll_offset"])
			{
				$ele->attr('uk-scroll', 'offset: '.$module->nav_settings['scroll_offset'].';' );
			}

			if ($type = $ele->attr("data-type")) {

				if ($type === "separator-text") {
					$ele->removeAttr('data-type');
				} else if (!$ele->parent()->parent()->hasClass('uk-navbar-nav') && !($module->nav_settings["accordion"] && $ele->parent()->first("ul.level2"))) {

					$ele->parent()->addClass("uk-nav-header");

					foreach ($ele->children() as $child) {
						$ele->parent()->_prepend($child);
					}

					$ele->_replaceWith($ele->text());
				}
			}

		}

		foreach($element->first("ul:first")->addClass($module->nav_settings["modifier"])->find('ul.level2 ul') as $ul) {
			if (!$ul->hasClass('uk-nav-sub')) $ul->removeAttr("class");
		}

		foreach ($element->find('li') as $li) {

			if (!$li->hasClass('uk-parent'))
			{
				$li->attr('itemprop', 'name');
			}
			if ($li->hasClass('uk-nav-divider'))
			{
				$li->removeAttr('itemprop');
			}
			if ($li->hasClass('uk-nav-header'))
			{
				$li->removeAttr('itemprop');
			}

			$li->removeAttr('data-id')->removeAttr('data-menu-active')->removeAttr('data-menu-columns')->removeAttr('data-menu-columnwidth')->removeAttr('data-menu-icon')->removeAttr('data-menu-image')->removeAttr('data-menu-subtitle')->removeAttr('data-menu-separator')->removeAttr('data-menu-header')->removeAttr('data-menu-moduleid');
			$li->removeClass("level1")
				 ->removeClass("level2")
				 ->removeClass("level3")
				 ->removeClass("level4")
			->parent()
				 ->removeClass("level1")
				 ->removeClass("level2")
				 ->removeClass("level3")
				 ->removeClass("level4");
		}

		// apply scrollspy-nav with offset 80
		if ($use_scrollspy && $active_url && $module->nav_settings['scrollspy']) {
			$element->first('ul:first')->attr('uk-scrollspy-nav', 'closest: li; scroll: true; offset: 80;');
		}

		return $element;
	}
}
