<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	Warp/Menu/Nav.php
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
namespace Warp\Menu;

// No direct access
defined ('_JEXEC') or die ('Restricted access');


/**
 * Nav menu renderer.
 */
class Nav {

	/**
	 * Process menu
	 *
	 * @param   object  $module
	 * @param   object  $element
	 *
	 * @return object
	 */
	public function process(object $module, object $element): object
	{
		$ul = $element->first('ul:first')->attr('class', '');

		if ($module->nav_settings['accordion']) {

			$modifier = (isset($module->nav_settings["modifier"]) && $module->nav_settings["modifier"]) ? $module->nav_settings["modifier"] : 'uk-nav-side';

			$ul->addClass('uk-nav-default')->addClass($modifier)->attr('uk-nav', is_string($module->nav_settings['accordion']) ? $module->nav_settings['accordion'] : 'multiple: true');

			foreach($ul->find("ul.level2") as $list) {

				if ($list->prev()->tag() == 'a') {

					if (!$list->prev()->attr("href")) {
						$list->prev()->attr("href", "#");
					}

					if ($list->prev()->attr("href") !== "#" && $module->position === 'offcanvas') {
						$list->parent()->addClass("uk-open");
					}
				}

				$list->addClass("uk-nav-sub");
			}
		}
		 else
		{
			foreach($ul->find("ul.level2") as $list) {
				$list->addClass("uk-nav-sub");
			}
		}

		return $element;
	}
}
