<?php
/**
* @package		Warp Theme Framework* +, UIKit* v3, AbstractHelper.php**
* *@copyright	Copyright (C) YOOtheme GmbH
*
* @modified**	Stephan W. http://www.3d-hobby-art.de
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*/
namespace Warp\Helper;

// No direct access
defined ('_JEXEC') or die ('Restricted access');

use Warp\Warp;

/**
 * Helper base class.
 */
abstract class AbstractHelper implements \ArrayAccess {

    /**
     * @var Warp
     */
    protected $warp;

    /**
     * Constructor.
     *
     * @param Warp $warp
     */
    public function __construct(Warp $warp)
    {
        $this->warp = $warp;
    }

    /* ArrayAccess interface implementation */

    public function offsetGet($name): mixed
    {
        return $this->warp[$name];
    }

    public function offsetSet($name, $helper): void
    {
        $this->warp[$name] = $helper;
    }

    public function offsetUnset($name): void
    {
        unset($this->warp[$name]);
    }

    public function offsetExists($name): bool
    {
        return !empty($this->warp[$name]);
    }
}
