<?php
/**
* @package		Warp Theme Framework* +, UIKit* v3, AssetOptions.php**
* *@copyright	Copyright (C) YOOtheme GmbH
*
* @modified**	Stephan W. http://www.3d-hobby-art.de
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*/
namespace Warp\Asset;

// No direct access
defined ('_JEXEC') or die ('Restricted access');

/**
 * Asset options class, provides options implementation.
 */
abstract class AssetOptions implements \ArrayAccess {

    /**
     * @var array
     */
    protected $options;

    /**
     * Constructor.
     *
     * @param array $options
     */
    public function __construct($options = array())
    {
        $this->options = $options;
    }

    /**
     * Get options.
     *
     * @return array
     */
    public function getOptions(): array
    {
        return $this->options;
    }

    /* ArrayAccess interface implementation */

    public function offsetSet($name, $value): void
    {
        $this->options[$name] = $value;
    }

    public function offsetGet($name): mixed
    {
        return isset($this->options[$name]) ? $this->options[$name] : null;
    }

    public function offsetExists($name): bool
    {
        return isset($this->options[$name]);
    }

    public function offsetUnset($name): void
    {
        unset($this->options[$name]);
    }
}
