<?php
/********************************************************************************
 * @package         Warp Theme Framework* +, UIKit* v3
 * *@copyright    Copyright (C) YOOtheme GmbH
 *********************************************************************************
 * @package         uiThemeBuilder
 * @subpackage      Template/Layouts
 * @modified        Stephan W.
 * @copyright       https://www.ui-themebuilder.com/
 * @license         http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
defined('_JEXEC') or die;


/*
 * Theme params
 */
foreach ( array ('suffix', 'panel', 'panel_scrollspy_repeat', 'panel_scrollspy_delay', 'title_size', 'title_header', 'center', 'class') as $var )
{
	$$var = $params[$var] ?? null;
}


if  ($this['config']->get("widgets.{$widget->id}.panel", true) && in_array($widget->position, array ('top-a', 'top-b', 'top-c', 'bottom-a', 'bottom-b', 'bottom-c', 'main-top', 'main-bottom', 'sidebar-a', 'sidebar-b', 'footer-a', 'footer-b')) )
{
	$panel = $this['config']->get("widgets.{$widget->id}.panel", '');
}
// Set default panel
else if ( !empty($panel) && in_array($widget->position, array ('top-a', 'top-b', 'top-c', 'bottom-a', 'bottom-b', 'bottom-c', 'main-top', 'main-bottom', 'sidebar-a', 'sidebar-b', 'footer-a', 'footer-b')) )
{
	$panel = $this['config']->get("panel_default.{$widget->position}.panel", '');
}
// Set panel for specific positions
else if ( in_array($widget->position, array ('headerbar', 'toolbar-r', 'toolbar-l', 'offcanvas')) )
{
	$panel = 'uk-card';
}
// Set panel for breadcrumbs position
else if ( in_array($widget->position, array ('breadcrumbs', 'footer')) )
{
	$panel = 'uk-panel uk-padding-small uk-padding-remove-vertical';
}
// Set panel for info position
else if ( $widget->position == 'info' )
{
	$panel = 'uk-panel uk-padding-small';
}
// Set panel for dotnav position
else if ( $widget->position == 'dotnav' )
{
	$panel = 'uk-position-center-right uk-position-medium uk-position-fixed uk-visible@l';
}

// Set badge
$badge = ($this['config']->get("widgets.{$widget->id}.badge", true)) ? '<div class="' . $this['config']->get("widgets.{$widget->id}.badge.type") . '">' . $this['config']->get("widgets.{$widget->id}.badge.text") . '</div>' : '';

// Set FontAwesome Icons or images
$icon = ($this['config']->get("widgets.{$widget->id}.icon", true) && preg_match('/\.(gif|png|jpg|jpeg|svg)$/', $this['config']->get("widgets.{$widget->id}.icon", true))) ? '<span class="uk-position-relative uk-margin-large uk-position-small uk-position-top-center"><img src="' . $this['path']->url('site:') . '/' . $this['config']->get("widgets.{$widget->id}.icon") . '" alt="' . $widget->title . '"></span> ' : ($this['config']->get("widgets.{$widget->id}.icon") ? '<span class="uk-position-relative uk-margin-large uk-position-small uk-position-top-center"><i class="' . $this['config']->get("widgets.{$widget->id}.icon") . $this['config']->get("widgets.{$widget->id}.icon_classes") . '" aria-hidden="true"></i></span>' : '');

// Set UIkit own SVG icon system
$icons = ($this['config']->get("widgets.{$widget->id}.icons", true) && $this['config']->get("widgets.{$widget->id}.icons.ratio")) ? '<span class="uk-position-relative uk-margin-small uk-flex uk-flex-center"><i uk-icon="icon: ' . $this['config']->get("widgets.{$widget->id}.icons.type") . '; ratio: ' . $this['config']->get("widgets.{$widget->id}.icons.ratio") . '"></i></span>' : '';


/*
 * Widget params
 */

$content      = $widget->content;
$title        = ($widget->showtitle) ? $widget->title : '';
$title_header = $this['config']->get("widgets.{$widget->id}.title_header", '');
$title_size   = $this['config']->get("widgets.{$widget->id}.title_size", '');

$class      = $this['config']->get("widgets.{$widget->id}.class", '');
$center     = $this['config']->get("widgets.{$widget->id}.center", '');
$display    = $this['config']->get("widgets.{$widget->id}.display");

$panel_scrollspy = $this['config']->get("widgets.{$widget->id}.panel_scrollspy");
$panel_scrollspy_repeat = $this['config']->get("widgets.{$widget->id}.panel_scrollspy_repeat");
$panel_scrollspy_delay = $this['config']->get("widgets.{$widget->id}.panel_scrollspy_delay");


// Set title
if ( in_array($widget->position, array ('headerbar', 'toolbar-r', 'toolbar-l', 'breadcrumbs', 'footer', 'dotnav')) )
{
	$title = '';
}
if ( $title && ($widget->position == 'info') )
{
	$title = '<' . ($title_header ?: 'h3') . '>' . $title . '</' . ($title_header ?: 'h3') . '>';
}
elseif ( ($title && !($widget->position == 'menu')) || ($title && !($widget->position == 'menusplit')) )
{
	$title    = ($this['config']->get("panel_default.{$widget->position}.card_header")) ? '<div class="uk-card-header"><' . ($title_header ?: 'h3') . ' class="' . ($title_size ?: 'uk-card-title') . '"><span>' . $title . '</span></' . ($title_header ?: 'h3') . '></div>' : '<' . ($title_header ?: 'h3') . ' class="' . ($title_size ?: 'uk-card-title') . '"><span>' . $title . '</span></' . ($title_header ?: 'h3') . '>';
}


// Render menu
if ( $widget->menu )
{

	// Set menu renderer
	if ( isset($params['menu']) )
	{
		$renderer = $params['menu'];
	}
	else if ( in_array($widget->position, array ('menu', 'menusplit')) )
	{
		$renderer                              = 'navbar';
		$widget->nav_settings["scroll"]        = (bool) $this['config']->get("navbars.navbar.navbar_scroll");
		$widget->nav_settings["scroll_offset"] = ($this['config']->get("navbars.navbar.navbar_scroll")) ? $this['config']->get("navbars.navbar.navbar_scroll_offset") : '';
		$widget->nav_settings["modifier"]      = "uk-visible@l";
	}
	else if ( in_array($widget->position, array ('toolbar-l', 'toolbar-r', 'footer')) )
	{
		$renderer                         = 'subnav';
		$widget->nav_settings["modifier"] = "uk-subnav-divider";
		if ( $widget->position === 'footer' )
		{
			$widget->nav_settings["modifier"] .= " uk-flex-center uk-margin-remove-bottom";
		}
	}
	else if ( $widget->position === 'offcanvas' )
	{
		$renderer                         = 'nav';
		$widget->nav_settings["modifier"] = $this['config']->get("navoffcanvas.Off-canvas.offcanvas_nav_type");
	}
	else if ( $widget->position === 'dotnav' )
	{
		$renderer                          = 'nav';
		$widget->nav_settings["scrollspy"] = true;
		$widget->nav_settings["modifier"] = "uk-dotnav uk-dotnav-vertical";
	}
	else if ( in_array($widget->position, array ('sidebar-a', 'sidebar-b')) )
	{
		$renderer                          = 'nav';
		$widget->nav_settings["accordion"] = true;
		$widget->nav_settings["scrollspy"] = true;
	}
	else
	{
		$renderer                          = 'nav';
		$widget->nav_settings["accordion"] = true;
		$widget->nav_settings["scrollspy"] = false;
	}

	$content = $this['menu']->process($widget, array ('pre', 'subnav', $renderer, 'post'));
}

// Render widget
if ( ($widget->menu && ($widget->position == 'offcanvas')) || in_array($widget->position, array ('transparent', 'fullscreen', 'logo', 'logo-small', 'search', 'debug', 'login')) )
{
	echo $content;
}
elseif ( $widget->position === 'menu' || $widget->position === 'menusplit' )
{
	if ( $widget->menu || $widget->menusplit )
	{
		echo $content;
	}
	else
	{
		echo '<ul class="uk-navbar-nav uk-visible@l">
				<li>
					<a href="#">' . $title . '</a>
					<div class="uk-drop-grid">' . $content . '</div>
				</li>
			</ul>';
	}
}
else
{
	$widgetPanel = $this['config']->get("widgets.{$widget->id}.panel", '');
	$positionPanel = $this['config']->get("panel_default.{$widget->position}.panel", '');
	$ModContent = ( str_contains($widgetPanel, 'uk-card') || str_contains($positionPanel, 'uk-card')) ? '<div class="uk-card-body">'.$content.'</div>' : $content;

	$classes             = [$panel];
	$panel_scrollspy_atr = [$panel_scrollspy];

	// Set display
	if ( $display )
	{
		foreach ( $display as $device => $visible )
		{
			if ( !$visible )
			{
				$classes[] = 'uk-visible' . $device;
			}
		}
	}


	if ( $center )
	{
		$classes[] = "uk-text-center";
	}
	if ( $class )
	{
		$classes[] = $class;
	}
	if ( $suffix )
	{
		$classes[] = $suffix;
	}

	// Set Scrollspy animations
	if ( $panel_scrollspy )
	{
		$panel_scrollspy_atr[] = ' uk-scrollspy="cls: ' . $panel_scrollspy . (($panel_scrollspy_repeat) ? '; repeat: true' : '') . ( ($panel_scrollspy_delay) ? '; delay: ' . $panel_scrollspy_delay : '' ) . '"';
	}

	if ( in_array($widget->position, array ('sidebar-a', 'sidebar-b')) )
	{
		echo '<div class="uk-width-1-1"><div' . (!empty($classes) ? ' class="' . implode(' ', $classes) . '"' : '') . ' ' . implode(' ', $panel_scrollspy_atr) . '>' . $icon . $icons . $badge . $title . $ModContent . '</div></div>';
	}
	else
	{
		echo '<div' . (!empty($classes) ? ' class="' . implode(' ', $classes) . '"' : '') . ' ' . implode(' ', $panel_scrollspy_atr) . '>' . $icon . $icons . $badge . $title . $ModContent . '</div>';
	}
}
