<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	Template/Layouts
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;


use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

$config		= $this['config'];
$version	= Factory::getApplication()->getDocument()->getMediaVersion();

/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
$wr = $wa->getRegistry();
	$wr->addRegistryFile('uithemebuilder/joomla.asset.json');


/*
 * Add Sidebar classes
 */
$sidebars = array_keys($config->get('sidebars', array()));
$sidebar_classes = array();
	foreach ($sidebars as $sidebar) {

		$sidebar_classes[$sidebar] = array();
		$sidebar_sticky_start[$sidebar] = '';
		$sidebar_sticky_end[$sidebar] = '';
		$sidebar_classes[$sidebar][] = "tm-{$sidebar}";
		$sidebar_classes[$sidebar][] .= $config->get("sidebars.{$sidebar}.sidebar_background");
		$sidebar_classes[$sidebar][] .= $config->get("sidebars.{$sidebar}.alignment");
		$sidebar_classes[$sidebar][] .= $config->get("sidebars.{$sidebar}.widths") . $config->get("sidebars.{$sidebar}.breakpoint");

		$sidebar_row_classes[$sidebar] = ($this['config']->get("sidebars.{$sidebar}.row_gap")) ? ' '.$this['config']->get("sidebars.{$sidebar}.row_gap") : '';

		if ($this['config']->get("sidebars.{$sidebar}.sidebar_sticky", false)) {
			$sidebar_sticky_start_value		= ($this['config']->get("sidebars.{$sidebar}.sidebar_sticky_start")) ? 'start: '.$this['config']->get("sidebars.{$sidebar}.sidebar_sticky_start").';' : '';
			$sidebar_sticky_end_value		= ($this['config']->get("sidebars.{$sidebar}.sidebar_sticky_end")) ? ' end: '.$this['config']->get("sidebars.{$sidebar}.sidebar_sticky_end").';' : ' end: true;';
			$sidebar_sticky_offset			= ($this['config']->get("sidebars.{$sidebar}.sidebar_sticky_offset")) ? ' offset: '.$this['config']->get("sidebars.{$sidebar}.sidebar_sticky_offset").';' : '';

			$sidebar_sticky_start[$sidebar] = '<div uk-sticky="'.$sidebar_sticky_start_value.$sidebar_sticky_end_value.$sidebar_sticky_offset.' media: @m; animation: uk-animation-slide-top" class="uk-sticky">';
			$sidebar_sticky_end[$sidebar] = '</div>';
		}

		$widgets = $this['widgets']->load($sidebar);

		$sidebar_classes[$sidebar] = implode(" ", $sidebar_classes[$sidebar]);

	}

/*
 * Add block section classes
 */
$blocks			= array_keys($config->get('block', array()));
$block_classes	= array();
$block_attr		= array();
$block_img_bg	= array();
	foreach ($blocks as $block) {

		$block_classes[$block]	= $config->get("block.{$block}.block-bg");
		$block_classes[$block]	.= ($this['config']->get("block.{$block}.block-padding-large")) ? ' uk-block-large' : '';
		$block_classes[$block]	.= $config->get("block.{$block}.block-padding");
		$block_classes[$block]	.= ($this['config']->get("block.{$block}.preserve-color")) ? ' uk-preserve-color' : '';
		$block_classes[$block]	.= ($this['config']->get("block.{$block}.block-divider")) ? ' tm-section-divider' : '';
		$block_classes[$block]	.= ($this['config']->get("block.{$block}.block_bg_image")) ? ' tm-block-bg-image' : '';

		$block_img_bg_fixed				= ($this['config']->get("block.{$block}.block_bg_image_fixed")) ? ' uk-background-fixed' : '';
		$block_bg_image_size			= ($this['config']->get("block.{$block}.block_bg_image_size")) ?: '';
		$block_bg_image_position		= ($this['config']->get("block.{$block}.block_bg_image_position")) ?: '';
		$block_img_bg_classes[$block]	= ($this['config']->get("block.{$block}.block_bg_image")) ? ' uk-background-image'.$this['config']->get("block.{$block}.block_bg_image_breakpoints"). ' uk-background-norepeat ' . $block_img_bg_fixed . $block_bg_image_size . $block_bg_image_position : '';
		$block_img_bg_parallax			= ($this['config']->get("block.{$block}.block_bg_image_parallax")) ? ' uk-parallax="bgy: -220"' : '';
		$block_img_bg[$block]			= ($this['config']->get("block.{$block}.block_bg_image")) ? 'data-src="' . JUri::root() . htmlspecialchars($this['config']->get("block.{$block}.block_bg_image")) . '" uk-img style="background-color: rgb(11, 12, 13);" ' . $block_img_bg_parallax : '';

		$block_attr_options	= ($this['config']->get("block.{$block}.block-viewport-height-attr")) ?: '';
		$block_attr[$block]	= ($this['config']->get("block.{$block}.block-viewport-height")) ? ' uk-height-viewport="' . $block_attr_options . '"' : '';

	}

/*
 * Add grid classes
 */
$positions 						= array_keys($config->get('grid', array()));
$displays  						= array('@xl', '@l', '@m', '@s');
$grid_classes 					= array();
$grid_masonry_scrollspy_attr	= array();
$grid_attr						= array();
$display_classes 				= array();

	foreach ($positions as $position) {

		$grid_classes[$position] 					= array();
		$grid_classes[$position][] 					= "tm-{$position}";
		$grid_classes[$position][] 					.= $config->get("grid.{$position}.grid_gutter");
		$grid_classes[$position][] 					.= $config->get("grid.{$position}.column_gap");
		$grid_classes[$position][] 					.= $config->get("grid.{$position}.row_gap");

		$grid_classes[$position][]					.= ($config->get("grid.{$position}.layout") === 'masonry') ? 'uk-child-width-1-2@s uk-child-width-1-3@m uk-child-width-1-' . $config->get("grid.{$position}.grid_masonry_child_width") . '@l' : ' ';
		$grid_masonry_scrollspy_attr[$position][] 	= ($config->get("grid.{$position}.layout") === 'masonry') ? ($config->get("grid.{$position}.grid_masonry_scrollspy")) ? ' uk-scrollspy="target: > div; cls:uk-animation-fade; delay: ' . $this['config']->get("grid.{$position}.grid_masonry_scrollspy_delay") . ';' . ($this['config']->get("grid.{$position}.grid_masonry_scrollspy_repeat") ?'; repeat: true' : '') . '"' : '' : '';
		$grid_attr[$position][] 					= ($config->get("grid.{$position}.layout") === 'masonry') ? ' uk-grid="masonry: true" ' : ' uk-grid';

		$display_classes[$position][]				= '';

		if ($this['config']->get("grid.{$position}.grid_match", false)) {
			$grid_classes[$position][] = 'uk-grid-match';
		}

		if ($this['config']->get("grid.{$position}.divider", false)) {
			$grid_classes[$position][] = 'uk-grid-divider';
		}

		$widgets = $this['widgets']->load($position);

		foreach($displays as $display) {
			if (!array_filter($widgets, function($widget) use ($config, $display) { return (bool) $config->get("widgets.{$widget->id}.display.{$display}", true); })) {
				$display_classes[$position][] = "uk-visible{$display}";
			 } // elseif (!array_filter($widgets, function($widget) use ($config, $display) { return (bool) ($config->get("widgets.{$widget->id}.display.{$display}") == '0'); })) {
				// $display_classes[$position][] = "uk-hidden{$display} uk-visible{$display}";
			// }
		}

		$display_classes[$position]					= implode(" ", $display_classes[$position]);
		$grid_classes[$position]					= implode(" ", $grid_classes[$position]);
		$grid_masonry_scrollspy_attr[$position]		= implode(" ", $grid_masonry_scrollspy_attr[$position]);
		$grid_attr[$position]						= implode(" ", $grid_attr[$position]);

	}

/*
 * Add container classes
 */ 
$ui_container = array_keys($config->get('container', array()));
$container_classes = array();
	foreach ($ui_container as $container)
	{

		$container_classes[$container]			= $config->get("container.{$container}.ui-container");
		$container_classes[$container]			.= ($this['config']->get("container.{$container}.container-padding-remove")) ? ' uk-padding-remove' : '';

		$container_img_bg_fixed					= ($this['config']->get("container.{$container}.container_bg_image_fixed")) ? ' uk-background-fixed' : '';
		$container_classes[$container]			.= ($this['config']->get("container.{$container}.container_bg_image")) ? ' uk-background-image' . $this['config']->get("container.{$container}.container_bg_image_breakpoints") . ' uk-background-norepeat ' . $container_img_bg_fixed . $this['config']->get("container.{$container}.container_bg_image_size") . $this['config']->get("container.{$container}.container_bg_image_position") : '';
		$container_img_bg_parallax				= ($this['config']->get("container.{$container}.container_bg_image_parallax")) ? ' uk-parallax="bgy: -210"' : '';
		$container_img_bg[$container]			= ($this['config']->get("container.{$container}.container_bg_image")) ? 'data-src="' . JUri::root() . htmlspecialchars($this['config']->get("container.{$container}.container_bg_image")) . '" uk-img ' . $container_img_bg_parallax : '';

	}

/*
 * navbar settings
 */

$navbar_login_img					= ($this['config']->get("navbars.navbar.navbar_login_bg_image")) ? ' data-src="' . Uri::root() . htmlspecialchars($this['config']->get("navbars.navbar.navbar_login_bg_image")) . '" uk-img="" style="background-color: rgb(11, 12, 13);" ' : '';

$navbar_container					= ($this['config']->get("navbars.navbar.navbar_container")) ?: '';
$navbar_color_mode					= ($this['config']->get("navbars.navbar.navbar_color_mode")) ? ' '.$this['config']->get("navbars.navbar.navbar_color_mode") : '';
$navbar_text_bold					= ($this['config']->get("navbars.navbar.navbar_text_bold")) ? ' uk-text-bold' : '';
$navbar_transparent					= ($this['config']->get("navbars.navbar.navbar_transparent")) ? ' uk-navbar-transparent' : '';
$navbar_sticky_transparent			= ($this['config']->get("navbars.navbar.navbar_sticky_transparent")) ? ' cls-inactive: uk-navbar-transparent' . $navbar_color_mode.';' : '';
$navbar_attr_sticky_show_on_up		= ($this['config']->get("navbars.navbar.sticky_show_on_up")) ? 'show-on-up: true;' : '';
$navbar_attr_sticky					= ($this['config']->get("navbars.navbar.sticky_navbar")) ? ' uk-sticky="'.$navbar_attr_sticky_show_on_up.'media: ' . $this['config']->get("navbars.navbar.media_breakpoint") . '; top: 300; animation: ' . $this['config']->get("navbars.navbar.sticky_navbar_animation") . '; sel-target: .uk-navbar-container; cls-active: uk-navbar-sticky;' . $navbar_sticky_transparent . '"' : '';

$navbar_mode						= ($this['config']->get("navbars.navbar.navbar_mode")) ? ' mode: click;' : '';

$navbar_attr_boundary_align			= ($this['config']->get("navbars.navbar.navbar_boundary_align")) ? 'target: .uk-navbar-container;' : '';
$navbar_attr_dropbar_mode			= ($this['config']->get("navbars.navbar.navbar_mode_dropbar_push")) ? ' dropbar-mode: push;' : ' ';
$navbar_attr_dropbar				= ($this['config']->get("navbars.navbar.navbar_mode_dropbar")) ? ' dropbar: true; dropbar-anchor: !.uk-navbar-container;'.$navbar_attr_dropbar_mode : '';

$navbar_attr						= ' uk-navbar="' . $navbar_attr_boundary_align . $navbar_attr_dropbar . $navbar_mode . '"';


/*
 * offcanvas settings
 */
$offcanvas_attr_flip		= ($this['config']->get("navoffcanvas.Off-canvas.offcanvas_flip")) ? ' flip: true;' : '';
$offcanvas_attr				= ' uk-offcanvas="mode: ' . $this['config']->get("navoffcanvas.Off-canvas.offcanvas_mode") . ';'.$offcanvas_attr_flip.' overlay: true"';
 
/*
 * design branding
 */
$design = 'PHNwYW4+YnVpbGQgd2l0aCA8YSB0YXJnZXQ9Il9ibGFuayIgaHJlZj0iaHR0cHM6Ly93d3cudWktdGhlbWVidWlsZGVyLmNvbS8iIHRpdGxlPSJ1aS9UaGVtZS1CdWlsZGVyIj51aS10aGVtZWJ1aWxkZXIuY29tPC9hPjwvc3Bhbj4=';

/*
 * Add body classes, Images
 */
$app 				= Factory::getApplication()->input;
$view 				= $app->get('option');
// $body_classes 		= str_replace('_', '-', $view);

$body_bg_image	= $this['config']->get("html_body.body.body_bg_image") ? ' data-src="' . Uri::root() . htmlspecialchars($this['config']->get("html_body.body.body_bg_image")) . '" uk-img' : '';

$body_classes 	= $this['system']->isBlog() ? ' tm-isblog' : ' tm-noblog';

// <body> tag Background Image
$body_classes	.= $this['config']->get("html_body.body.html_body_bg_image_breakpoints") ? ' uk-background-image'.$this['config']->get("html_body.body.html_body_bg_image_breakpoints") : '';
$body_classes	.= $this['config']->get("html_body.body.html_body_bg_image_size") ? ' '.$this['config']->get("html_body.body.html_body_bg_image_size") : '';
$body_classes	.= $this['config']->get("html_body.body.html_body_bg_image_position") ? ' '.$this['config']->get("html_body.body.html_body_bg_image_position") : '';
$body_classes	.= $this['config']->get("html_body.body.body_background", true) ? ' '.$this['config']->get("html_body.body.body_background") : '';
$body_classes 	.= $this['config']->get("html_body.body.html_body_bg_image_fixed", 0) ? ' uk-background-fixed' : '';
$body_classes 	.= $this['config']->get("html_body.body.html_body_bg_image_repeat", 0) ? ' uk-background-norepeat' : '';

// <body> tag animation
$body_classes	.= $this['config']->get('body_animation_fade', 0) ? ' uk-animation-fade' : '';

if ($this['config']->get('page_class')) {
	$body_classes	.= ' '.$config->get('page_class');
}
if ($this['config']->get('article_style', 0)) {
	$body_classes	.= ' '.$config->get('article_style');
}
if ($this['config']->get('article_style_card', 0)) {
	$body_classes	.= ' '.$config->get('article_style_card');
}

$config->set('body_classes', trim($body_classes));

/*
 * Add boxed layout
 */
$boxed_layout = $this['config']->get('boxed_layouts') ? '<div class="uk-container '.$config->get('boxed_layouts_width').'">' : '';
$config->set('boxed_layout', trim($boxed_layout));

/*
 * Add social buttons
 */
$body_config = array();

if ($this['config']->get('twitter', 0) || $this['config']->get('facebook', 0) || $this['config']->get('linkedin', 0)  || $this['config']->get('pinterest', 0) || $this['config']->get('whatsapp', 0)) :
	$wa->useScript('template.social')
		->useScript('template.theme-social');
endif;
if ($this['config']->get('twitter', 0)) :
	$body_config['twitter']  = (int) $config->get('twitter', 0);
endif;
if ($this['config']->get('facebook', 0)) :
	$body_config['facebook']  = (int) $config->get('facebook', 0);
endif;
if ($this['config']->get('linkedin', 0)) :
	$body_config['linkedin']  = (int) $config->get('linkedin', 0);
endif;
if ($this['config']->get('pinterest', 0)) :
	$body_config['pinterest']  = (int) $config->get('pinterest', 0);
endif;
if ($this['config']->get('whatsapp', 0)) :
	$body_config['whatsapp']  = (int) $config->get('whatsapp', 0);
endif;

$body_config['style']    = $config->get('style');

$config->set('body_config', json_encode($body_config, JSON_THROW_ON_ERROR));


// internet explorer
if ($this['useragent']->browser() === 'msie') {
	$head[] = sprintf('<!--[if IE 8]><link rel="stylesheet" href="%s"><![endif]-->', $this['path']->url('css:ie8.css'));
	$head[] = sprintf('<!--[if lte IE 8]><script src="%s"></script><![endif]-->', $this['path']->url('js:html5.js'));
}

if (isset($head)) {
	$this['template']->set('head', implode("\n", $head));
}
