<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	Template/Layouts
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Language\Associations;
use Joomla\CMS\Microdata\Microdata;
use Joomla\CMS\Uri\Uri;

$uri = Uri::getInstance();

$assocParam = (Associations::isEnabled() && $associations);

global $tm_count;
if (!isset($tm_count)) {
	$tm_count = 1;
}
else {
	$tm_count++;
}

// #Todo Not that elegant would be nice to group the params
$useDefList = ($date_modified || $date_published || $date || $hits || $category || $parent_category || $author || $assocParam);


$articleId = Factory::getApplication()->input->get('id');
$db = Factory::getContainer()->get('DatabaseDriver');
$query = $db->getQuery(true)
		->select($db->quoteName('itemid'))
		->from($db->quoteName('#__schemaorg'))
		->where($db->quoteName('itemid') . ' = ' . $db->quote($articleId));
$db->setQuery($query);
$schemaorgId = $db->loadResult();

$contentLanguageMicrodata   = (!$schemaorgId ? Microdata::htmlMeta($content_language, 'inLanguage', $scope = "", $inverse = false) : '');
$articleMicrodata           = (!$schemaorgId ? Microdata::htmlScope('Article') : '');
$imageMicrodata             = (!$schemaorgId ? Microdata::htmlProperty('image') : '');
$imageObjectMicrodata       = (!$schemaorgId ? Microdata::htmlScope('ImageObject') : '');

$contentUrlMicrodata        = (!$schemaorgId ? Microdata::htmlProperty('contentUrl') : '');

$headlineMicrodata          = (!$schemaorgId ? Microdata::htmlProperty('headline') : '');
$urlMicrodata               = (!$schemaorgId ? Microdata::htmlProperty('url') : '');
$articleBodyMicrodata       = (!$schemaorgId ? Microdata::htmlProperty('articleBody') : '');

$creatorMicrodata           = (!$schemaorgId ? Microdata::htmlProperty('creator') : '');
$personMicrodata            = (!$schemaorgId ? Microdata::htmlScope('Person') : '');
$authorMicrodata            = (!$schemaorgId ? Microdata::htmlProperty('author') : '');
$nameMicrodata              = (!$schemaorgId ? Microdata::htmlProperty('name') : '');

$datePublishedMicrodata     = (!$schemaorgId ? Microdata::htmlProperty('datePublished') : '');
$dateModifiedMicrodata      = (!$schemaorgId ? Microdata::htmlProperty('dateModified') : '');
$genreMicrodata             = (!$schemaorgId ? Microdata::htmlProperty('genre') : '');

$licenseMicrodata           = (!$schemaorgId ? Microdata::htmlProperty('license') : '');

$imageClass = ($image && $image_alignment !== '' ? ' tm-has-image' : '');

// default category article view
if ($this->warp['system']->application->input->get('view') === 'category' || $this->warp['system']->application->input->get('view') === 'featured')
{ ?>

	<?php // Cards with intro Image --------------------------------- 
	if ( $intro_image && $this['config']->get('article_card_style') === 'media_card_style' && $this['config']->get('article_cards_media') == '' )
	{ ?>

		<div class="uk-card uk-card-<?php echo $this['config']->get('article_cards_style'); ?><?php echo ($this['config']->get('article_cards_style_size')) ? ' '.$this['config']->get('article_cards_style_size') : ''; ?> uk-grid-collapse uk-child-width-1-2@s" uk-grid="">
			<?php echo $contentLanguageMicrodata; ?>
			<div class="<?php echo (($tm_count) % 2 == 1) ? 'uk-card-media-left ' : 'uk-flex-last@s uk-card-media-right '; ?>uk-cover-container">
				<img <?php echo $imageMicrodata; ?> src="<?php echo Uri::root() . $intro_image; ?>" data-src="<?php echo Uri::root() . $intro_image; ?>"<?php if ($image_intro_alt) : ?> alt="<?php echo $image_intro_alt; ?>"<?php endif; ?> uk-cover="" uk-img="">
				<canvas width="400" height="300"></canvas>
			</div>

			<div>
				<div class="uk-card-header">
					<div class="uk-grid-small uk-flex-middle" uk-grid="">
						<?php if ( $edit ) : ?>
							<div class="uk-width-auto">
								<p class="tm-icons"><?php echo $edit; ?></p>
							</div>
						<?php endif; ?>
						<?php if ( $title || ($useDefList && $info_block_above) ) : ?>
							<div class="uk-width-expand">
								<?php if ( $title ) : ?>
									<h2 class="uk-card-title<?php if ( $useDefList && $info_block_above ) : ?> uk-margin-remove-bottom uk-text-truncate<?php endif; ?>"<?php if ( $useDefList && $info_block_above ) : ?> uk-tooltip="title: <?php echo $title; ?>;"<?php endif; ?> <?php echo $headlineMicrodata; ?>>
										<?php if ( $title_link_url && $title_link ) : ?>
											<a class="uk-link-reset uk-text-break" href="<?php echo $title_link_url; ?>" title="<?php echo $title; ?>" <?php echo $urlMicrodata; ?>><?php echo $title; ?></a>
										<?php else : ?>
											<?php echo $title; ?>
										<?php endif; ?>
									</h2>
								<?php endif; ?>
								<?php if ( $useDefList && $info_block_above ) : ?>
									<?php echo $info_block_above; ?>
								<?php endif; ?>
							</div>
						<?php endif; ?>
					</div>
				</div>

				<?php if ($article_intro) : ?>
					<div class="uk-card-body" <?php echo $articleBodyMicrodata; ?>>
						<?php echo $article_intro; ?>
					</div>
				<?php endif; ?>

				<?php if ($more) : ?>
					<div class="uk-card-footer">
						<?php echo $more; ?>
					</div>
				<?php endif; ?>

			</div>
		</div>

	 <?php // Cards with intro Image top or bottom ------------------------------------------------------------------
	} 
	 else if ( $this['config']->get('article_card_style') === 'media_card_style' )
	{ ?>

		<div class="uk-card uk-card-small uk-card-<?php echo $this['config']->get('article_cards_style'); ?><?php echo ($this['config']->get('article_cards_style_size')) ? ' '.$this['config']->get('article_cards_style_size') : ''; ?>">
			<?php echo $contentLanguageMicrodata; ?>
			<?php if ( $intro_image && $this['config']->get('article_cards_media') === 'top' ) { ?>
				<div class="uk-card-media-top uk-cover-container uk-height-medium">
					<img <?php echo $imageMicrodata; ?> src="<?php echo Uri::root() . $intro_image; ?>" data-src="<?php echo Uri::root() . $intro_image; ?>"<?php if ($image_intro_alt) : ?> alt="<?php echo $image_intro_alt; ?>"<?php endif; ?> uk-img="" uk-cover="">
				</div>
			<?php } ?>

			<div class="uk-card-header">
				<div class="uk-grid-small uk-flex-middle" uk-grid="">
					<?php if ( $edit ) : ?>
						<div class="uk-width-auto">
							<p class="tm-icons"><?php echo $edit; ?></p>
						</div>
					<?php endif; ?>
					<?php if ( $title || ($useDefList && $info_block_above) ) : ?>
						<div class="uk-width-expand">
							<?php if ( $title ) : ?>
								<h2 class="uk-card-title<?php if ( $useDefList ) : ?> uk-margin-remove-bottom uk-text-truncate<?php endif; ?>"<?php if ( $useDefList && $info_block_above ) : ?> uk-tooltip="title: <?php echo $title; ?>;"<?php endif; ?> <?php echo $headlineMicrodata; ?>>
									<?php if ( $title_link_url && $title_link ) : ?>
										<a class="uk-link-reset uk-text-break" href="<?php echo $title_link_url; ?>" title="<?php echo $title; ?>" <?php echo $urlMicrodata; ?>><?php echo $title; ?></a>
									<?php else : ?>
										<?php echo $title; ?>
									<?php endif; ?>
								</h2>
							<?php endif; ?>
							<?php if ( $useDefList && $info_block_above ) : ?>
								<?php echo $info_block_above; ?>
							<?php endif; ?>
						</div>
					<?php endif; ?>
				</div>
			</div>

			<?php if ($article_intro) : ?>
				<div class="uk-card-body" <?php echo $articleBodyMicrodata; ?>>
					<?php echo $article_intro; ?>
				</div>
			<?php endif; ?>

			<?php if ($more) : ?>
				<div class="uk-card-footer">
					<?php echo $more; ?>
				</div>
			<?php endif; ?>

			<?php if ( $intro_image && $this['config']->get('article_cards_media') === 'bottom' ) { ?>
				<div class="uk-card-media-bottom uk-cover-container uk-height-medium">
					<img <?php echo $imageMicrodata; ?> data-src="<?php echo Uri::root() . $intro_image; ?>" src="<?php echo Uri::root() . $intro_image; ?>"<?php if ($image_intro_alt) : ?> alt="<?php echo $image_intro_alt; ?>"<?php endif; ?> uk-img="" uk-cover="">
				</div>
			<?php } ?>

		</div>

	 <?php // default article output ------------------------------------------------------------------
	}
	else
	{ ?>
		<?php echo $contentLanguageMicrodata; ?>
		<?php // usefully for leading articles ?>
		<?php if (!$article_intro && $image && $title && $more_small && $float_intro === 'background' )
		{ ?>

			<div class="uk-height-large uk-flex uk-flex-center uk-flex-middle uk-background-cover" data-src="<?php echo URI::root() . $image; ?>" uk-img="loading: eager">
			  <div class="uk-text-center">
				  <h2 class="uk-article-title uk-margin-small-bottom uk-light" <?php echo $headlineMicrodata; ?>>
					<?php if ($title_link_url && $title_link) : ?>
						<a class="uk-link-reset uk-text-break" href="<?php echo $title_link_url; ?>" title="<?php echo $title; ?>" <?php echo $urlMicrodata; ?>><?php echo $title; ?></a>
					<?php else : ?>
						<?php echo $title; ?>
					<?php endif; ?>
				  </h2>
				  <?php echo $more_small; ?>
			  </div>
			</div>

			<?php 
		}
		else
		{ ?>

			<?php if ( $image && $intro_image && $float_intro === 'cover' ) : ?>
				<div class="uk-margin-medium-bottom" uk-lightbox="">
					<a class="uk-display-block uk-link-reset"<?php if ($image_intro_caption) : ?> data-caption="<?php echo $image_intro_caption; ?>"<?php endif; ?> href="<?php echo URI::root() . $image; ?>">
						<div class="uk-cover-container uk-height-medium">
							<img <?php echo $imageMicrodata; ?> src="<?php echo URI::root() . $image; ?>" data-src="<?php echo URI::root() . $intro_image; ?>"<?php if ($image_intro_alt) : ?> alt="<?php echo $image_intro_alt; ?>"<?php endif; ?> uk-img="" uk-cover="">
						</div>
					</a>
				</div>
			<?php endif; ?>

			<?php if ( $title ) : ?>
				<div class="uk-container uk-container-expand<?php if ( $useDefList || ($info == 0 || $info == 2) ) : ?> uk-margin-small-bottom<?php endif; ?>">
					<hr class="uk-divider-small uk-margin-small-bottom ">
					<h2 class="uk-article-title uk-margin-remove-top" <?php echo $headlineMicrodata; ?>>
						<?php if ($title_link_url && $title_link) : ?>
							<a class="uk-link-reset uk-text-break" href="<?php echo $title_link_url; ?>" title="<?php echo $title; ?>" <?php echo $urlMicrodata; ?>><?php echo $title; ?></a>
						<?php else : ?>
							<?php echo $title; ?>
						<?php endif; ?>
					</h2>
				</div>
			<?php endif; ?>

			<?php if ($useDefList || ($info == 0 || $info == 2)) : ?>
				<?php echo $info_block_above; ?>
			<?php endif; ?>

			<?php if ($info == 0 && $show_tags) : ?>
				<?php echo $show_tags; ?>
			<?php endif; ?>

			<?php if (!$hook_aftertitle) : ?>
				<?php // Content is generated by content plugin event "onContentAfterTitle" ?>
				<?php echo $hook_aftertitle; ?>
			<?php endif; ?>

			<?php echo $hook_beforearticle; ?>

			<?php if ($intro_image && ($float_intro === 'left' || $float_intro === 'right')) : ?>
				<?php if ($title_link_url) : ?>
					<a class="uk-align-center uk-align-<?php echo $float_intro; ?>@m uk-margin-remove-adjacent" href="<?php echo $title_link_url; ?>" title="<?php echo $image_intro_caption; ?>">
						<img <?php echo $imageMicrodata; ?> data-src="<?php echo Uri::root() . $intro_image; ?>" src="<?php echo Uri::root() . $intro_image; ?>"<?php if ($image_intro_alt) : ?> alt="<?php echo $image_intro_alt; ?>"<?php endif; ?> uk-img="">
					</a>
				<?php else : ?>
					<img <?php echo $imageMicrodata; ?> class="uk-align-center uk-align-<?php echo $float_intro; ?>@m uk-margin-remove-adjacent" data-src="<?php echo Uri::root() . $intro_image; ?>" src="<?php echo Uri::root() . $intro_image; ?>"<?php if ($image_intro_alt) : ?> alt="<?php echo $image_intro_alt; ?>"<?php endif; ?> uk-img="">
				<?php endif; ?>
			<?php endif; ?>

			<?php if ($article_intro) : ?>
				<div class="uk-margin" <?php echo $articleBodyMicrodata; ?>>
					<?php echo $article_intro; ?>
				</div>
			<?php endif; ?>

			<?php if ($info == 1 || $info == 2) : ?>
				<hr class="uk-divider-icon">
				<?php if ($useDefList) : ?>
					<?php echo $info_block_below; ?>
				<?php endif; ?>

			<?php endif; ?>

			<?php if ($more) : ?>
				<div class="uk-grid-small uk-child-width-auto" uk-grid>
					<div><?php echo $more; ?></div>
				</div>
			<?php endif; ?>

		 <?php 
		} ?>
	 <?php 
	}
	?>


  <?php // default single full article view
}
elseif ($this->warp['system']->application->input->get('view') === 'article')
{ ?>

	<article class="uk-article<?php echo $imageClass; ?>" <?php if ($this->warp['system']->application->input->get('view') === 'article') : ?><?php echo 'data-permalink="'. $uri->toString() .'"'; ?><?php endif; ?><?php echo $articleMicrodata;?>>
		<?php echo $contentLanguageMicrodata; ?>
		<?php

		// Split Joomla Article alt-description (Full Article Image) into 2 or 3 parts
		$pipeCount = substr_count($image_alt, '|');
		if ($pipeCount === 2)
		{
			$parts = explode('|', $image_alt, 2);
			// Default Alt Image Description
			$imageAlt = trim($parts[0]);

			$parts = explode('|', $parts[1], 2);
			// Microdata Creator
			$imageMicrodataMetaCreator = trim($parts[0]);
			// Microdata License
			$imageMicrodataLicense = trim($parts[1]);

		}
		elseif ($pipeCount === 1)
		{
			$parts = explode('|', $image_alt);
			// Default Alt Image Description
			$imageAlt = trim($parts[0]);
			// Microdata Creator
			$imageMicrodataMetaCreator = trim($parts[1]);
			// Microdata License
			$imageMicrodataLicense     = '';
		}
		else
		{
			$imageMicrodataMetaCreator = '';
			$imageAlt                  = trim($image_alt);
			$imageMicrodataLicense     = '';
		}

		// Article Title overlapping style
		if ( $title && $image && ($this['config']->get('article_overlapping_style') === 'overlapping_style') )
		{
			if (25 <= \strlen($title)) {
				$truncated_text = substr($title, 0, 25);
				$last_space = strrpos($truncated_text, " ");
				$truncated_text = substr($truncated_text, 0, $last_space);
				$truncated_text .= "...";
				$tooltip = ' uk-tooltip="title: '.$title.'"';
			}
			else
			{
				$truncated_text = $title;
				$tooltip = '';
			} ?>
			<div class="uk-panel uk-margin-medium-bottom uk-visible@m">
				<div class="uk-padding-large uk-padding-remove-vertical uk-padding-remove-right uk-margin-left">
					<div uk-lightbox="">
						<a class="uk-display-block uk-link-reset"<?php if ($imageAlt) : ?> data-alt="<?php echo $imageAlt; ?>"<?php endif; if ($image_caption) : ?> data-caption="<?php echo $image_caption; ?><?php echo ($imageMicrodataLicense) ? ' - '.$imageMicrodataLicense : ''; ?>"<?php endif; ?> href="<?php echo URI::root() . $image; ?>">
							<div class="uk-cover-container uk-height-large" <?php echo $imageObjectMicrodata;?>>
								<img <?php echo $contentUrlMicrodata; ?> src="<?php echo URI::root() . $image; ?>" data-src="<?php echo URI::root() . $image; ?>"<?php if ($imageAlt) : ?> alt="<?php echo $imageAlt; ?>"<?php endif; ?> uk-img="" uk-cover="">
								<?php if ($imageMicrodataMetaCreator && $creatorMicrodata && $personMicrodata) : ?>
									<span <?php echo $creatorMicrodata; ?> <?php echo $personMicrodata;?>>
                                        <?php echo Microdata::htmlMeta($imageMicrodataMetaCreator, 'name'); ?>
                                    </span>
								<?php endif; ?>
								<?php if ($imageMicrodataLicense && $licenseMicrodata) : ?>
									<span <?php echo $licenseMicrodata; ?> hidden=""><?php echo $imageMicrodataLicense; ?></span>
								<?php endif; ?>
							</div>
						</a>
					</div>
				</div>

				<div class="uk-box-shadow-medium uk-position-bottom-left uk-padding uk-margin-large-bottom uk-margin-right uk-background-secondary uk-light">
					<hr class="uk-divider-small uk-margin-small-bottom">
					<h2 class="uk-article-title uk-margin-remove" <?php echo $headlineMicrodata; ?><?php echo $tooltip; ?>>
						<?php echo $truncated_text; ?>
					</h2>
				</div>
			</div>

			<div class="uk-panel uk-margin-medium-bottom uk-hidden@m">
				<div uk-lightbox="">
					<a class="uk-display-block uk-link-reset"<?php if ($imageAlt) : ?> data-alt="<?php echo $imageAlt; ?>"<?php endif; ?><?php if ($image_caption) : ?> data-caption="<?php echo $image_caption; ?>"<?php endif; ?> href="<?php echo URI::root() . $image; ?>">
						<div class="uk-cover-container uk-height-large">
							<img src="<?php echo URI::root() . $image; ?>" data-src="<?php echo URI::root() . $image; ?>"<?php if ($imageAlt) : ?> alt="<?php echo $imageAlt; ?>"<?php endif; ?> uk-img="" uk-cover="">
						</div>
					</a>
				</div>
				<div class="uk-container uk-container-expand uk-margin">
					<hr class="uk-divider-small uk-margin-small-bottom">
					<h2 class="uk-article-title uk-margin-remove-top">
						<?php echo $title; ?>
					</h2>
				</div>
			</div>

		 <?php
		}
		else if ($image && $image_alignment === 'lightbox')
		{ ?>

			<div class="uk-margin-medium-bottom" uk-lightbox="">
				<a class="uk-display-block uk-link-reset"<?php if ($imageAlt) : ?> data-alt="<?php echo $imageAlt; ?>"<?php endif; ?><?php if ($image_caption) : ?> data-caption="<?php echo $image_caption; ?><?php echo ($imageMicrodataLicense) ? ' - '.$imageMicrodataLicense : ''; ?>"<?php endif; ?> href="<?php echo URI::root() . $image; ?>">
					<div class="uk-cover-container uk-height-large" <?php echo $imageObjectMicrodata;?>>
						<img <?php echo $contentUrlMicrodata; ?> src="<?php echo URI::root() . $image; ?>" data-src="<?php echo URI::root() . $image; ?>"<?php if ($imageAlt) : ?> alt="<?php echo $imageAlt; ?>"<?php endif; ?> uk-img="" uk-cover="">
						<?php if ($imageMicrodataMetaCreator && $creatorMicrodata && $personMicrodata) : ?>
							<span <?php echo $creatorMicrodata; ?> <?php echo $personMicrodata;?>>
                                <?php echo Microdata::htmlMeta($imageMicrodataMetaCreator, 'name'); ?>
                            </span>
						<?php endif; ?>
						<?php if ($imageMicrodataLicense && $licenseMicrodata) : ?>
							<span <?php echo $licenseMicrodata; ?> hidden=""><?php echo $imageMicrodataLicense; ?></span>
						<?php endif; ?>
					</div>
				</a>
			</div>

			<?php if ($title) : ?>
				<div class="uk-container uk-container-expand uk-margin">
					<hr class="uk-divider-small uk-margin-small-bottom">
					<h2 class="uk-article-title uk-margin-remove-top" <?php echo $headlineMicrodata; ?> >
						<?php echo $title; ?>
					</h2>
				</div>
			<?php endif; ?>

			<?php echo $hook_aftertitle; ?>
		 <?php
		}
		else
		{ ?>
			<?php if ($title) : ?>
				<div class="uk-container uk-container-expand uk-margin">
					<hr class="uk-divider-small uk-margin-small-bottom">
					<h2 class="uk-article-title uk-margin-remove-top" <?php echo $headlineMicrodata; ?> >
						<?php echo $title; ?>
					</h2>
				</div>
			<?php endif; ?>

			<?php echo $hook_aftertitle; ?>

			<?php if ($image && $image_alignment !== 'lightbox') : ?>
				<div class="uk-margin" <?php echo $imageObjectMicrodata;?>>
					<?php if ($url) : ?>
						<a href="<?php echo $url; ?>" title="<?php echo $image_caption; ?>">
							<img <?php echo $contentUrlMicrodata; ?> data-src="<?php echo URI::root() . $image; ?>" src="<?php echo URI::root() . $image; ?>" alt="<?php echo $imageAlt; ?>" uk-img="">
							<?php if ($imageMicrodataMetaCreator && $creatorMicrodata && $personMicrodata) : ?>
								<span <?php echo $creatorMicrodata; ?> <?php echo $personMicrodata;?>>
	                                <?php echo Microdata::htmlMeta($imageMicrodataMetaCreator, 'name'); ?>
	                            </span>
							<?php endif; ?>
						</a>
						<?php if ($imageMicrodataLicense && $licenseMicrodata) : ?>
							<span class="uk-text-small" <?php echo $licenseMicrodata; ?>><?php echo $imageMicrodataLicense; ?></span>
						<?php endif; ?>
					<?php else : ?>
						<img <?php echo $contentUrlMicrodata; ?> data-src="<?php echo URI::root() . $image; ?>" src="<?php echo URI::root() . $image; ?>" alt="<?php echo $imageAlt; ?>" uk-img="">
						<?php if ($imageMicrodataMetaCreator && $imageMicrodataLicense && $creatorMicrodata) { ?>
							<span class="uk-text-small">
								<span <?php echo $creatorMicrodata; ?> <?php echo $personMicrodata;?>>
		                            <?php echo Microdata::htmlMeta($imageMicrodataMetaCreator, 'name'); ?>
		                        </span>
								<span><?php echo $imageMicrodataMetaCreator; ?></span>
								<span <?php echo $licenseMicrodata; ?>><?php echo $imageMicrodataLicense; ?></span>
							</span>
						<?php } ?>
					<?php endif; ?>
				</div>
			<?php endif; ?>

			<?php
		} ?>

		<?php
		$microdataPerson = $personMicrodata;
		?>
		<?php if ( $info == '2' && ($category || $author) ) : ?>
			<?php
			$authorUrl          = ( $author_url ? '<span class="uk-visible@m" '.$authorMicrodata.' '.$microdataPerson.'><span class="uk-margin-small-right" uk-icon="user" aria-hidden="true"></span><a href="'.$author_url.'" '.$urlMicrodata.'><span '.$nameMicrodata.'>'.$author.'</span></a></span>' : '<span class="uk-visible@m" '.$authorMicrodata.' '.$microdataPerson.'><span class="uk-margin-small-right" uk-icon="user" aria-hidden="true"></span><span class="uk-text-middle" '.$nameMicrodata.'>'.$author.'</span></span>');
			$author             = $authorUrl;

			$categoryUrl        = ($category_url) ? '<span class="uk-visible@m"><span class="uk-margin-small-right" uk-icon="folder" aria-hidden="true"></span><a href="'.$category_url.'" class="uk-text-middle"><span '.$genreMicrodata.'>'.$category.'</span></a></span>' : '<span class="uk-visible@m"><span class="uk-margin-small-right" uk-icon="folder" aria-hidden="true"></span><span class="uk-text-middle" '.$genreMicrodata.'>'.$category.'</span></span>';
			$category           = $categoryUrl;
			?>
			<p class="uk-article-meta"><?php echo $author ?><?php echo $category ?></p>
		<?php endif; ?>

		<?php echo $hook_beforearticle; ?>

		<?php if ($article) : ?>
			<div <?php echo $articleBodyMicrodata; ?>>
				<?php echo $article; ?>
			</div>
		<?php endif; ?>

		<?php if ($tags || $author || $date || $date_modified || $category || $associations || $edit) : ?>
		<div class="uk-container uk-container-expand uk-margin">
			<hr class="uk-divider-icon">
			<div class="uk-grid-small uk-child-width-auto uk-flex-middle" uk-grid="">

				<?php if ($author || $date || $date_modified || $category || $associations) : ?>
					<div>
						<p class="uk-article-meta">
							<?php
								$authorUrl          = ( $author_url ? '<span class="uk-visible@m" '.$authorMicrodata.' '.$microdataPerson.'><span class="uk-margin-small-right" uk-icon="user" aria-hidden="true"></span><a href="'.$author_url.'" '.$urlMicrodata.'><span '.$nameMicrodata.'>'.$author.'</span></a></span>' : '<span class="uk-visible@m" '.$authorMicrodata.' '.$microdataPerson.'><span class="uk-margin-small-right" uk-icon="user" aria-hidden="true"></span><span class="uk-text-middle" '.$nameMicrodata.'>'.$author.'</span></span>');
								$author             = ( $author && $info != '2' ) ? $authorUrl : '';

								$dateTimes          = ( $datetime ) ? '<span class="tm-article-date" uk-tooltip="title: '.Text::sprintf('COM_CONTENT_CREATED_DATE_ON', HTMLHelper::_('date', $datetime, Text::_('DATE_FORMAT_LC3'))).'"><span class="uk-margin-small-right" uk-icon="calendar" aria-hidden="true"></span><time class="uk-text-middle" datetime="'.$datetime.'" '.$datePublishedMicrodata.' content="'.$datetime.'">'.HTMLHelper::_('date', $date, Text::_('DATE_FORMAT_LC3')).'</time></span>' : HTMLHelper::_('date', $date, Text::_('DATE_FORMAT_LC3'));
								$date               = ( $date ) ? $dateTimes : '';

								$date_modified      = ( $date_modified ) ? ('<span class="tm-article-date-modified" uk-tooltip="title: '.Text::sprintf('COM_CONTENT_LAST_UPDATED', HTMLHelper::_('date', $date_modified, Text::_('DATE_FORMAT_LC3'))).'"><span class="uk-margin-small-right" uk-icon="calendar" aria-hidden="true"></span><time class="uk-text-middle" datetime="'.$date_modified.'" '.$dateModifiedMicrodata.' content="'.$date_modified.'">'.HTMLHelper::_('date', $date_modified, Text::_('DATE_FORMAT_LC3')).'</time></span>') : '';

								$categoryUrl        = ( $category_url ) ? '<span class="uk-visible@m"><span class="uk-margin-small-right" uk-icon="folder" aria-hidden="true"></span><a href="'.$category_url.'" class="uk-text-middle"><span '.$genreMicrodata.'>'.$category.'</span></a></span>' : '<span class="uk-visible@m"><span class="uk-margin-small-right" uk-icon="folder" aria-hidden="true"></span><span class="uk-text-middle" '.$genreMicrodata.'>'.$category.'</span></span>';
								$category           = ( $category && $info != '2' ) ? $categoryUrl : '';

								if ( $author )
								{
									echo $author;
								}
								if ( $date )
								{
									echo $date;
								}
								if ( $date_modified )
								{
									echo $date_modified;
								}
								if ( $category )
								{
									echo $category;
								}
								if ( $associations )
								{
									echo $associations;
								}
							?>
						</p>
					</div>
				<?php endif; ?>

				<?php if ($tags) : ?>
					<div class="uk-margin-auto-left">
						<span><?php echo $tags ?></span>
					</div>
				<?php endif; ?>

				<?php 
					$editClasses = ($tags) ? ' class="uk-margin-left"' : ' class="uk-margin-auto-left"';
					if ($edit) : ?>
					<div<?php echo $editClasses;?>>
						<span><?php echo $edit; ?></span>
					</div>
				<?php endif; ?>

			</div>
		</div>
		<?php endif; ?>

		<?php echo $hook_afterarticle; ?>
	</article>

	<?php if ($previous || $next) : 

		if ($previous) :
			if (30 <= \strlen($prev_title)) {
				$truncated_prev_title = substr($prev_title, 0, 30);
				$last_space = strrpos($truncated_prev_title, " ");
				$truncated_prev_title = substr($truncated_prev_title, 0, $last_space);
				$truncated_prev_title .= "...";
			} else {
				$truncated_prev_title = $prev_title;
			}
		endif;

		if ($next) :
			if (30 <= \strlen($next_title)) {
				$truncated_next_title = substr($next_title, 0, 30);
				$last_space = strrpos($truncated_next_title, " ");
				$truncated_next_title = substr($truncated_next_title, 0, $last_space);
				$truncated_next_title .= "...";
			} else {
				$truncated_next_title = $next_title;
			}
		endif;

	?>
	<div class="uk-container uk-container-expand uk-margin">
		<hr class="uk-divider-icon">
		<nav role="navigation" aria-label="<?php echo Text::_('JLIB_HTML_PAGINATION'); ?>">
			<ul class="uk-pagination uk-flex-center uk-text-large" uk-margin="">
				<?php if ($previous) : ?>
					<li class="uk-margin-auto-right">
						<a aria-label="<?php echo $prev_title; ?>" href="<?php echo $previous; ?>" uk-tooltip="title: <?php echo Text::_('JPREV').': '.$prev_title; ?>"><span class="uk-margin-small-right" uk-pagination-previous></span> <?php echo $truncated_prev_title; ?></a>
					</li>
				<?php endif; ?>

				<?php if ($next) : ?>
					<li class="uk-margin-auto-left">
						<a aria-label="<?php echo $next_title; ?>" href="<?php echo $next; ?>" uk-tooltip="title: <?php echo Text::_('JNEXT').': '.$next_title; ?>"><?php echo $truncated_next_title; ?> <span class="uk-margin-small-left" uk-pagination-next></span></a>
					</li>
				<?php endif; ?>
			</ul>
		</nav>
	</div>
	<?php endif; ?>

 <?php
}
?>
