<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	html
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;


use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Router\Route;

$app->getDocument()->getWebAssetManager()
	->useScript('core')
	->useScript('keepalive')
	/* ->useScript('field.passwordview') */; ?>

<form id="login-form-<?php echo $module->id; ?>" class="mod-login" action="<?php echo Route::_('index.php', true); ?>" method="post">

	<?php if ($params->get('pretext')) : ?>
		<div class="mod-login__pretext uk-margin-remove-top uk-text-center uk-text-left@m">
			<p><?php echo $params->get('pretext'); ?></p>
		</div>
	<?php endif; ?>

	<div class="mod-login__userdata userdata uk-child-width-1-1 uk-grid-small" uk-grid="">
		<div class="mod-login__username form-group uk-margin-small">
			<?php if (!$params->get('usetext', 0)) : ?>
				<div class="uk-inline uk-width-1-1">
					<span class="uk-form-icon" uk-icon="icon: user" aria-hidden="true"></span>
					<input id="modlgn-username-<?php echo $module->id; ?>" class="uk-input" type="text" name="username" autocomplete="username" placeholder="<?php echo JText::_('MOD_LOGIN_VALUE_USERNAME') ?>">
				</div>
			<?php else : ?>
				<label for="modlgn-username-<?php echo $module->id; ?>" class="uk-form-label"><?php echo Text::_('MOD_LOGIN_VALUE_USERNAME'); ?></label>
				<div class="uk-form-controls">
					<input id="modlgn-username-<?php echo $module->id; ?>" type="text" name="username" class="uk-input" autocomplete="username" placeholder="<?php echo Text::_('MOD_LOGIN_VALUE_USERNAME'); ?>">
				</div>
			<?php endif; ?>
		</div>

		<div class="mod-login__password uk-margin-small">
			<?php if (!$params->get('usetext', 0)) : ?>
				<div class="input-group">
					<div class="uk-inline uk-width-1-1">
						<span class="uk-form-icon" uk-icon="icon: lock"></span>
						<input id="modlgn-passwd-<?php echo $module->id; ?>" type="password" name="password" autocomplete="current-password" class="uk-input" placeholder="<?php echo Text::_('JGLOBAL_PASSWORD'); ?>">
					</div>
				</div>
			<?php else : ?>
				<label for="modlgn-passwd-<?php echo $module->id; ?>"><?php echo Text::_('JGLOBAL_PASSWORD'); ?></label>
				<div class="uk-form-controls">
					<input id="modlgn-passwd-<?php echo $module->id; ?>" type="password" name="password" autocomplete="current-password" class="uk-input" placeholder="<?php echo Text::_('JGLOBAL_PASSWORD'); ?>">
				</div>
			<?php endif; ?>
		</div>

		<?php if (count($twofactormethods) > 1) : ?>
			<div class="mod-login__twofactor uk-margin-small">
				<?php if (!$params->get('usetext', 0)) : ?>
					<div class="input-group">
						<div class="uk-inline uk-width-1-1">
							<span class="uk-form-icon" uk-icon="icon: star"></span>
							<input id="modlgn-secretkey-<?php echo $module->id; ?>" autocomplete="one-time-code" type="text" name="secretkey" class="form-control uk-input uk-form-width-large" placeholder="<?php echo Text::_('JGLOBAL_SECRETKEY'); ?>">
						</div>
					</div>
				<?php else : ?>
					<label for="modlgn-secretkey-<?php echo $module->id; ?>"><?php echo Text::_('JGLOBAL_SECRETKEY'); ?></label>
					<input id="modlgn-secretkey-<?php echo $module->id; ?>" autocomplete="one-time-code" type="text" name="secretkey" class="form-control" placeholder="<?php echo Text::_('JGLOBAL_SECRETKEY'); ?>">
					<span class="btn width-auto" title="<?php echo Text::_('JGLOBAL_SECRETKEY_HELP'); ?>">
						<span class="fas fa-question" aria-hidden="true"></span>
					</span>
				<?php endif; ?>
			</div>
		<?php endif; ?>

		<?php if (PluginHelper::isEnabled('system', 'remember')) : ?>
			<div class="uk-margin-small">
				<div id="form-login-remember-<?php echo $module->id; ?>">
					<label for="mod-login__remember<?php echo $module->id; ?>" class="uk-form-label">
						<?php echo Text::_('MOD_LOGIN_REMEMBER_ME'); ?>
					</label>
					<input id="mod-login__remember<?php echo $module->id; ?>" type="checkbox" name="remember" class="uk-checkbox" value="yes">
				</div>
			</div>
		<?php endif; ?>

		<?php foreach($extraButtons as $button):
			$dataAttributeKeys = array_filter(array_keys($button), function ($key) {
				return substr($key, 0, 5) == 'data-';
			});
			?>
			<div class="mod-login__submit uk-margin-small">
				<button type="button"
				        class="uk-width-1-1 uk-button uk-button-secondary <?php echo $button['class'] ?? '' ?>"
						<?php foreach ($dataAttributeKeys as $key): ?>
						<?php echo $key ?>="<?php echo $button[$key] ?>"
						<?php endforeach; ?>
						<?php if ($button['onclick']): ?>
						onclick="<?php echo $button['onclick'] ?>"
						<?php endif; ?>
				        title="<?php echo Text::_($button['label']) ?>"
				        id="<?php echo $button['id'] ?>"
						>
					<?php if (!empty($button['icon'])): ?>
						<span class="<?php echo $button['icon'] ?>"></span>
					<?php elseif (!empty($button['image'])): ?>
						<?php echo HTMLHelper::_('image', $button['image'], Text::_($button['tooltip'] ?? ''), [
							'class' => 'icon',
						], true) ?>
					<?php endif; ?>
					<?php echo Text::_($button['label']) ?>
				</button>
			</div>
		<?php endforeach; ?>

		<div class="mod-login__submit uk-margin-small">
			<button type="submit" name="Submit" class="uk-width-1-1 uk-button uk-button-primary"><?php echo Text::_('JLOGIN'); ?></button>
		</div>

		<?php
			$usersConfig = ComponentHelper::getParams('com_users'); ?>
			<ul class="mod-login__options uk-list uk-list-square">
				<li>
					<a class="uk-link-reset" href="<?php echo Route::_('index.php?option=com_users&view=reset'); ?>">
					<?php echo Text::_('MOD_LOGIN_FORGOT_YOUR_PASSWORD'); ?></a>
				</li>
				<li>
					<a class="uk-link-reset" href="<?php echo Route::_('index.php?option=com_users&view=remind'); ?>">
					<?php echo Text::_('MOD_LOGIN_FORGOT_YOUR_USERNAME'); ?></a>
				</li>
				<?php if ($usersConfig->get('allowUserRegistration')) : ?>
				<li>
					<a class="uk-link-reset" href="<?php echo Route::_($registerLink); ?>">
					<?php echo Text::_('MOD_LOGIN_REGISTER'); ?> <span class="fas fa-arrow-alt-circle-right"></span></a>
				</li>
				<?php endif; ?>
			</ul>
		<input type="hidden" name="option" value="com_users">
		<input type="hidden" name="task" value="user.login">
		<input type="hidden" name="return" value="<?php echo $return; ?>">
		<?php echo HTMLHelper::_('form.token'); ?>
	</div>
	<?php if ($params->get('posttext')) : ?>
		<div class="mod-login__posttext uk-text-center uk-text-left@m">
			<p><?php echo $params->get('posttext'); ?></p>
		</div>
	<?php endif; ?>
</form>
