<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	html
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;


function renderMessage($msgList) {

    // Build the return string
    $buffer = array();

    $buffer[] = '<div id="system-message-container">';

    // If messages exist render them
    if (is_array($msgList)) {

        foreach ($msgList as $type => $msgs) {

            // types: warning, error, notice, message

            $msgtype = $type;

            if($msgtype=='notice') $msgtype = "";
			if($msgtype=='warning') $msgtype = "uk-alert-warning";
			if($msgtype=='message') $msgtype = "uk-alert-success";
            if($msgtype=='error')   $msgtype = "uk-alert-danger";

            $buffer[] = '<div class="'.$msgtype.'" uk-alert>';

            // This requires JS so we should add it trough JS. Progressive enhancement and stuff.
            $buffer[] = '<a class="uk-alert-close" uk-close></a>';

            if (count($msgs)) {

                $buffer[] = '<h3>' . JText::_($type) . '</h3>';

                foreach ($msgs as $msg) {
                    $buffer[] = '<p>'.$msg.'</p>';
                }
            }

            $buffer[] = '</div>';
        }
    }

    $buffer[] = '</div>';

    return implode("\n", $buffer);
}
