<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	html
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;


use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

extract($displayData);

/**
 * Layout variables
 * -----------------
 * @var  string  $id     DOM id of the field.
 * @var  string  $label  Label of the field.
 * @var  string  $name   Name of the input field.
 * @var  string  $value  Value attribute of the field.
 */

Text::script('ERROR');
Text::script('MESSAGE');
Text::script('PLG_USER_TOKEN_COPY_SUCCESS');
Text::script('PLG_USER_TOKEN_COPY_FAIL');

Factory::getApplication()->getDocument()->getWebAssetManager()
	->registerAndUseScript('plg_user_token.token', 'plg_user_token/token.js', [], ['defer' => true], ['core']); ?>

<div class="uk-button-group">
	<input
		type="text"
		class="form-control uk-input uk-form-width-large"
		name="<?php echo $name; ?>"
		id="<?php echo $id; ?>"
		readonly
		value="<?php echo htmlspecialchars($value, ENT_COMPAT, 'UTF-8'); ?>">
	<div class="input-group-append">
		<button
			class="uk-button uk-button-primary"
			type="button"
			id="token-copy"
			title="<?php echo Text::_('PLG_USER_TOKEN_COPY_DESC'); ?>"><?php echo Text::_('PLG_USER_TOKEN_COPY'); ?></button>
	</div>
</div>
