<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	html
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;


use Joomla\CMS\Factory;

extract($displayData);

/**
 * Layout variables
 * -----------------
 * @var   array   $options      Optional parameters
 * @var   string  $name         The id of the input this label is for
 * @var   string  $label        The html code for the label
 * @var   string  $input        The input field html code
 * @var   string  $description  An optional description to use in a tooltip
 */

if (!empty($options['showonEnabled']))
{
	/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
	$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
	$wa->useScript('showon');
}

$class           = empty($options['class']) ? '' : ' ' . $options['class'];
$rel             = empty($options['rel']) ? '' : ' ' . $options['rel'];
$id              = $name . '-desc';

$hideDescription = empty($options['hiddenDescription']) ? false : $options['hiddenDescription']; ?>

<div class="uk-margin<?php echo $class; ?>"<?php echo $rel; ?>>
	<?php echo $label; ?>
	<div class="uk-form-controls">
		<?php echo $input; ?>

		<?php if (!$hideDescription && !empty($description)) : ?>
			<div id="<?php echo $id; ?>">
				<small class="form-text text-muted">
					<?php echo $description; ?>
				</small>
			</div>
		<?php endif; ?>
	</div>
</div>
