<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	html
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;


use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

HTMLHelper::_('behavior.keepalive');
HTMLHelper::_('behavior.formvalidator');

?>
<div class="com-users-reset-complete reset-complete">
	<?php if ($this->params->get('show_page_heading')) : ?>
		<div class="page-header">
			<h1>
				<?php echo $this->escape($this->params->get('page_heading')); ?>
			</h1>
		</div>
	<?php endif; ?>
	<form action="<?php echo Route::_('index.php?option=com_users&task=reset.complete'); ?>" method="post" class="com-users-reset-complete__form form-validate form-horizontal well">
		<?php foreach ($this->form->getFieldsets() as $fieldset) : ?>
			<fieldset class="uk-fieldset">
				<?php if (isset($fieldset->label)) : ?>
					<p><?php echo Text::_($fieldset->label); ?></p>
				<?php endif; ?>
				<?php echo $this->form->renderFieldset($fieldset->name); ?>
			</fieldset>
		<?php endforeach; ?>
		<div class="com-users-reset-complete__submit control-group">
			<div class="controls">
				<button type="submit" class="uk-button uk-button-primary validate">
					<?php echo Text::_('JSUBMIT'); ?>
				</button>
			</div>
		</div>
		<?php echo HTMLHelper::_('form.token'); ?>
	</form>
</div>
