<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	html
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text; ?>

<?php $fields = $this->form->getFieldset('params'); ?>
<?php if (count($fields)) : ?>
	<fieldset id="users-profile-custom" class="com-users-profile__params uk-fieldset">
		<legend class="uk-legend"><?php echo Text::_('COM_USERS_SETTINGS_FIELDSET_LABEL'); ?></legend>
		<dl class="uk-description-list uk-description-list-divider">
			<?php foreach ($fields as $field) : ?>
				<?php if (!$field->hidden) : ?>
					<dt>
						<?php echo $field->title; ?>
					</dt>
					<dd>
						<?php if (HTMLHelper::isRegistered('users.' . $field->id)) : ?>
							<?php echo HTMLHelper::_('users.' . $field->id, $field->value); ?>
						<?php elseif (HTMLHelper::isRegistered('users.' . $field->fieldname)) : ?>
							<?php echo HTMLHelper::_('users.' . $field->fieldname, $field->value); ?>
						<?php elseif (HTMLHelper::isRegistered('users.' . $field->type)) : ?>
							<?php echo HTMLHelper::_('users.' . $field->type, $field->value); ?>
						<?php else : ?>
							<?php echo HTMLHelper::_('users.value', $field->value); ?>
						<?php endif; ?>
					</dd>
				<?php endif; ?>
			<?php endforeach; ?>
		</dl>
	</fieldset>
<?php endif; ?>
