<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	html
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;


use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route; ?>

<div class="com-users-profile profile">
	<?php if ($this->params->get('show_page_heading')) : ?>
		<div class="page-header">
			<h1>
				<?php echo $this->escape($this->params->get('page_heading')); ?>
			</h1>
		</div>
	<?php endif; ?>

	<?php if (Factory::getUser()->id == $this->data->id) : ?>
		<ul class="com-users-profile__edit uk-text-right uk-list">
			<li>
				<a class="uk-button uk-button-default" href="<?php echo Route::_('index.php?option=com_users&task=profile.edit&user_id=' . (int) $this->data->id); ?>">
					<span class="fa fa-user"></span> <?php echo Text::_('COM_USERS_EDIT_PROFILE'); ?>
				</a>
			</li>
		</ul>
	<?php endif; ?>

	<div class="uk-grid-row-small" uk-grid>
		<div class="uk-width-1-2@m">
			<div class="uk-tile uk-tile-small"><?php echo $this->loadTemplate('core'); ?></div>
		</div>
		<div class="uk-width-1-2@m">
			<div class="uk-tile uk-tile-small"><?php echo $this->loadTemplate('params'); ?></div>
		</div>
		<div uk-grid>
			<div class="uk-width-1-1">
				<div class="uk-tile uk-tile-small"><?php echo $this->loadTemplate('custom'); ?></div>
			</div>
		</div>
	</div>

</div>
