<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	html
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;


use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = $this->document->getWebAssetManager();
$wa->useScript('com_tags.tag-list');

require_once (JPATH_THEMES .'/uithemebuilder/html/helpers/sortGrid.php');

$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn  = $this->escape($this->state->get('list.direction'));
?>
<div class="com-tags-compact__items">
	<form action="<?php echo htmlspecialchars(Uri::getInstance()->toString()); ?>" method="post" name="adminForm" id="adminForm" class="com-tags-tag-list__items">

		<?php if ($this->params->get('filter_field') || $this->params->get('show_pagination_limit')) : ?>
			<div class="uk-margin-large-bottom uk-clearfix">
				<?php if ($this->params->get('show_pagination_limit')) : ?>
					<div class="uk-float-right uk-flex uk-flex-middle">
						<div uk-form-custom="target: > * > span:first-child">
							<?php echo $this->pagination->getLimitBox(); ?>
							<button class="uk-button uk-button-default" type="button" tabindex="-1">
								<span></span>
								<span uk-icon="icon: chevron-down"></span>
							</button>
						</div>
					</div>
				<?php endif; ?>
				
				<?php if ($this->params->get('filter_field')) : ?>
					<div class="com-tags-tag__filter uk-float-left">
						<input
							type="text"
							name="filter-search"
							id="filter-search"
							value="<?php echo $this->escape($this->state->get('list.filter')); ?>"
							class="uk-input uk-form-width-medium" onchange="document.adminForm.submit();"
							placeholder="<?php echo Text::_('COM_TAGS_TITLE_FILTER_LABEL'); ?>"
						>
						<span class="uk-button-group">
							<button type="submit" name="filter_submit" class="uk-button uk-button-primary"><?php echo Text::_('JGLOBAL_FILTER_BUTTON'); ?></button>
							<button type="reset" name="filter-clear-button" class="uk-button uk-button-secondary"><?php echo Text::_('JSEARCH_FILTER_CLEAR'); ?></button>
						</span>
					</div>
				<?php endif; ?>
			</div>
		<?php endif; ?>

		<?php if (empty($this->items)) : ?>
			<div class="uk-alert-warning" uk-alert>
				<a class="uk-alert-close" uk-close></a>
				<h3><?php echo Text::_('INFO'); ?></h3>
				<p><?php echo Text::_('COM_TAGS_NO_ITEMS'); ?></p>
			</div>
		<?php else : ?>
			<table class="com-tags-tag-list__category category uk-table uk-table-striped uk-table-hover">
				<?php if ($this->params->get('show_headings')) : ?>
					<thead>
						<tr>
							<th scope="col" id="categorylist_header_title uk-width-expand">
								<?php // echo HTMLHelper::_('grid.sort', 'JGLOBAL_TITLE', 'c.core_title', $listDirn, $listOrder); ?>
								<?php echo '<span>' . sortGrid::sort('JGLOBAL_TITLE', 'a.core_title', $listDirn, $listOrder, null, 'asc', '', 'adminForm') . '</span>'; ?>
							</th>
							<?php if ($date = $this->params->get('tag_list_show_date')) : ?>
								<th scope="col" id="categorylist_header_date uk-width-auto">
									<?php if ($date === 'created') : ?>
										<?php // echo HTMLHelper::_('grid.sort', 'COM_TAGS_' . $date . '_DATE', 'c.core_created_time', $listDirn, $listOrder); ?>
										<?php echo '<span>' . sortGrid::sort('COM_TAGS_' . $date . '_DATE', 'c.core_created_time', $listDirn, $listOrder, null, 'asc', '', 'adminForm') . '</span>'; ?>
									<?php elseif ($date === 'modified') : ?>
										<?php // echo HTMLHelper::_('grid.sort', 'COM_TAGS_' . $date . '_DATE', 'c.core_modified_time', $listDirn, $listOrder); ?>
										<?php echo '<span>' . sortGrid::sort('COM_TAGS_' . $date . '_DATE', 'c.core_modified_time', $listDirn, $listOrder, null, 'asc', '', 'adminForm') . '</span>'; ?>
									<?php elseif ($date === 'published') : ?>
										<?php // echo HTMLHelper::_('grid.sort', 'COM_TAGS_' . $date . '_DATE', 'c.core_publish_up', $listDirn, $listOrder); ?>
										<?php echo '<span>' . sortGrid::sort('COM_TAGS_' . $date . '_DATE', 'c.core_publish_up', $listDirn, $listOrder, null, 'asc', '', 'adminForm') . '</span>'; ?>
									<?php endif; ?>
								</th>
							<?php endif; ?>
						</tr>
					</thead>
				<?php endif; ?>
				<tbody>
					<?php foreach ($this->items as $i => $item) : ?>
						<?php if ($item->core_state == 0) : ?>
							<tr class="system-unpublished cat-list-row<?php echo $i % 2; ?>">
						<?php else : ?>
							<tr class="cat-list-row<?php echo $i % 2; ?> " >
						<?php endif; ?>
							<th scope="row" class="list-title uk-width-expand">
								<?php if (($item->type_alias === 'com_users.category') || ($item->type_alias === 'com_banners.category')) : ?>
									<?php echo $this->escape($item->core_title); ?>
								<?php else : ?>
									<a class="uk-link-reset" href="<?php echo Route::_($item->link); ?>">
										<?php echo $this->escape($item->core_title); ?>
									</a>
								<?php endif; ?>
								<?php if ($item->core_state == 0) : ?>
									<span class="list-published badge badge-warning">
										<?php echo Text::_('JUNPUBLISHED'); ?>
									</span>
								<?php endif; ?>
							</th>
							<?php if ($this->params->get('tag_list_show_date')) : ?>
								<td class="list-date uk-width-auto">
									<?php
									echo HTMLHelper::_(
										'date', $item->displayDate,
										$this->escape($this->params->get('date_format', Text::_('DATE_FORMAT_LC3')))
									); ?>
								</td>
							<?php endif; ?>
							</tr>
					<?php endforeach; ?>
				</tbody>
			</table>
		<?php endif; ?>

		<?php // Add pagination links ?>
		<?php if (($this->params->def('show_pagination', 2) == 1 || ($this->params->get('show_pagination') == 2)) && ($this->pagination->pagesTotal > 1)) : ?>
			<div class="com-tags-tag-list__pagination w-100 uk-grid-small" uk-grid="">
				<?php if ($this->params->def('show_pagination_results', 1)) : ?>
					<div class="uk-width-1-1">
						<p class="counter float-right pt-3 pr-2">
							<?php echo $this->pagination->getPagesCounter(); ?>
						</p>
					</div>
				<?php endif; ?>
				<div class="uk-width-1-1 uk-flex uk-flex-center">
					<?php echo $this->pagination->getPagesLinks(); ?>
				</div>
			</div>
		<?php endif; ?>

		<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>">
		<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>">
		<input type="hidden" name="limitstart" value="">
		<input type="hidden" name="task" value="">
	</form>
</div>
