<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	html/com_search
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;


$lang = JFactory::getLanguage();
$upper_limit = $lang->getUpperLimitSearchWord(); ?>
<div class="uk-clearfix uk-margin">
	<form id="searchForm" class="uk-float-right uk-search uk-search-default" action="<?php echo JRoute::_('index.php?option=com_search'); ?>" method="post">
				<button name="Search" onclick="this.form.submit()" class="uk-search-icon-flip" uk-search-icon></button>
				<input type="search" name="searchword" title="<?php echo JText::_('COM_SEARCH_SEARCH_KEYWORD'); ?>" placeholder="<?php echo JText::_('COM_SEARCH_SEARCH_KEYWORD'); ?>" id="search-searchword" size="30" maxlength="<?php echo $upper_limit; ?>" value="<?php echo $this->escape($this->origkeyword); ?>" class="uk-search-input" />
			<input type="hidden" name="task" value="search" />
	</form>

	<div class="uk-float-left searchintro<?php echo $this->params->get('pageclass_sfx'); ?>">
		<?php if (!empty($this->searchword)) : ?>
			<p>
				<?php echo JText::plural('COM_SEARCH_SEARCH_KEYWORD_N_RESULTS', '<span class="badge badge-info">' . $this->total . '</span>'); ?>
			</p>
		<?php endif; ?>
	</div>
</div>

	<?php if ($this->params->get('search_phrases', 1)) : ?>
		<fieldset class="uk-fieldset uk-margin">
			<legend class="uk-legend">
				<?php echo JText::_('COM_SEARCH_FOR'); ?>
			</legend>
			<div class="phrases-box uk-margin">
				<?php echo $this->lists['searchphrase']; ?>
			</div>
			<div class="ordering-box uk-margin">
				<div uk-form-custom="target: > * > span:first-child">
					<?php echo $this->lists['ordering']; ?>
					<button class="uk-button uk-button-default uk-button-small" type="button" tabindex="-1">
						<span><?php echo JText::_('COM_SEARCH_ORDERING'); ?></span>
						<span uk-icon="icon: chevron-down"></span>
					</button>
				</div>
			</div>
		</fieldset>
	<?php endif; ?>
	<?php if ($this->params->get('search_areas', 1)) : ?>
		<fieldset class="uk-fieldset uk-margin">
			<legend class="uk-legend">
				<?php echo JText::_('COM_SEARCH_SEARCH_ONLY'); ?>
			</legend>
			<div class="uk-margin uk-grid-small uk-child-width-auto" uk-grid="">
				<?php foreach ($this->searchareas['search'] as $val => $txt) : ?>
					<?php $checked = is_array($this->searchareas['active']) && in_array($val, $this->searchareas['active']) ? 'checked="checked"' : ''; ?>
					<label for="area-<?php echo $val; ?>">
						<input class="uk-checkbox" type="checkbox" name="areas[]" value="<?php echo $val; ?>" id="area-<?php echo $val; ?>" <?php echo $checked; ?> />
						<?php echo JText::_($txt); ?>
					</label>
				<?php endforeach; ?>
			</div>
		</fieldset>
	<?php endif; ?>
	<?php if ($this->total > 0) : ?>
		<div class="uk-clearfix uk-margin">
			<div class="uk-float-right">
				<div uk-form-custom="target: > * > span:first-child">
					<?php echo $this->pagination->getLimitBox(); ?>
					<button class="uk-button uk-button-default" type="button" tabindex="-1">
						<span><?php echo JText::_('JGLOBAL_DISPLAY_NUM'); ?></span>
						<span uk-icon="icon: chevron-down"></span>
					</button>
				</div>
			</div>
			<div class="uk-float-left">
				<p class="counter">
					<?php echo $this->pagination->getPagesCounter(); ?>
				</p>
			</div>
		</div>
	<?php endif; ?>

