<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	html
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;


use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;

$app = Factory::getApplication();

$app->input->set('layout', 'blog');

if (($this->params->def('show_pagination', 1) == 1 || ($this->params->get('show_pagination') == 2)) && ($this->pagination->pagesTotal > 1)) :
$doc = Factory::getDocument();
$doc->setTitle( $doc->getTitle() . ' blog.php' . Text::sprintf('JLIB_HTML_PAGE_CURRENT_OF_TOTAL', $this->pagination->pagesCurrent, $this->pagination->pagesTotal) );
$doc->setDescription($doc->getMetaData('description') . ' blog.php' . Text::sprintf('JLIB_HTML_PAGE_CURRENT_OF_TOTAL', $this->pagination->pagesCurrent, $this->pagination->pagesTotal) );
endif;

$template = Factory::getApplication()->getTemplate();
JHtml::addIncludePath(JPATH_THEMES . '/' .$template. '/html/helpers');

$this->category->text = $this->category->description;
$app->triggerEvent('onContentPrepare', array($this->category->extension . '.categories', &$this->category, &$this->params, 0));
$this->category->description = $this->category->text;

$results = $app->triggerEvent('onContentAfterTitle', array($this->category->extension . '.categories', &$this->category, &$this->params, 0));
$afterDisplayTitle = trim(implode("\n", $results));

$results = $app->triggerEvent('onContentBeforeDisplay', array($this->category->extension . '.categories', &$this->category, &$this->params, 0));
$beforeDisplayContent = trim(implode("\n", $results));

$results = $app->triggerEvent('onContentAfterDisplay', array($this->category->extension . '.categories', &$this->category, &$this->params, 0));
$afterDisplayContent = trim(implode("\n", $results)); 

$masonry_grid		= '';
$masonry_grid_width = ''; ?>

<div class="uk-grid-row-large" uk-grid="">
	<div class="com-content-category-blog blog uk-width-1-1" itemscope itemtype="https://schema.org/Blog">

		<?php if ($this->params->get('show_page_heading')) : ?>
			<div uk-grid="">
				<div class="uk-width-1-1">
					<h1 class="uk-heading-medium uk-heading-bullet"><?php echo $this->escape($this->params->get('page_heading')); ?></h1>
				</div>
			</div>
		<?php endif; ?>

		<?php if ($this->params->get('show_category_title', 1) or $this->params->get('page_subheading')) : ?>
			<h2 class="uk-h2"><?php echo $this->escape($this->params->get('page_subheading')); ?>
				<?php if ($this->params->get('show_category_title')) : ?>
					<span class="subheading-category"><?php echo $this->category->title; ?></span>
				<?php endif; ?>
			</h2>
		<?php endif; ?>


		<?php echo $afterDisplayTitle; ?>

		<?php if ($this->params->get('show_cat_tags', 1) && !empty($this->category->tags->itemTags)) : ?>
			<?php $this->category->tagLayout = new FileLayout('joomla.content.tags'); ?>
			<?php echo $this->category->tagLayout->render($this->category->tags->itemTags); ?>
		<?php endif; ?>


		<?php if ($beforeDisplayContent || $afterDisplayContent || $this->params->get('show_description', 1) || $this->params->def('show_description_image', 1)) : ?>
			<div class="category-desc clearfix">
				<?php if ($this->params->get('show_description_image') && $this->category->getParams()->get('image')) : ?>
					<img src="<?php echo $this->category->getParams()->get('image'); ?>" alt="<?php echo htmlspecialchars($this->category->getParams()->get('image_alt'), ENT_COMPAT, 'UTF-8'); ?>">
				<?php endif; ?>
				<?php echo $beforeDisplayContent; ?>
				<?php if ($this->params->get('show_description') && $this->category->description) : ?>
					<?php echo HTMLHelper::_('content.prepare', $this->category->description, '', 'com_content.category'); ?>
				<?php endif; ?>
				<?php echo $afterDisplayContent; ?>
			</div>
		<?php endif; ?>

		<?php if (empty($this->lead_items) && empty($this->link_items) && empty($this->intro_items)) : ?>
			<?php if ($this->params->get('show_no_articles', 1)) : ?>
				<div class="uk-alert"><p><?php echo Text::_('COM_CONTENT_NO_ARTICLES'); ?></p></div>
			<?php endif; ?>
		<?php endif; ?>


		<?php $leadingcount = 0; ?>
		<?php if (!empty($this->lead_items)) : ?>
			<?php $blogLeadItemClass = $this->params->get('blog_class_leading') ? $this->params->get('blog_class_leading') : ''; ?>
			<div class="com-content-category-blog__items blog-items items-leading" uk-grid="">
				<?php foreach ($this->lead_items as &$item) : ?>
					<div class="com-content-category-blog__item blog-item uk-width-1-1" itemprop="blogPost" itemscope itemtype="https://schema.org/BlogPosting">
						<?php if ($blogLeadItemClass) : ?>
						  <div class="<?php echo $blogLeadItemClass; ?>">
						<?php endif; ?>
							<?php
							  $this->item = & $item;
							  echo $this->loadTemplate('item');
							?>
						<?php if ($blogLeadItemClass) : ?>
						  </div>
						<?php endif; ?>
					</div>
					<?php $leadingcount++; ?>
				<?php endforeach; ?>
			</div>
		<?php endif; ?>

		<?php $introcount = 0; ?>
		<?php if (!empty($this->intro_items)) : ?>
			<?php	$blogItemClass = $this->params->get('blog_class') ? $this->params->get('blog_class') : ''; 
					$multi_column_order = (int) $this->params->get('multi_column_order', 0);
					$num_columns = (int) $this->params->get('num_columns');
			?>
			<?php $blog_item_width = (int) $this->params->get('multi_column_order', 0) === 0 ? '' : ' uk-width-1-1'; ?>
			<?php if ($num_columns > 1) : ?>
				<?php 
					if ($num_columns <= 4) {
						$columns = (int) $this->params->get('num_columns');
					} else {
						$columns = 4;
					}
				?>

				<?php $masonry_grid = $multi_column_order === 0 ? 'masonry: true' : ''; ?>
				<?php $masonry_grid_width = $multi_column_order === 0 ? ' uk-child-width-1-1@s uk-child-width-1-2@m uk-child-width-1-'.$columns.'@l' : ''; ?>

			<?php endif; ?>

			<div class="com-content-category-blog__items blog-items<?php echo $masonry_grid_width; ?>" uk-grid="<?php echo $masonry_grid; ?>">
			<?php foreach ($this->intro_items as $key => &$item) : ?>
				<div class="com-content-category-blog__item blog-item<?php echo $blog_item_width; ?>" itemprop="blogPost" itemscope itemtype="https://schema.org/BlogPosting">
					<?php if ($blogItemClass) : ?>
					  <div class="<?php echo $blogItemClass; ?>">
					<?php endif; ?>
						<?php
						  $this->item = & $item;
						  echo $this->loadTemplate('item');
						?>
					<?php if ($blogItemClass) : ?>
					  </div>
					<?php endif; ?>
				</div>
				<?php $introcount++; ?>
			<?php endforeach; ?>
			</div>
		<?php endif; ?>
	</div>

	<?php if ( !empty($this->link_items) && ($this->maxLevel != 0 && !empty($this->children[$this->category->id])) ) { ?>
		<div class="uk-width-1-1">
			<div class="uk-grid-small" uk-grid="">
				<div class="uk-width-1-2">
					<div class="uk-tile uk-tile-xsmall">
						<hr class="uk-divider-small uk-margin-small-bottom">
						<h3 class="uk-margin-remove-top"><?php echo Text::_('COM_CONTENT_MORE_ARTICLES'); ?></h3>
						<?php echo $this->loadTemplate('links'); ?>
					</div>
				</div>

				<div class="uk-width-1-2">
					<div class="uk-tile uk-tile-xsmall">
						<?php if ($this->params->get('show_category_heading_title_text', 1) == 1) : ?>
							<hr class="uk-divider-small uk-margin-small-bottom">
							<h3 class="uk-margin-remove-top"> <?php echo Text::_('JGLOBAL_SUBCATEGORIES'); ?> </h3>
						<?php endif; ?>
						<?php echo $this->loadTemplate('children'); ?>
					</div>
				</div>
			</div>
		</div>

	<?php } else { ?>

		<?php if ( !empty($this->link_items) ) : ?>
			<div class="uk-width-1-1">
				<div uk-grid="">
					<div class="uk-width-auto">
						<div class="uk-tile uk-tile-xsmall">
							<hr class="uk-divider-small uk-margin-small-bottom">
							<h3 class="uk-margin-remove-top"><?php echo Text::_('COM_CONTENT_MORE_ARTICLES'); ?></h3>
							<?php echo $this->loadTemplate('links'); ?>
						</div>
					</div>
				</div>
			</div>
		<?php endif; ?>

		<?php if ($this->maxLevel != 0 && !empty($this->children[$this->category->id])) : ?>
			<div class="uk-width-1-1">
				<div uk-grid="">
					<div class="uk-width-auto">
						<div class="uk-tile uk-tile-xsmall">
							<?php if ($this->params->get('show_category_heading_title_text', 1) == 1) : ?>
								<hr class="uk-divider-small uk-margin-small-bottom">
								<h3 class="uk-margin-remove-top"> <?php echo Text::_('JGLOBAL_SUBCATEGORIES'); ?> </h3>
							<?php endif; ?>
							<?php echo $this->loadTemplate('children'); ?>
						</div>
					</div>
				</div>
			</div>
		<?php endif; ?>
	<?php } ?>


	<?php if (($this->params->def('show_pagination', 1) == 1 || ($this->params->get('show_pagination') == 2)) && ($this->pagination->pagesTotal > 1)) : ?>
		<div class="uk-width-1-1">
			<div uk-grid="">
				<div class="uk-width-1-1">
					<div class="uk-tile uk-tile-xsmall">
						<?php echo $this->pagination->getPagesLinks(); ?>
					</div>
				</div>
			</div>
		</div>
	<?php endif; ?>

</div>
