<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	html
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;


use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

HTMLHelper::_('behavior.keepalive');
HTMLHelper::_('behavior.formvalidator'); ?>

<div class="com-contact__form contact-form">
	<form id="contact-form" action="<?php echo Route::_('index.php'); ?>" method="post" class="form-validate uk-form-horizontal">
		<?php foreach ($this->form->getFieldsets() as $fieldset) : ?>
			<div class="uk-margin">
				<?php if ($fieldset->name === 'captcha' && !$this->captchaEnabled) : ?>
					<?php continue; ?>
				<?php endif; ?>
				<?php $fields = $this->form->getFieldset($fieldset->name); ?>
				<?php if (count($fields)) : ?>
					<fieldset class="uk-fieldset">
						<?php if (isset($fieldset->label) && ($legend = trim(Text::_($fieldset->label))) !== '') : ?>
							<legend class="uk-legend"><?php echo $legend; ?></legend>
						<?php endif; ?>
						<?php foreach ($fields as $field) : ?>
							<div class="uk-margin"><?php echo $field->renderField(); ?></div>
						<?php endforeach; ?>
					</fieldset>
				<?php endif; ?>
			</div>
		<?php endforeach; ?>
		<div class="control-group">
			<div class="uk-form-controls">
				<button class="uk-button uk-button-primary validate" type="submit"><?php echo Text::_('COM_CONTACT_CONTACT_SEND'); ?></button>
				<input type="hidden" name="option" value="com_contact">
				<input type="hidden" name="task" value="contact.submit">
				<input type="hidden" name="return" value="<?php echo $this->return_page; ?>">
				<input type="hidden" name="id" value="<?php echo $this->item->slug; ?>">
				<?php echo HTMLHelper::_('form.token'); ?>
			</div>
		</div>
	</form>
</div>
