<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	html
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;


use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Contact\Administrator\Helper\ContactHelper;
use Joomla\Component\Contact\Site\Helper\RouteHelper;

require_once (JPATH_THEMES .'/uithemebuilder/html/helpers/sortGrid.php');

/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = $this->document->getWebAssetManager();
$wa->useScript('com_contact.contacts-list')
	->useScript('core');

$canDo   = ContactHelper::getActions('com_contact', 'category', $this->category->id);
$canEdit = $canDo->get('core.edit');
$userId  = Factory::getApplication()->getIdentity()->id;

$listOrder  = $this->escape($this->state->get('list.ordering'));
$listDirn   = $this->escape($this->state->get('list.direction'));
?>

<div class="com-contact-category__items">
	<form action="<?php echo htmlspecialchars(Uri::getInstance()->toString()); ?>" method="post" name="adminForm" id="adminForm">
		<?php if ($this->params->get('filter_field') || $this->params->get('show_pagination_limit')) : ?>
			<div class="uk-margin-large-bottom uk-clearfix">
				<?php if ($this->params->get('filter_field')) : ?>
					<div class="com-contact-category__filter uk-float-left">
						<input
							type="text"
							name="filter-search"
							id="filter-search"
							value="<?php echo $this->escape($this->state->get('list.filter')); ?>"
							class="uk-input uk-form-width-medium" onchange="document.adminForm.submit();"
							placeholder="<?php echo Text::_('COM_CONTACT_FILTER_SEARCH_DESC'); ?>"
						>
						<span class="uk-button-group">
							<button type="submit" name="filter_submit" class="uk-button uk-button-primary"><?php echo Text::_('JGLOBAL_FILTER_BUTTON'); ?></button>
							<button type="reset" name="filter-clear-button" class="uk-button uk-button-secondary"><?php echo Text::_('JSEARCH_FILTER_CLEAR'); ?></button>
						</span>
					</div>
				<?php endif; ?>

				<?php if ($this->params->get('show_pagination_limit')) : ?>
					<div class="com-contact-category__pagination uk-float-right uk-flex uk-flex-middle">
						<label for="limit" class="uk-form-label">
							<?php echo Text::_('JGLOBAL_DISPLAY_NUM'); ?>
						</label>
						<div uk-form-custom="target: > * > span:first-child">
							<?php echo $this->pagination->getLimitBox(); ?>
							<button class="uk-button uk-button-default" type="button" tabindex="-1">
								<span></span>
								<span uk-icon="icon: chevron-down"></span>
							</button>
						</div>
					</div>
				<?php endif; ?>
			</div>
		<?php endif; ?>

		<?php if (empty($this->items)) : ?>
			<div class="uk-alert-info" uk-alert>
				<h3><span class="fa fa-info-circle uk-margin-small-right" aria-hidden="true"></span><?php echo Text::_('INFO'); ?></h3>
					<?php echo '<p>'.Text::_('COM_CONTACT_NO_CONTACTS').'</p>'; ?>
			</div>
		<?php else : ?>
			<div class="uk-overflow-auto">
				<table class="com-content-category__table category uk-table uk-table-middle uk-table-striped uk-table-hover uk-table-responsive" id="contactList">
					<caption id="captionTable" class="sr-only">
						<?php echo Text::_('COM_CONTACT_TABLE_CAPTION'); ?>,
					</caption>
					<?php if ($this->params->get('show_headings')) : ?>
						<thead>
							<tr>
								<th scope="col" id="categorylist_header_title" class="uk-width-auto uk-text-nowrap">
									<?php // echo HTMLHelper::_('grid.sort', 'JGLOBAL_TITLE', 'a.name', $listDirn, $listOrder, null, 'asc', '', 'adminForm'); ?>
									<?php echo '<span class="uk-text-lighter">' . sortGrid::sort('JGLOBAL_TITLE', 'a.name', $listDirn, $listOrder, null, 'asc', '', 'adminForm') . '</span>'; ?>
								</th>
								<th scope="col" class="uk-table-shrink">
								</th>
								<th scope="col" class="uk-width-expand">
									<?php echo '<span class="uk-text-light">' . Text::_('COM_CONTACT_CONTACT_DETAILS') . '</span>'; ?>
								</th>
								<?php if ($canEdit || ($canDo->get('core.edit.own') && $item->created_by === $userId)) : ?>
									<th scope="col" class="uk-table-shrink uk-text-nowrap">
										<?php echo Text::_('COM_CONTACT_EDIT_CONTACT'); ?>
									</th>
								<?php endif; ?>
							</tr>
						</thead>
					<?php endif; ?>
					<tbody>
						<?php foreach ($this->items as $i => $item) : ?>
							<?php if ($this->items[$i]->published == 0) : ?>
								<tr class="system-unpublished cat-list-row<?php echo $i % 2; ?>">
							<?php else : ?>
								<tr class="cat-list-row<?php echo $i % 2; ?>" >
							<?php endif; ?>
							<td scope="row" class="list-title uk-table-link uk-text-nowrap">
								<a class="uk-link-reset uk-text-bold" href="<?php echo Route::_(RouteHelper::getContactRoute($item->slug, $item->catid, $item->language)); ?>">
									<?php echo $this->escape($item->name); ?>
								</a>
								<?php if ($item->published == 0) : ?>
									<div>
										<span class="list-published badge badge-warning">
											<?php echo Text::_('JUNPUBLISHED'); ?>
										</span>
									</div>
								<?php endif; ?>
								<?php if (strtotime($item->publish_up) > strtotime(Factory::getDate())) : ?>
									<div>
										<span class="list-published badge badge-warning">
											<?php echo Text::_('JNOTPUBLISHEDYET'); ?>
										</span>
									</div>
								<?php endif; ?>
								<?php if (!is_null($item->publish_down) && strtotime($item->publish_down) < strtotime(Factory::getDate())) : ?>
									<div>
										<span class="list-published badge badge-warning">
											<?php echo Text::_('JEXPIRED'); ?>
										</span>
									</div
								<?php endif; ?>
								<?php if ($item->published == -2) : ?>
									<div>
										<span class="badge badge-warning">
											<?php echo Text::_('JTRASHED'); ?>
										</span>
									</div>
								<?php endif; ?>

								<?php echo $item->event->afterDisplayTitle; ?>
							</td>
							<td scope="row">
								<?php if ($this->params->get('show_image_heading')) : ?>
									<?php if ($item->image) : ?>
										<?php echo HTMLHelper::_('image', $item->image, '', array('class' => 'uk-preserve-width uk-border-circle', 'width' => '40', 'uk-img' => '' )); ?>
									<?php endif; ?>
								<?php endif; ?>
							</td>
							<td>
								<?php echo $item->event->beforeDisplayContent; ?>

								<ul class="uk-grid-small uk-child-width-auto" uk-grid>
									<?php if ($this->params->get('show_telephone_headings') && !empty($item->telephone)) : ?>
										<li><?php echo Text::sprintf('COM_CONTACT_TELEPHONE_NUMBER', $item->telephone); ?></li>
									<?php endif; ?>

									<?php if ($this->params->get('show_mobile_headings') && !empty ($item->mobile)) : ?>
										<li><?php echo Text::sprintf('COM_CONTACT_MOBILE_NUMBER', $item->mobile); ?></li>
									<?php endif; ?>

									<?php if ($this->params->get('show_fax_headings') && !empty($item->fax) ) : ?>
										<li><?php echo Text::sprintf('COM_CONTACT_FAX_NUMBER', $item->fax); ?></li>
									<?php endif; ?>

									<?php if ($this->params->get('show_position_headings')) : ?>
										<li><?php echo $item->con_position; ?></li>
									<?php endif; ?>

									<?php if ($this->params->get('show_email_headings')) : ?>
										<li><?php echo $item->email_to; ?></li>
									<?php endif; ?>

									<?php $location = array(); ?>
									<?php if ($this->params->get('show_suburb_headings') && !empty($item->suburb)) : ?>
										<?php $location[] = $item->suburb; ?>
									<?php endif; ?>

									<?php if ($this->params->get('show_state_headings') && !empty($item->state)) : ?>
										<?php $location[] = $item->state; ?>
									<?php endif; ?>

									<?php if ($this->params->get('show_country_headings') && !empty($item->country)) : ?>
										<?php $location[] = $item->country; ?>
									<?php endif; ?>
									<li><?php echo implode(', ', $location); ?></li>
								</ul>

								<?php echo $item->event->afterDisplayContent; ?>
							</td>
							<?php if ($canEdit || ($canDo->get('core.edit.own') && $item->created_by === $userId)) : ?>
								<td class="uk-text-nowrap uk-text-truncate uk-table-link">
									<?php echo HTMLHelper::_('contacticon.edit', $item, $this->params); ?>
								</td>
							<?php endif; ?>
						<?php endforeach; ?>
					</tbody>
				</table>
			</div>
		<?php endif; ?>

		<?php if ($canDo->get('core.create')) : ?>
			<?php echo HTMLHelper::_('contacticon.create', $this->category, $this->category->params); ?>
		<?php endif; ?>

		<?php if ($this->params->get('show_pagination', 2)) : ?>
			<div class="com-contact-category__counter w-100">
				<?php if ($this->params->def('show_pagination_results', 1)) : ?>
					<p class="com-contact-category__counter counter float-right pt-3 pr-2">
						<?php echo $this->pagination->getPagesCounter(); ?>
					</p>
				<?php endif; ?>

				<?php echo $this->pagination->getPagesLinks(); ?>
			</div>
		<?php endif; ?>
		<div>
			<input type="hidden" name="filter_order" value="<?php echo $this->escape($this->state->get('list.ordering')); ?>">
			<input type="hidden" name="filter_order_Dir" value="<?php echo $this->escape($this->state->get('list.direction')); ?>">
		</div>
	</form>
</div>
