//////////////////////////////////////////////////////////////////
// * @package   ui/Theme - Builder                              //
// * @author    Stephan W. https://www.ui-themebuilder.com/     //
// * admin button actions ...;                                  //
// * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL    //
//////////////////////////////////////////////////////////////////

jQuery(function ($) {
    var adminForm = $("#adminForm");
    var formTask = $("#form_task");
    var btnSave = $("#btn-save-page, #btn-save-copy, #btn-save-new, #btn-save-close");
    var btnPreview = $("#btn-page-preview");

    adminForm.on("submit", function (event) {
        if (formTask.val() !== "page.cancel") {
            event.preventDefault();
        }
    });

    btnSave.on("click", function (event) {
        event.preventDefault();

        var clickedButton = $(this);
        var task = "page.apply";

        if (clickedButton.is("#btn-save-copy")) {
            task = "page.save2copy";
        }

        formTask.val(task);

        $.ajax({
            type: "POST",
            url: themebuilder_root + "administrator/index.php?option=com_uithemebuilderlite&task=page." + task,
            data: adminForm.serialize(),
            success: function (response) {
                try {
                    var jsonResponse = $.parseJSON(response);
                    var notificationStatus = "success";

                    if (!jsonResponse.status) {
                        notificationStatus = "danger";
                    }

                    if (jsonResponse.title) {
                        $("#jform_title").val(jsonResponse.title);
                    }

                    if (jsonResponse.id) {
                        $("#jform_id").val(jsonResponse.id);
                    }

                    UIkit.notification({
                        message: jsonResponse.message,
                        status: notificationStatus,
                        pos: 'bottom-left',
                        timeout: 4000
                    });

                    if (window.warningAtReload !== undefined && window.warningAtReload === true) {
                        window.warningAtReload = false;
                    }

                    if (!jsonResponse.status) {
                        return;
                    }

                    window.history.replaceState("", "", jsonResponse.redirect);

                    if (jsonResponse.preview_url) {
                        if (btnPreview.length === 0) {
                            $("#btn-page-options").parent().before('<li><a id="btn-page-preview" href="' + jsonResponse.preview_url + '" target="_blank" uk-tooltip="title:' + Joomla.JText._("JGLOBAL_PREVIEW") + '; pos: bottom"><i class="far fa-eye"></i></a></li>\n');
                        } else {
                            btnPreview.attr("href", jsonResponse.preview_url);
                        }
                    }

                    if (clickedButton.is("#btn-save-new")) {
                        window.location.href = "index.php?option=com_uithemebuilderlite&view=page&layout=edit";
                    }

                    if (clickedButton.is("#btn-save-close")) {
                        window.location.href = "index.php?option=com_uithemebuilderlite&view=pages";
                    }

                    if (clickedButton.is("#btn-save-copy")) {
                        setTimeout(function () {
                            window.location.href = "index.php?option=com_uithemebuilderlite&view=page&layout=edit";
                        }, 150);
                    }
                } catch (error) {
                    window.location.href = "index.php?option=com_uithemebuilderlite&view=pages";
                }
            }
            });
    });
});
