<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use SW\Component\uiThemeBuilderLite\Site\Helper\RouteHelper;
use SW\Component\uiThemeBuilderLite\Site\Helper\sortGridHelper;

$wa = $this->document->getWebAssetManager();
$wa->useScript('core');

$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn = $this->escape($this->state->get('list.direction'));

// Create a shortcut for params.
// $params = &$this->item->params;
?>

<div class="com-uithemebuilderlite-featured__items">
    <?php if (empty($this->items)) : ?>
        <p class="com-uithemebuilderlite-featured__message"> <?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?> </p>
    <?php else : ?>
        <form action="<?php echo htmlspecialchars(Uri::getInstance()->toString()); ?>" method="post" name="adminForm"
              id="adminForm">
            <table class="com-uithemebuilderlite-featured__table uk-table uk-table-striped">
                <thead class="thead-default">
                <tr>
                    <th class="item-title uk-table-expand">
                        <?php echo Text::_('JGLOBAL_TITLE'); ?>
                    </th>
                    <th class="item-hits">
                        <?php echo sortGridHelper::sort('JGLOBAL_HITS', 'a.hits', $listDirn, $listOrder, null, 'asc', '', 'adminForm'); ?>
                    </th>
                    <th>
                        <?php echo sortGridHelper::sort('PUBLISHED', 'a.published', $listDirn, $listOrder, null, 'asc', '', 'adminForm'); ?>
                    </th>
                </tr>
                </thead>

                <tbody>
                <?php foreach ($this->items as $i => $item) : ?>
                    <tr class="<?php echo ($i % 2) ? 'odd' : 'even'; ?>" itemscope>

                        <td class="item-title">
                            <a class="uk-link-reset"
                               href="<?php echo Route::_(RouteHelper::getPageRoute($item->slug, $item->catid, $item->language)); ?>"
                               itemprop="url">
                                <span itemprop="name"><?php echo $this->escape($item->title); ?></span>
                            </a>

                        </td>
                        <td class="item-hits">
                            <?php echo $item->hits; ?>
                        </td>
                        <td class="item-date">
                            <?php if ($item->published == 0) : ?>
                                <div>
                                    <span class="list-published badge bg-warning text-light">
                                        <?php echo Text::_('JUNPUBLISHED'); ?>
                                    </span>
                                </div>
                            <?php else : ?>
                                <?php echo $item->publish_up; ?>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
            <input type="hidden" name="filter_order" value="<?php echo $this->escape($this->state->get('list.ordering')); ?>">
            <input type="hidden" name="filter_order_Dir" value="<?php echo $this->escape($this->state->get('list.direction')); ?>">
        </form>
    <?php endif; ?>
</div>
