<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/

namespace SW\Component\uiThemeBuilderLite\Site\Helper;

defined('_JEXEC') or die;


use Joomla\CMS\Language\Text;

/**
 * Utility class for creating HTML Grids
 *
 * @since  v1.0.0
 */

// No direct access
defined('_JEXEC') or die;

class sortGridHelper
{

    /**
     * Method to sort a column in a grid
     *
     * @param   string       $title          The link title
     * @param   string       $order          The order field for the column
     * @param   string       $direction      The current direction
     * @param   string       $selected       The selected ordering
     * @param   string|null  $task           An optional task override
     * @param   string       $new_direction  An optional direction for the new column
     * @param   string|null  $tip            An optional text shown as tooltip title instead of $title
     * @param   string|null  $form           An optional form selector
     *
     * @return  string
     *
     * @since   v1.0.0
     */
    public static function sort(string $title, string $order, string $direction = 'asc', string $selected = '', string|null $task = null, string $new_direction = 'asc', string|null $tip = '', string|null $form = null): string
    {

        $direction = strtolower($direction);
        $icon = array('triangle-up', 'triangle-down');
        $index = (int) ($direction === 'desc');

        if ($order !== $selected) {
            $direction = $new_direction;
        } else {
            $direction = $direction === 'desc' ? 'asc' : 'desc';
        }

        if ($form) {
            $form = ', document.getElementById(\'' . $form . '\')';
        }

        $html = '<a href="#" onclick="Joomla.tableOrdering(\'' . $order . '\',\'' . $direction . '\',\'' . $task . '\'' . $form . ');return false;"'
            . ' class="uk-link-reset" uk-tooltip="' . htmlspecialchars(Text::_('JGLOBAL_CLICK_TO_SORT_THIS_COLUMN')) . '<br>' . htmlspecialchars(Text::_($title)) . '" title="' . htmlspecialchars(Text::_($tip ?: $title)) . '"'
            . ' >';

        if (isset($title['0']) && $title['0'] === '<') {
            $html .= $title;
        } else {
            $html .= Text::_($title);
        }

        if ($order === $selected) {
            $html .= ' <span uk-icon="icon: ' . $icon[$index] . '"></span> ';
        }

        $html .= '</a>';

        return $html;
    }
}
