<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
namespace SW\Component\uiThemeBuilderLite\Site\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;

/**
 * ui/Theme-Builder Lite Component Controller
 *
 * @since  v1.0.0
 */
class DisplayController extends BaseController
{
    /**
     * Constructor.
     *
     * @param   array                                             $config   An optional associative array of configuration settings.
     *                                                                      Recognized key values include 'name', 'default_task', 'model_path', and
     *                                                                      'view_path' (this list is not meant to be comprehensive).
     * @param   \Joomla\CMS\MVC\Factory\MVCFactoryInterface|null  $factory  The factory.
     * @param   null                                              $app      The JApplication for the dispatcher
     * @param   null                                              $input    Input
     *
     * @since   v1.0.0
     */
    public function __construct($config = [], MVCFactoryInterface $factory = null, $app = null, $input = null)
    {

        parent::__construct($config, $factory, $app, $input);
    }

    /**
     * Method to display a view.
     *
     * @param   boolean  $cachable   If true, the view output will be cached
     * @param   array    $urlparams  An array of safe URL parameters and their variable types, for valid values see {@link \JFilterInput::clean()}.
     *
     * @return  static  This object to support chaining.
     *
     * @throws \Exception
     *
     * @since   v1.0.0
     */
    public function display($cachable = false, $urlparams = false)
    {

        $id              = $this->input->getInt('id');
        $vName           = $this->input->getCmd('view');
        $config_params   = ComponentHelper::getParams('com_uithemebuilderlite');
        $globalPageCache = $config_params->get('page_cache');

        $validvNames = ['page', 'form', 'rawns', 'raw', 'category', 'categories', 'featured'];
        $viewStatus = \in_array($vName, $validvNames);

        if (!$viewStatus) {
            // Somehow the person just went to the form—we don't allow that.
            throw new \RuntimeException(Text::sprintf('JLIB_APPLICATION_ERROR_UNHELD_ID', $id), 403);
        }

        $this->input->set('view', $vName);

        if (($vName === 'page' || $vName === 'featured') && $globalPageCache == 1) {
            $cachable = true;
        }

        $safeURLParams = array(
            'id'               => 'ARRAY',
            'catid'            => 'ARRAY',
            'list'             => 'ARRAY',
            'limitstart'       => 'UINT',
            'Itemid'           => 'INT',
            'view'             => 'CMD',
            'lang'             => 'CMD',
            'print'            => 'BOOLEAN'
        );


        $user = $this->app->getIdentity();
        $isIgnoreView = ($this->input->getMethod() === 'POST' && ($vName === 'form' && ($this->input->get('layout') !== 'edit')));

        if ($user->get('id') || $isIgnoreView || $vName == 'raw' || $vName == 'rawns') {
            $cachable = false;
        }

        // Page hits
        if ($vName === 'page' || $vName === 'category') {
            // Get/Create the model
            if ($model = $this->getModel($vName)) {
                $model->hit();
            }
        }

        parent::display($cachable, $safeURLParams);
    }
}
