<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
defined('_JEXEC') or die('Restricted access');


use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Language\Text;
use SW\Component\uiThemeBuilderLite\Site\Helper\SitePageHelper;

$html                    = '';
$options                 = SitePageHelper::escapeHtmlArray($displayData['options']);
$items                   = $displayData['items'];
$title_show              = ($options['title_show'] ?? 1);
$titleAndSubtitleClasses = SitePageHelper::getTitleAndSubtitleClasses($options);
$title_class             = ($titleAndSubtitleClasses['title'] === '') ? '' : ' ' . $titleAndSubtitleClasses['title'];

$tab_style       = '';
$tab_style_left  = ($options['tab_style'] === 'uk-tab-left');
$tab_style_right = ($options['tab_style'] === 'uk-tab-right');


// Tab Style
if ((!empty($options['tab_style'])) || (!empty($options['tab_alignment']))) {
    $tab_style_class = '';
    if (!empty($options['tab_style'])) {
        $tab_style_class = $options['tab_style'];
    }
    if (!empty($options['tab_alignment'])) {
        $tab_style_class .= ' ' . $options['tab_alignment'];
    }
    $tab_style = ' class="' . $tab_style_class . '"';
}
// Build Tab content HTML
if (!empty($options['title']) && $title_show === "1") {
    $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'ui-tab-title');
}
// Tab Style left / right / default  && bottom
if ($tab_style_left) {
    if (count($items)) {
        $html .= '<div uk-grid="">';
        $html .= '<div class="uk-width-auto">';
        $html .= '<ul class="uk-tab-left" uk-tab="connect: #component-tab-left; animation: uk-animation-fade">';
        foreach ($items as $item_index => $item) {
            $item_options     = SitePageHelper::escapeHtmlArray($item['options']);
            $item_title_class = '';
            // Tab item title style
            if (!empty($item_options['item_title']) && !empty($item_options['item_title_font_weight'])) {
                $item_title_class = ' class="' . $item_options['item_title_font_weight'] . '"';
            }
            // Build Tab navigation HTML
            if (!empty($item_options['item_title']) && !empty($item_options['item_title_icon'])) {
                $html .= '<li>';
                $html .= '<a href="javascript:void(0)">';
                $html .= '<i class="uk-margin-small-right ' . $item_options['item_title_icon'] . '"></i>';
                $html .= '<span' . $item_title_class . '>' . $item_options['item_title'] . '</span>';
                $html .= '</a>';
                $html .= '</li>';
            } else {
                $html .= '<li><a href="javascript:void(0)"><span' . $item_title_class . '>' . $item_options['item_title'] . '</span></a></li>';
            }
        }
        $html .= '</ul>';
        $html .= '</div>';
        $html .= '<div class="uk-width-expand">';
        $html .= '<ul id="component-tab-left" class="uk-switcher">';
        foreach ($items as $item_index => $item) {
            $item_options = SitePageHelper::escapeHtmlArray($item['options']);
            // Tab item content
            if (!empty($item_options['item_content'])) {
                // Build Tab item content HTML
                $html .= '<li>' . $item_options['item_content'] . '</li>';
                // Tab item module
            } elseif (!empty($item_options['item_content_module'])) {
                $user        = Factory::getApplication()->getIdentity();
                $user_levels = implode(',', $user->getAuthorisedViewLevels());
                $language    = Factory::getApplication()->getLanguage()->getTag();
                $db          = Factory::getContainer()->get('DatabaseDriver');
                $query       = $db->getQuery(true);
                $now         = Factory::getDate()->toSql();
                $nullDate    = $db->getNullDate();

                $query->select('*');
                $query->from($db->qn('#__modules'));
                $query->where($db->qn('id') . ' = ' . $db->q($item_options['item_content_module']));
                $query->where('(' . $db->qn('publish_up') . ' = ' . $db->q($nullDate) . ' OR ' . $db->qn('publish_up') . ' <= ' . $db->q($now) . ')');
                $query->where('(' . $db->qn('publish_down') . ' = ' . $db->q($nullDate) . ' OR ' . $db->qn('publish_down') . ' >= ' . $db->q($now) . ')');
                $query->where($db->qn('published') . '=' . $db->q(1));
                $query->where($db->qn('client_id') . '=0');
                $query->where($db->qn('access') . ' IN (' . $user_levels . ')');
                // $query->where($db->qn('language').' IN ('.$language.')');
                $db->setQuery($query);
                $module       = $db->loadObject();
                $module_title = $module->title;
                if (Factory::getApplication()->isClient('site')) {
                    // Build Module HTML
                    if ($module && (!empty($module_title)) && ($item_options['item_content_module_title_show'] === "1")) {
                        $html .= '<li><h3>' . $module_title . '</h3>' . JModuleHelper::renderModule($module) . '</li>';
                    } elseif ($module) {
                        $html .= '<li>' . JModuleHelper::renderModule($module) . '</li>';
                    }
                    // Build Module HTML Administrator
                } else {
                    $html .= '<li>';
                    if ($item_options['item_content_module_title_show'] === "1") {
                        $html .= '<h3>' . Text::_('COM_UITHEMEBUILDERLITE_DEFAULT_TITLE') . '</h3>';
                    }
                    $html .= '<div class="uk-alert-danger uk-padding-small" uk-alert>';
                    $html .= '<a class="uk-alert-close" uk-close></a>';
                    $html .= '<h3 class="alert-heading">' . Text::_('COM_UITHEMEBUILDERLITE_MODULE_NO_PREVIEW') . '</h3>';
                    $html .= '<p>' . Text::_('COM_UITHEMEBUILDERLITE_MODULE_NO_PREVIEW_DESC') . '</p>';
                    $html .= '</div>';
                    $html .= '</li>';
                }
            }
        }
        $html .= '</ul>';
        $html .= '</div>';
        $html .= '</div>';
    }
} elseif ($tab_style_right) {
    if (count($items)) {
        $html .= '<div uk-grid="">';
        $html .= '<div class="uk-width-auto uk-flex-last">';
        $html .= '<ul class="uk-tab-right" uk-tab="connect: #component-tab-right; animation: uk-animation-fade">';
        foreach ($items as $item_index => $item) {
            $item_options     = SitePageHelper::escapeHtmlArray($item['options']);
            $item_title_class = '';
            // Tab item title style
            if (!empty($item_options['item_title']) && !empty($item_options['item_title_font_weight'])) {
                $item_title_class = ' class="' . $item_options['item_title_font_weight'] . '"';
            }
            // Build Tab navigation HTML
            if (!empty($item_options['item_title']) && !empty($item_options['item_title_icon'])) {
                $html .= '<li>';
                $html .= '<a href="javascript:void(0)">';
                $html .= '<i class="uk-margin-small-right ' . $item_options['item_title_icon'] . '"></i>';
                $html .= '<span' . $item_title_class . '>' . $item_options['item_title'] . '</span>';
                $html .= '</a>';
                $html .= '</li>';
            } else {
                $html .= '<li><a href="javascript:void(0)"><span' . $item_title_class . '>' . $item_options['item_title'] . '</span></a></li>';
            }
        }
        $html .= '</ul>';
        $html .= '</div>';
        $html .= '<div class="uk-width-expand">';
        $html .= '<ul id="component-tab-right" class="uk-switcher">';
        foreach ($items as $item_index => $item) {
            $item_options = SitePageHelper::escapeHtmlArray($item['options']);
            // Tab item content
            if (!empty($item_options['item_content'])) {
                // Build Tab item content HTML
                $html .= '<li>' . $item_options['item_content'] . '</li>';
                // Tab item module
            } elseif (!empty($item_options['item_content_module'])) {
                $user        = Factory::getApplication()->getIdentity();
                $user_levels = implode(',', $user->getAuthorisedViewLevels());
                $language    = Factory::getApplication()->getLanguage()->getTag();
                $db          = Factory::getContainer()->get('DatabaseDriver');
                $query       = $db->getQuery(true);
                $now         = Factory::getDate()->toSql();
                $nullDate    = $db->getNullDate();

                $query->select('*');
                $query->from($db->qn('#__modules'));
                $query->where($db->qn('id') . ' = ' . $db->q($item_options['item_content_module']));
                $query->where('(' . $db->qn('publish_up') . ' = ' . $db->q($nullDate) . ' OR ' . $db->qn('publish_up') . ' <= ' . $db->q($now) . ')');
                $query->where('(' . $db->qn('publish_down') . ' = ' . $db->q($nullDate) . ' OR ' . $db->qn('publish_down') . ' >= ' . $db->q($now) . ')');
                $query->where($db->qn('published') . '=' . $db->q(1));
                $query->where($db->qn('client_id') . '=0');
                $query->where($db->qn('access') . ' IN (' . $user_levels . ')');
                // $query->where($db->qn('language').' IN ('.$language.')');
                $db->setQuery($query);
                $module       = $db->loadObject();
                $module_title = $module->title;
                if (Factory::getApplication()->isClient('site')) {
                    // Build Module HTML
                    if ($module && (!empty($module_title)) && ($item_options['item_content_module_title_show'] === "1")) {
                        $html .= '<li><h3>' . $module_title . '</h3>' . JModuleHelper::renderModule($module) . '</li>';
                    } elseif ($module) {
                        $html .= '<li>' . JModuleHelper::renderModule($module) . '</li>';
                    }
                    // Build Module HTML Administrator
                } else {
                    $html .= '<li>';
                    if ($item_options['item_content_module_title_show'] === "1") {
                        $html .= '<h3>' . Text::_('COM_UITHEMEBUILDERLITE_DEFAULT_TITLE') . '</h3>';
                    }
                    $html .= '<div class="uk-alert-danger uk-padding-small" uk-alert>';
                    $html .= '<a class="uk-alert-close" uk-close></a>';
                    $html .= '<h3 class="alert-heading">' . Text::_('COM_UITHEMEBUILDERLITE_MODULE_NO_PREVIEW') . '</h3>';
                    $html .= '<p>' . Text::_('COM_UITHEMEBUILDERLITE_MODULE_NO_PREVIEW_DESC') . '</p>';
                    $html .= '</div>';
                    $html .= '</li>';
                }
            }
        }
        $html .= '</ul>';
        $html .= '</div>';
        $html .= '</div>';
    }
} elseif (count($items)) {
    $html .= '<ul' . $tab_style . ' uk-tab="animation: uk-animation-fade">';
    foreach ($items as $item_index => $item) {
        $item_options     = SitePageHelper::escapeHtmlArray($item['options']);
        $item_title_class = '';
        // Tab item title style
        if (!empty($item_options['item_title']) && !empty($item_options['item_title_font_weight'])) {
            $item_title_class = ' class="' . $item_options['item_title_font_weight'] . '"';
        }
        // Build Tab navigation HTML
        if (!empty($item_options['item_title']) && !empty($item_options['item_title_icon'])) {
            $html .= '<li>';
            $html .= '<a href="javascript:void(0)">';
            $html .= '<i class="uk-margin-small-right ' . $item_options['item_title_icon'] . '"></i>';
            $html .= '<span' . $item_title_class . '>' . $item_options['item_title'] . '</span>';
            $html .= '</a>';
            $html .= '</li>';
        } else {
            $html .= '<li><a href="javascript:void(0)"><span' . $item_title_class . '>' . $item_options['item_title'] . '</span></a></li>';
        }
    }
    $html .= '</ul>';
    $html .= '<ul class="uk-switcher uk-margin">';
    foreach ($items as $item_index => $item) {
        $item_options = SitePageHelper::escapeHtmlArray($item['options']);
        // Tab item content
        if (!empty($item_options['item_content'])) {
            // Build Tab item content HTML
            $html .= '<li>' . $item_options['item_content'] . '</li>';
            // Tab item module
        } elseif (!empty($item_options['item_content_module'])) {
            $id      = $item_options['item_content_module'];
            $modules = ModuleHelper::getModuleList();
            foreach ($modules as $module) {
                if ($module->id == $id) {
                    if ($module->showtitle) {
                        $module_title = $module->title;
                    }
                    $modulehtml = ModuleHelper::renderModule($module);
                }
            }

            if (Factory::getApplication()->isClient('site')) {
                // Build Module HTML
                if ($module && (!empty($module_title)) && ($item_options['item_content_module_title_show'] === "1")) {
                    $html .= '<li><h3>' . $module_title . '</h3>' . ModuleHelper::renderModule($module) . '</li>';
                } elseif ($module) {
                    $html .= '<li>' . $modulehtml . '</li>';
                }
                // Build Module HTML Administrator
            } else {
                $html .= '<li>';
                if ($item_options['item_content_module_title_show'] === "1") {
                    $html .= '<h3>' . Text::_('COM_UITHEMEBUILDERLITE_DEFAULT_TITLE') . '</h3>';
                }
                $html .= '<div class="uk-alert-danger uk-padding-small" uk-alert>';
                $html .= '<a class="uk-alert-close" uk-close></a>';
                $html .= '<h3 class="alert-heading">' . Text::_('COM_UITHEMEBUILDERLITE_MODULE_NO_PREVIEW') . '</h3>';
                $html .= '<p>' . Text::_('COM_UITHEMEBUILDERLITE_MODULE_NO_PREVIEW_DESC') . '</p>';
                $html .= '</div>';
                $html .= '</li>';
            }
        }
    }
    $html .= '</ul>';
}

echo $html;
