<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
defined('_JEXEC') or die('Restricted access');


use Joomla\CMS\Factory;
use SW\Component\uiThemeBuilderLite\Site\Helper\SitePageHelper;

$html                    = '';
$doc                     = Factory::getApplication()->getDocument();
$options                 = SitePageHelper::escapeHtmlArray($displayData['options']);
$items                   = $displayData['items'];
$title_show              = ($options['title_show'] ?? 1);
$titleAndSubtitleClasses = SitePageHelper::getTitleAndSubtitleClasses($options);
$title_class             = ($titleAndSubtitleClasses['title'] === '') ? '' : ' ' . $titleAndSubtitleClasses['title'];

$item_animations_script = ($options['item_animations'] ?? 0);

$wa = $doc->getWebAssetManager();

if ($item_animations_script === "1") {
    $animate = 'UIkit.util.ready(() => {
					UIkit.util.$$(\'progress#ui-progressbar-animate\').forEach(bar => {
						UIkit.scrollspy(bar, { hidden: false });
						UIkit.util.on(bar, \'inview\', function() {
							let bar   = this,
								stop  = parseInt(bar.getAttribute(\'data-stop\')),
								step  = parseInt(bar.getAttribute(\'data-step\')),
								speed = parseInt(bar.getAttribute(\'data-speed\'));
							let animate = setInterval(() => {
								bar.value += step;
								if (bar.value >= stop) {
									clearInterval(animate);
								}
							}, speed);
						});
					});
				});
			';

    $wa->addInlineScript(trim(preg_replace('/^\s+|\n|\r|\s+$/m', '', $animate)), [], ['type' => 'module']);
}

// Build Progress Bars HTML
if (!empty($options['title']) && $title_show === "1") {
    $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'ui-progress-bars-title');
}

if (count($items)) {
    foreach ($items as $item_index => $item) {
        $item_options = SitePageHelper::escapeHtmlArray($item['options']);

        // Build Progress Bars items HTML
        if (!empty($item_options['item_width'])) {
            if (!empty($item_options['item_content_description'])) {
                $html .= '<' . $item_options['item_content_description_html_tag'] . '>' . $item_options['item_content_description'] . '</' . $item_options['item_content_description_html_tag'] . '>';
            }
            if (!empty($item_options['item_animation'])) {
                $html .= '<progress id="ui-progressbar-animate" class="uk-progress" value="' . $item_options['item_width'] . '" min="5" max="100" data-stop="' . $item_options['item_max_width'] . '" data-step="1" data-speed="' . $item_options['item_animation_delay'] . '"></progress>';
            } else {
                $html .= '<progress id="ui-progressbar' . $item_index . '-no-animate" class="uk-progress" value="' . $item_options['item_width'] . '" min="5" max="100"></progress>';
            }
        }
    }
}

echo $html;
