<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
defined('_JEXEC') or die('Restricted access');


use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use SW\Component\uiThemeBuilderLite\Site\Helper\SitePageHelper;

$html                    = '';
$options                 = SitePageHelper::escapeHtmlArray($displayData['options']);
$items                   = $displayData['items'];
$doc                     = Factory::getApplication()->getDocument();
$button_class            = 'uk-button';
$table_class             = '';
$content_class           = '';
$title_show              = ($options['title_show'] ?? 1);
$titleAndSubtitleClasses = SitePageHelper::getTitleAndSubtitleClasses($options);
$title_class             = ($titleAndSubtitleClasses['title'] === '') ? '' : ' ' . $titleAndSubtitleClasses['title'];

$id                = $options['button_menulist'];
$button_full_width = ($options['button_full_width'] ?? 0);
$table_hover       = ($options['table_hover'] ?? 0);


// Price Table content
if (!empty($options['content'])) {
    if (!empty($options['alignment'])) {
        $content_class .= $options['alignment'];
    }
    if (!empty($options['content_margin'])) {
        $content_class .= ' ' . $options['content_margin'];
    }
}
// Price button
if ((!empty($options['button_text']) || !empty($options['button_icon'])) && (!empty($options['button_url']) || !empty($options['button_menulist']))) {
    if (!empty($options['icons_font_size'])) {
        $icon_class = ' ' . $options['icons_font_size'];
    } else {
        $icon_class = '';
    }

    if (!empty($options['button_type'])) {
        $button_class .= ' uk-button-' . $options['button_type'];
    }
    if (!empty($options['button_size'])) {
        $button_class .= ' uk-button-' . $options['button_size'];
    }
    if (!empty($options['button_alignment'])) {
        $button_alignment_class = $options['alignment'];
    }
    if ($button_full_width === "1") {
        $button_class .= ' uk-width-1-1';
    }
}


// Price Table classes
if (!empty($options['table_size'])) {
    $table_class .= ' ' . $options['table_size'];
}
if ($table_hover === "1") {
    $table_class .= ' uk-table-hover';
}
if (!empty($options['table_modifier'])) {
    $table_class .= ' ' . $options['table_modifier'];
}

// Build Price Table HTML
$html .= '<table class="uk-table uk-table-responsive' . $table_class . '">';
    $html .= '<thead>';
        $html .= '<tr>';
            $html .= '<th>';
if (!empty($options['title']) && $title_show === "1") {
    $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'ui-price-table-title');
}
if (!empty($options['content'])) {
    $html .= '<div class="uk-margin' . $content_class . '">';
        $html .= $options['content'];
    $html .= '</div>';
}
            $html .= '</th>';
        $html .= '</tr>';
    $html .= '</thead>';

if (count($items)) {
    $html .= '<tbody>';
    // Build Price Box items HTML
    foreach ($items as $item) {
        $item_options = SitePageHelper::escapeHtmlArray($item['options']);
        if (!empty($item_options['item_font_weight'])) {
            $item_font_weight = ' class="' . $item_options['item_font_weight'] . '"';
        } else {
            $item_font_weight = '';
        }
        $html .= '<tr>';
        $html .= '<td>';
        if (!empty($item_options['item_text_icon'])) {
            $html .= '<i class="uk-margin-small-right ' . $item_options['item_text_icon'] . '"></i>';
        }
        $html .= '<span' . $item_font_weight . '>' . $item_options['item_text'] . '</span>';
        $html .= '</td>';
        $html .= '</tr>';
    }
    $html .= '</tbody>';
}

if ((!empty($options['button_text']) || !empty($options['button_icon'])) && (!empty($options['button_url']) || !empty($options['button_menulist']))) {
    $html .= '<tfoot>';
    $html .= '<tr>';
    $html .= '<td>';
    $html .= '<div class="' . $button_alignment_class . '">';
    if (!empty($options['button_url'])) {
        $html .= '<a href="' . $options['button_url'] . '" target="' . $options['button_target'] . '" class="' . $button_class . '">';
    } else {
        $html .= '<a href="' . Route::_("index.php?Itemid={$id}") . '" target="' . $options['button_target'] . '" class="' . $button_class . '">';
    }
    if (!empty($options['button_icon'])) {
        $html .= '<i class="uk-margin-small-right ' . $options['button_icon'] . $icon_class . '"></i>';
    }
    if (!empty($options['button_text'])) {
        $html .= $options['button_text'];
    }
    $html .= '</a>';
    $html .= '</div>';
    $html .= '</td>';
    $html .= '</tr>';
    $html .= '</tfoot>';
}

$html .= '</table>';

echo $html;
