<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use SW\Component\uiThemeBuilderLite\Site\Helper\SitePageHelper;

$html                    = '';
$options                 = SitePageHelper::escapeHtmlArray($displayData['options']);
$items                   = $displayData['items'];
$doc                     = Factory::getApplication()->getDocument();
$random_id               = SitePageHelper::randomNumber();
$title_show              = ($options['title_show'] ?? 1);
$titleAndSubtitleClasses = SitePageHelper::getTitleAndSubtitleClasses($options);
$title_class             = ($titleAndSubtitleClasses['title'] === '') ? '' : ' ' . $titleAndSubtitleClasses['title'];

$child_width  = '';
$button_class = 'uk-button';
$image_root   = Uri::root(true) . '/';

$grid_match                       = ($options['grid_match'] ?? 0);
$masonry_grid_style               = ($options['masonry_grid_style'] ?? 0);

// Button alignment
if (!empty($options['alignment'])) {
    $alignment_class = ' ' . $options['alignment'];
} else {
    $alignment_class = '';
}
// Button settings
if (!empty($options['text_font_weight'])) {
    $button_class .= ' ' . $options['text_font_weight'];
}
if (!empty($options['button_size'])) {
    $button_class .= ' uk-button-' . $options['button_size'];
}
if (!empty($options['button_type'])) {
    $button_class .= ' uk-button-' . $options['button_type'];
}
if (!empty($options['button_full_width'])) {
    $button_class .= ' uk-width-1-1';
}
// Responsive Grid Settings
if (!empty($options['grid_m'])) {
    $child_width .= ' uk-child-width-' . $options['grid_m'] . '@m';
}
if (!empty($options['grid_l'])) {
    $child_width .= ' uk-child-width-' . $options['grid_l'] . '@l';
}
if (!empty($options['grid_xl'])) {
    $child_width .= ' uk-child-width-' . $options['grid_xl'] . '@xl';
}

// Build HTML
if (!empty($options['title']) && $title_show === "1") {
    $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'ui-lightbox-title');
}

if ($grid_match == 1) {
    $grid_match_attr = ' uk-height-match="target: > div > a > *"';
} else {
    $grid_match_attr = '';
}
// Masonry Grid
if ($masonry_grid_style == 1) {
    $grid = ' uk-grid="masonry: true"';
} else {
    $grid = ' uk-grid=""';
}
// Image Lightbox
// Site view -uk-lightbox
if (Factory::getApplication()->isClient('site')) {
    $html .= '<div class="' . $alignment_class . ' ' . $show_more_id . ' uk-child-width-1-1' . $child_width . ' ' . $options['grid_gutter'] . '"' . $grid . ' uk-lightbox="animation: ' . $options['lightbox_animation'] . '; autoplay: ' . $options['lightbox_autoplay'] . '; autoplay-interval: ' . $options['lightbox_autoplay_interval'] . '"' . $grid_match_attr . '>';
} else {
    $html .= '<div class="' . $alignment_class . ' ' . $show_more_id . ' uk-child-width-1-1' . $child_width . ' ' . $options['grid_gutter'] . '"' . $grid . $grid_match_attr . '>';
}
if (count($items)) {
    foreach ($items as $item_index => $item) {
        $item_options = SitePageHelper::escapeHtmlArray($item['options']);
        $data_attr    = '';
        $srcsets      = array ();

        $lightbox_image_thumbnail = ($item_options['lightbox_image_thumbnail'] ?? 0);

        if (!empty($item_options['lightbox_image'])) {
            $img_full_path = $image_root . $item_options['lightbox_image'];
            $data_type     = '';
        } else {
            // random Image sizes for unsplash.com
            $sizes         = ['800x600', '1024x768', '960x540', '1280x960'];
            $img_full_path = SitePageHelper::getRandomUnsplashUrl($sizes, 'bike,night,retro');
            $data_type     = ' data-type="iframe"';
        }

        $item_index++;

        $type             = SitePageHelper::toArray($item);
        $typetmp          = str_replace('_', '-', $type['type']);
        $typeitem         = str_replace('-item', '', $typetmp);
        $thumbnail_folder = 'media/com_uithemebuilderlite/ui-themebuilder-thumb/' . $typeitem;

        if (!Factory::getApplication()->isClient('site') && $lightbox_image_thumbnail == 1 && !empty($item_options['lightbox_image'])) {
            // create thumbnails only on admin view
            [$width, $height] = getimagesize(Uri::root() . $item_options['lightbox_image']);
            $ex        = '.' . pathinfo($item_options['lightbox_image'], PATHINFO_EXTENSION);
            $file_name = 'th_' . pathinfo($item_options['lightbox_image'], PATHINFO_FILENAME);
            // ratio
            $ratio = round($width / $height * 100);

            $tmp_srcset    = explode(',', $item_options['item_image_width_srcset']);
            $merge_srcsets = array_merge($srcsets, $tmp_srcset);
            $srcsets       = array_map('trim', $merge_srcsets);
            $srcsets       = array_unique($srcsets);

            $filter  = range(1, 4000);
            $result  = array_diff($filter, $srcsets);
            $results = array_unique($result);
            $file    = '';

            foreach ($srcsets as $i => $val) {
                if (is_numeric($val) && $val < 4000) {
                    unset($srcsets[$i]);
                    if ($val < 500) {
                        SitePageHelper::image_resize('../' . $item_options['lightbox_image'], $val, 0, 60, 0, '../' . $thumbnail_folder, false);
                    } else {
                        SitePageHelper::image_resize('../' . $item_options['lightbox_image'], $val, 0, 90, 0, '../' . $thumbnail_folder, false);
                    }

                    // delete files if srcset value not exists
                    foreach ($results as $e => $vale) {
                        unset($results[$e]);
                        $file = '../' . $thumbnail_folder . '/' . $file_name . '_' . $vale . $ex;

                        if (file_exists($file)) {
                            chmod($file, 0777);
                            unlink($file);
                        }
                    }
                }
            }
        }

        $html .= '<div>';
        // with thumbnail
        if ($lightbox_image_thumbnail === '1') {
            $html .= '<a class="uk-inline"';
            // Site view
            if (Factory::getApplication()->isClient('site')) {
                $html .= ' href="' . $img_full_path . '"';
            } else {
                // Admin Preview view
                $html .= ' href="javascript:void(0)"';
            }
            if (!empty($item_options['item_image_alt_text'])) {
                $data_attr = ' alt="' . $item_options['item_image_alt_text'] . '"';
            }
            if (!empty($item_options['lightbox_image_caption'])) {
                $html      .= ' data-caption="' . $item_options['lightbox_image_caption'] . '"';
            } else {
                $data_attr = '';
            }

            $html .= '>';

            if (!empty($item_options['item_image_width_srcset']) && !empty($item_options['lightbox_image'])) {
                [$width, $height] = getimagesize(Uri::root() . $item_options['lightbox_image']);
                $ex        = '.' . pathinfo($item_options['lightbox_image'], PATHINFO_EXTENSION);
                $file_name = 'th_' . pathinfo($item_options['lightbox_image'], PATHINFO_FILENAME);
                // ratio
                $ratio = round($width / $height * 100);

                $tmp_srcset    = explode(',', $item_options['item_image_width_srcset']);
                $merge_srcsets = array_merge($srcsets, $tmp_srcset);
                $srcsets       = array_map('trim', $merge_srcsets);

                $min_val = min($srcsets);

                $html .= '<img ';
                $html .= 'data-sizes="';
                $html .= '(min-width: ' . $min_val . 'px) 90vw, ';
                $html .= '(max-width: ' . $width . 'px) 100vw, ';
                $html .= '(max-aspect-ratio: ' . $width . '/' . $height . ') ' . $ratio . 'vh" ';
                $html .= 'data-srcset="';
                foreach ($srcsets as $i => $val) {
                    if (is_numeric($val)) {
                        $html .= Uri::root() . $thumbnail_folder . '/' . $file_name . '_' . $val . $ex . ' ' . $val . 'w, ';
                    }
                }

                $html .= Uri::root() . $item_options['lightbox_image'] . ' ' . $width . 'w" ';
                $html .= 'data-src="' . $item_options['lightbox_image'] . '"';
                $html .= $data_attr . ' uk-img="" />';
            } else {
                $html .= '<img data-src="' . $image_root . $item_options['lightbox_image'] . '"' . $data_attr . ' uk-img="">';
            }
            $html .= '</a>';
        } else {
            // without thumbnail
            $html .= '<a class="uk-inline"';
            // Site view
            if (Factory::getApplication()->isClient('site')) {
                $html .= ' href="' . $img_full_path . '"';
            } else {
                // Admin Preview view
                $html .= ' href="javascript:void(0)"';
            }

            if (!empty($item_options['item_image_alt_text'])) {
                $data_attr = ' alt="' . $item_options['item_image_alt_text'] . '"';
            }

            if (!empty($item_options['lightbox_image_caption'])) {
                $html      .= ' data-caption="' . $item_options['lightbox_image_caption'] . '"';
            }

            $html .= $data_type . '>';

            if (!empty($item_options['item_image_width_srcset']) && !empty($item_options['lightbox_image'])) {
                [$width, $height] = getimagesize(Uri::root() . $item_options['lightbox_image']);
                $ex        = '.' . pathinfo($item_options['lightbox_image'], PATHINFO_EXTENSION);
                $file_name = 'th_' . pathinfo($item_options['lightbox_image'], PATHINFO_FILENAME);
                // ratio
                $ratio = round($width / $height * 100);

                $html .= '<img ';
                $html .= 'data-sizes="';
                $html .= '(min-width: ' . $min_val . 'px) 90vw, ';
                $html .= '(max-width: ' . $width . 'px) 100vw, ';
                $html .= '(max-aspect-ratio: ' . $width . '/' . $height . ') ' . $ratio . 'vh" ';
                $html .= 'data-srcset="';
                foreach ($srcsets as $i => $val) {
                    if (is_numeric($val)) {
                        $html .= Uri::root() . $thumbnail_folder . '/' . $file_name . '_' . $val . $ex . ' ' . $val . 'w, ';
                    }
                }
                $html .= Uri::root() . $item_options['lightbox_image'] . ' ' . $width . 'w" ';
                $html .= 'data-src="' . $item_options['lightbox_image'] . '"';
                $html .= $data_attr . ' uk-img="" />';
            } else {
                $html .= '<img data-src="' . $img_full_path . '"' . $data_attr . ' uk-img="" />';
            }
            $html .= '</a>';
        }
        $html .= '</div>';
    }
}

$html .= '</div>';

echo $html;
