<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/

// No direct access
defined('_JEXEC') or die ('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\Component\Tags\Site\Helper\RouteHelper;
use Joomla\Registry\Registry;

$authorised = Factory::getApplication()->getIdentity()->getAuthorisedViewLevels();
$tags = '';

if (!empty($displayData)):
	foreach ($displayData as $i => $tag):
		if (in_array($tag->access, $authorised, true)):
			$tagParams = new Registry($tag->params);
			$link_class = ' ' . $tagParams->get('tag_link_class');
			$tags .= '<div><a class="tm-tags' . $link_class . '" href="' . Route::_(RouteHelper::getComponentTagRoute($tag->tag_id . ':' . $tag->alias, $tag->language)) . '" itemprop="keywords">' . $this->escape($tag->title) . '</a></div>';
		endif;
	endforeach;
endif;

echo $tags;
