<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use SW\Component\uiThemeBuilderLite\Site\Helper\SitePageHelper;

$html                    = '';
$options                 = SitePageHelper::escapeHtmlArray($displayData['options']);
$url_id                  = $options['button_menulist'];
$id                      = SitePageHelper::randomNumber();
$title_show              = ($options['title_show'] ?? 0);
$titleAndSubtitleClasses = SitePageHelper::getTitleAndSubtitleClasses($options);
$title_class             = ($titleAndSubtitleClasses['title'] === '') ? '' : ' ' . $titleAndSubtitleClasses['title'];

$overlay_class = '';

$doc = Factory::getApplication()->getDocument();

$image_shadow_bottom                 = ($options['image_shadow_bottom'] ?? 1);
$svg_image_typ_with_imageplaceholder = ($options['svg_image_typ_with_imageplaceholder'] ?? 0);

$srcset  = '';
$srcsets = [];

$component        = SitePageHelper::toArray($displayData['type']);
$typeitem         = str_replace('_', '-', $component);
$thumbnail_folder = 'media' . DIRECTORY_SEPARATOR . 'com_uithemebuilderlite' . DIRECTORY_SEPARATOR . 'ui-themebuilder-thumb' . DIRECTORY_SEPARATOR . $typeitem;

$image_typ_srcset_default = ($options['image_typ_srcset_default'] ?? 0);
$image_typ_srcset_bg      = ($options['image_typ_srcset_bg'] ?? 0);

$image_typ_background_size = (isset($options['image_typ_background_size']) && !empty($options['image_typ_background_size']) ? ' uk-background-' . $options['image_typ_background_size'] : 'uk-background-cover');

$use_image_link = ($options['use_image_link'] ?? 0);

$image_typ = ($options['image_typ'] ?? 1);

$use_filter_shadow = ($options['use_filter_shadow'] ?? "");

$use_gradient_overlay          = ($options['use_gradient_overlay'] ?? 0);
$svg_image_typ_background      = ($options['svg_image_typ_background'] ?? 0);
$svg_typ_background_image_size = (!empty($options['svg_typ_background_image_size']) ? ' uk-background-' . $options['svg_typ_background_image_size'] : 'uk-background-contain');

$use_svg_custom_mask_size = ($options['use_svg_custom_mask_size'] ?? 0);
$style                    = [];

// transition
$use_img_transition = ($options['use_img_transition'] ?? 0);
$img_transition     = (isset($options['img_transition']) && $use_img_transition === "1" ? $options['img_transition'] : '');

$use_overlay_transition = ($options['use_overlay_transition'] ?? 0);
$overlay_transition     = (isset($options['overlay_transition']) && $use_overlay_transition === "1" && $options['use_caption'] === "1" ? $options['overlay_transition'] : '');

// Image transition
if ($use_img_transition === "1" && $use_overlay_transition === "0") {
    $transition_toggle_class  = ' uk-inline-clip';
    $transition_overlay_class = '';
    $transition_img_class     = ' ' . $img_transition . ' uk-transition-opaque';
    $transition_tabindex      = ' tabindex="0"';
} elseif ($use_img_transition === "0" && $use_overlay_transition === "1") {
    $transition_toggle_class  = ' uk-inline-clip';
    $transition_overlay_class = ' ' . $overlay_transition;
    $transition_img_class     = '';
    $transition_tabindex      = ' tabindex="0"';
} else {
    $transition_toggle_class  = '';
    $transition_img_class     = '';
    $transition_overlay_class = '';
    $transition_tabindex      = '';
}

// unsplash.com search
$unsplash_search_query        = (!empty($options['unsplash_search_query']) ? $options['unsplash_search_query'] : '');
$unsplash_custom_search_query = (isset($options['unsplash_custom_search_query']) ? str_replace(' ', '', strtolower(trim($options['unsplash_custom_search_query']))) : '');

// Mask Settings
if (!empty($options['svg_mask_list'])) {
    $style['-webkit-mask'] = Uri::root() . '/media/com_uithemebuilderlite/images/svg-masks/' . $options['svg_mask_list'];
    if ($use_svg_custom_mask_size === "0") {
        $style['-webkit-mask-size'] = $options['svg_mask_size'] ?? 'auto';
    } else {
        $style['-webkit-mask-size'] = $options['svg_custom_mask_size'] ?? '100%';
    }
    $style['-webkit-mask-repeat']   = $options['svg_mask_repeat'] ?? 'inherit';
    $style['-webkit-mask-position'] = $options['svg_mask_position'] ?? 'center';
    $style['mask']                  = Uri::root() . 'media/com_uithemebuilderlite/images/svg-masks/' . $options['svg_mask_list'];
    if ($use_svg_custom_mask_size === "0") {
        $style['mask-size'] = $options['svg_mask_size'] ?? 'auto';
    } else {
        $style['mask-size'] = $options['svg_custom_mask_size'] ?? '100%';
    }
    $style['mask-repeat']   = $options['svg_mask_repeat'] ?? 'inherit';
    $style['mask-position'] = $options['svg_mask_position'] ?? 'center';
    $style['mask-mode']     = $options['svg_mask_mode'] ?? 'unset';
}
// Mask Style
if (!empty($style)) {
    $buildMaskStyle = SitePageHelper::buildStyle($style);
} else {
    $buildMaskStyle = '';
}

// Image ALT Tag
if (!empty($options['alt_text'])) {
    $alt_attr = ' alt="' . $options['alt_text'] . '"';
} else {
    $alt_attr = '';
}
// Background Image height
if ($options['image_height'] === 'viewport') {
    $image_height = '';
    $viewport     = ' uk-height-viewport="offset-top: true"';
} else {
    $image_height = $options['image_height'];
    $viewport     = '';
}
// Background Image position
if (!empty($options['image_position'])) {
    $image_position = ' ' . $options['image_position'];
} else {
    $image_position = '';
}
// Link target
if (!empty($options['button_target'])) {
    $target = ' target="' . $options['button_target'] . '"';
} else {
    $target = '';
}

// empty Image?
if (!empty($options['image'])) {
    $img_full_path = Uri::root() . $options['image'];
} elseif (!empty($options['image_url']) && isset($options['image_url'])) {
    $img_full_path = $options['image_url'];
} elseif (!empty($unsplash_custom_search_query)) {
    $img_full_path = 'https://media.ui-themebuilder.com/com_uithemebuilderpro/unsplash/unsplash_custom.jpg?' . time();
} elseif (!empty($unsplash_search_query)) {
    $img_full_path = 'https://media.ui-themebuilder.com/com_uithemebuilderpro/unsplash/unsplash_' . $unsplash_search_query . '.jpg?' . time();
} else {
    $img_full_path = 'https://media.ui-themebuilder.com/com_uithemebuilderpro/unsplash/unsplash_custom.jpg?' . time();
}
// empty SVG image with a placeholder?
if (!empty($options['image']) && $svg_image_typ_with_imageplaceholder === "1") {
    $svg_img_full_path_placeholder = Uri::root() . $options['image'];
} elseif (!empty($unsplash_custom_search_query)) {
    $svg_img_full_path_placeholder = 'https://media.ui-themebuilder.com/com_uithemebuilderpro/unsplash/unsplash_custom.jpg?' . time();
} elseif (!empty($unsplash_search_query)) {
    $svg_img_full_path_placeholder = 'https://media.ui-themebuilder.com/com_uithemebuilderpro/unsplash/unsplash_' . $unsplash_search_query . '.jpg?' . time();
} else {
    $svg_img_full_path_placeholder = 'https://media.ui-themebuilder.com/com_uithemebuilderpro/unsplash/unsplash_custom.jpg?' . time();
}

// Build Image HTML
if (!empty($options['title']) && $title_show === "1") {
    if ($options['image_height'] === 'viewport' && $image_typ === "1") {
        $html .= '<div class="uk-position-large uk-position-cover uk-flex uk-flex-' . $options['heading_alignment'] . ' uk-flex-middle">';
    }

            $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'ui-image-title');

    if ($options['image_height'] === 'viewport' && $image_typ === "1") {
        $html .= '</div>';
    }
}

// Image
if (($image_typ === "0" || $image_typ === "1" || $image_typ === "2") && $img_full_path) {
    [$width, $height] = getimagesize($img_full_path);

    if (($image_typ === "0" || ($image_typ === "1" && $image_typ_srcset_default === "1" && !empty($options['image_width_srcset_default']))) || ($image_typ === "1" && $image_typ_srcset_bg === "1" && !empty($options['image_width_srcset_bg'])) || (($image_typ === "1" && empty($options['image_width_srcset_bg'])) && empty($options['image_url']))) {
        $ex        = '.' . pathinfo($options['image'], PATHINFO_EXTENSION);
        $file_name = 'th_' . pathinfo($options['image'], PATHINFO_FILENAME);
        // ratio
        $ratio = round($width / $height * 100);

        if ($image_typ === "1" && $image_typ_srcset_bg === "1" && !empty($options['image_width_srcset_bg'])) {
            $tmp_srcset = explode(',', $options['image_width_srcset_bg']);
        } else {
            $tmp_srcset = explode(',', $options['image_width_srcset_default']);
        }
        $merge_srcsets = array_merge($srcsets, $tmp_srcset);
        $srcsets       = array_map('trim', $merge_srcsets);
        $srcsets       = array_unique($srcsets);

        $min_val = min($srcsets);

        $srcset .= ' data-sizes="';
        $srcset .= '(min-width: ' . $min_val . 'px) 90vw, ';
        $srcset .= '(max-width: ' . $width . 'px) 100vw, ';
        $srcset .= '(max-aspect-ratio: ' . $width . '/' . $height . ') ' . $ratio . 'vh" ';
        $srcset .= 'data-srcset="';

        foreach ($srcsets as $i => $val) {
            if (is_numeric($val) && $val < 4000) {
                unset($srcsets[$i]);
                $srcset .= Uri::root() . $thumbnail_folder . '/' . $file_name . '_' . $val . $ex . ' ' . $val . 'w, ';
            }
        }

        $srcset .= $img_full_path . ' ' . $width . 'w" ';

        if ($options['image_height'] === 'viewport' && $image_typ === "1") {
            $srcset .= 'data-src="' . $img_full_path . '"';
        } else {
            $srcset .= 'data-src="' . $img_full_path . '" width="' . $width . '" height="' . $height . '"';
        }
    }

    // Image class
    if (!empty($options['image_border_style'])) {
        if ($use_img_transition === "1") {
            $img_class = ' class="' . $options['image_border_style'] . $transition_img_class . '"';
        } else {
            $img_class = ' class="' . $options['image_border_style'] . '"';
        }
    } elseif ($use_img_transition === "1") {
        $img_class = ' class="' . trim($transition_img_class) . '"';
    } else {
        $img_class = '';
    }

    if (!empty($options['image_overlay_style'])) {
        $overlay_class = ' ' . $options['image_overlay_style'];
    }
    if (!empty($options['image_overlay_position'])) {
        $overlay_class .= ' ' . $options['image_overlay_position'];
    }

    // Background Image
    if ($image_typ === "1") {
        if (!empty($options['image_shadow'])) {
            if ($image_shadow_bottom === "1") {
                $html .= '<div class="' . $options['image_shadow'] . ' uk-box-shadow-bottom uk-width-expand">';
            } else {
                $html .= '<div class="' . $options['image_shadow'] . '">';
            }
        }

        if ($image_typ_srcset_bg === "0") {
            $html .= '<div class="' . trim($image_height . $image_position . $image_typ_background_size) . '" data-src="' . $img_full_path . '" uk-img=""' . $viewport . $buildMaskStyle . '></div>';
            // Background Image with srcset
        } else {
            $html .= '<div class="' . trim($image_height . $image_position . $image_typ_background_size) . '"' . $srcset . ' uk-img=""' . $viewport . $buildMaskStyle . '></div>';
        }

        if (!empty($options['caption']) && $options['use_caption'] === "1") {
            $html .= '<div class="uk-overlay' . $overlay_class . $transition_overlay_class . '">';

            if ($use_image_link === "1") {
                if (!empty($options['button_url'])) {
                    $html .= '<a href="' . $options['button_url'] . '"' . $target . ' class="uk-link-reset">';
                } else {
                    $html .= '<a href="' . Route::_("index.php?Itemid={$url_id}") . '"' . $target . ' class="uk-link-reset">';
                }
            }
            $html .= $options['caption'];

            if ($use_image_link === "1") {
                $html .= '</a>';
            }
            $html .= '</div>';
        }
        if (!empty($options['image_shadow'])) {
            $html .= '</div>';
        }
    }
}

echo $html;
