<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
defined('_JEXEC') or die('Restricted access');


use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use SW\Component\uiThemeBuilderLite\Site\Helper\SitePageHelper;

$html                = '';
$options             = SitePageHelper::escapeHtmlArray($displayData['options']);
$items               = $displayData['items'];
$card_class          = '';
$child_width         = '';
$image_root          = Uri::root(true) . '/';
$sub_nav_color_style = '';

$title_show              = ($options['title_show'] ?? 1);
$titleAndSubtitleClasses = SitePageHelper::getTitleAndSubtitleClasses($options);
$title_class             = ($titleAndSubtitleClasses['title'] === '') ? '' : ' ' . $titleAndSubtitleClasses['title'];

$masonry_grid  = ($options['masonry_grid'] ?? 0);
$sub_nav_style = ($options['sub_nav_style'] ?? 1);
$layout        = ($options['layout'] ?? 1);

$tile_class  = '';
$grid_gutter = '';


// Masonry Grid
if ($masonry_grid == 1) {
    $grid = ' uk-grid="masonry: true"';
} else {
    $grid = ' uk-grid=""';
}
// Subnav Style
if ($sub_nav_style == 1) {
    $subnav_style = ' uk-subnav-divider';
} else {
    $subnav_style = ' uk-subnav-pill';
}
// Filter Nav Color Style
if (!empty($options['sub_nav_color_style'])) {
    $sub_nav_color_style = ' ' . $options['sub_nav_color_style'];
}
// Card Style
if (!empty($options['card_style'])) {
    $card_class .= ' ' . $options['card_style'];
}
// Card size
if (!empty($options['card_size'])) {
    $card_class .= ' ' . $options['card_size'];
}
// Responsive Grid Settings
if (!empty($options['grid_gutter_settings'])) {
    $grid_gutter = ' ' . $options['grid_gutter_settings'];
}
if (!empty($options['grid_settings_m'])) {
    $child_width .= ' uk-child-width-' . $options['grid_settings_m'] . '@m';
}
if (!empty($options['grid_settings_l'])) {
    $child_width .= ' uk-child-width-' . $options['grid_settings_l'] . '@l';
}
if (!empty($options['grid_settings_xl'])) {
    $child_width .= ' uk-child-width-' . $options['grid_settings_xl'] . '@xl';
}


// Build Filtering HTML
if (!empty($options['title']) && $title_show === "1") {
    $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'ui-filter-title');
}

if (count($items)) {
    // Item tags
    $tags = array ();
    foreach ($items as $item_index => $item) {
        if (!empty($item['options']['item_tags'])) {
            $tmp_tags = explode(',', $item['options']['item_tags']);
            $tags     += $tmp_tags;
        }
    }

    $tags = array_map('trim', $tags);
    $tags = array_unique($tags);
    ksort($tags);
    $tags = array_combine(range(1, count($tags)), $tags);

    $html .= '<div uk-filter="target: .ui-filter; animation: fade">';
    if (!empty($tags)) {
        $html .= '<div class="uk-flex uk-flex-' . $options['nav_alignment'] . ' uk-flex-middle uk-height-small' . $sub_nav_color_style . '">';
        $html .= '<ul class="uk-subnav' . $subnav_style . '">'; // Filter SubNav
        if (Factory::getApplication()->isClient('site')) {
            $html .= '<li class="uk-active" uk-filter-control=""><a href="#">' . Text::_('COM_UITHEMEBUILDERLITE_ALL') . '</a></li>';
            foreach ($tags as $i => $tag) {
                $html .= '<li uk-filter-control="[data-tags*=\'' . $i . '\']"><a href="#">' . $tag . '</a></li>';
            }
        } else {
            $html .= '<li class="uk-active" uk-filter-control=""><a href="javascript:void(0)">' . Text::_('COM_UITHEMEBUILDERLITE_ALL') . '</a></li>';
            foreach ($tags as $i => $tag) {
                $html .= '<li uk-filter-control="[data-tags*=\'' . $i . '\']"><a href="javascript:void(0)">' . $tag . '</a></li>';
            }
        }
        $html .= '</ul>';
        $html .= '</div>';
    }
    $html .= '<ul class="ui-filter uk-child-width-1-1' . $child_width . $grid_gutter . '"' . $grid . '>';
    foreach ($items as $item_index => $item) {
        $id                  = $item['options']['item_button_menulist'];
        $item_tags           = array_intersect($tags, array_map('trim', explode(',', $item['options']['item_tags'])));
        $item_button_class   = 'uk-button';
        $random_id           = SitePageHelper::randomNumber();
        $item_title_show     = ($item['options']['item_title_show'] ?? 1);
        $item_src            = '';
        $item_image_alt_text = '';

        // Media Card image
        if (!empty($item['options']['item_image']) && $layout === '1') {
            $item_src = ' data-src="' . $image_root . $item['options']['item_image'] . '"';
            if (!empty($item['options']['item_image_alt_text'])) {
                $item_image_alt_text = ' alt="' . $item['options']['item_image_alt_text'] . '"';
            }
        } elseif (empty($item['options']['item_image']) && $layout == 1) {
            // random Image sizes for unsplash.com
            $sizes               = ['800x600', '960x540', '1024x768'];
            $url                 = SitePageHelper::getRandomUnsplashUrl($sizes, 'city,night');
            $item_src            = ' data-src="' . $url . '"';
        }
        // Button
        if ((!empty($item['options']['item_button_text']) || !empty($item['options']['item_button_icon'])) && (!empty($item['options']['item_button_url']) || !empty($item['options']['item_button_menulist']))) {
            if (!empty($item['options']['item_button_type'])) {
                $item_button_class .= ' uk-button-' . $item['options']['item_button_type'];
            }
            if (!empty($item['options']['item_button_size'])) {
                $item_button_class .= ' uk-button-' . $item['options']['item_button_size'];
            }
        }

        $html .= '<li data-tags="' . implode(' ', array_keys($item_tags)) . '">';
        // card item layout
        if ($layout == 1) {
            $html .= '<div class="uk-card' . $card_class . '">';
                $html .= '<div class="uk-card-media-top uk-cover-container uk-height-medium">';
                    $html .= '<img' . $item_src . $item_image_alt_text . ' uk-cover="" uk-img="" />';
                $html .= '</div>';
            if (!empty($item['options']['item_text']) || (!empty($item['options']['item_title']) && $item_title_show == 1)) {
                if (!empty($item['options']['item_title']) && $item_title_show === '1') {
                    $html .= '<div class="uk-card-header"><' . $item['options']['item_title_heading'] . ' class="uk-card-title">' . $item['options']['item_title'] . '</' . $item['options']['item_title_heading'] . '></div>';
                }
                $html .= '<div class="uk-card-body">';

                if (!empty($item['options']['item_text'])) {
                    $html .= $item['options']['item_text'];
                }
                $html .= '</div>';
            }
            if ((!empty($item['options']['item_button_text']) || !empty($item['options']['item_button_icon'])) && (!empty($item['options']['item_button_url']) || !empty($item['options']['item_button_menulist']))) {
                $html .= '<div class="uk-card-footer">';
                if ($item['options']['item_button_target'] == 'lightbox') {
                    // Link open in Lightbox
                    $html .= '<div uk-lightbox="">';
                    if (!empty($item['options']['item_button_url'])) {
                        $html .= '<a href="' . $item['options']['item_button_url'] . '" class="' . $item_button_class . '" data-caption="' . $item['options']['item_title'] . '" data-type="iframe">';
                    } else {
                        $html .= '<a href="' . Route::_("index.php?Itemid={$id}") . '" class="' . $item_button_class . '" data-caption="' . $item['options']['item_title'] . '" data-type="iframe">';
                    }
                    if (!empty($item['options']['item_button_icon'])) {
                        $html .= '<i class="uk-margin-small-right ' . $item['options']['item_button_icon'] . '"></i>';
                    }
                    if (!empty($item['options']['item_button_text'])) {
                        $html .= $item['options']['item_button_text'];
                    }
                            $html .= '</a>';
                            $html .= '</div>';
                } else {
                    if (!empty($item['options']['item_button_url'])) {
                        $html .= '<a href="' . $item['options']['item_button_url'] . '" target="' . $item['options']['item_button_target'] . '" class="' . $item_button_class . '">';
                    } else {
                        $html .= '<a href="' . Route::_("index.php?Itemid={$id}") . '" target="' . $item['options']['item_button_target'] . '" class="' . $item_button_class . '">';
                    }
                    if (!empty($item['options']['item_button_icon'])) {
                        $html .= '<i class="uk-margin-small-right ' . $item['options']['item_button_icon'] . '"></i>';
                    }
                    if (!empty($item['options']['item_button_text'])) {
                        $html .= $item['options']['item_button_text'];
                    }
                        $html .= '</a>';
                }
                    $html .= '</div>';
            }
            $html .= '</div>';

            // Tile layout
        } elseif ($layout === '2') {
            $html .= '<div class="uk-tile' . $tile_class . '">';
            if (!empty($item['options']['item_title']) && $item_title_show === '1') {
                $html .= '<' . $item['options']['item_title_heading'] . '>' . $item['options']['item_title'] . '</' . $item['options']['item_title_heading'] . '>';
            }

            if (!empty($item['options']['item_text'])) {
                $html .= $item['options']['item_text'];
            }

            if ((!empty($item['options']['item_button_text']) || !empty($item['options']['item_button_icon'])) && (!empty($item['options']['item_button_url']) || !empty($item['options']['item_button_menulist']))) {
                if ($item['options']['item_button_target'] === 'lightbox') {
                    // Link open in Lightbox
                    $html .= '<div uk-lightbox="">';
                    if (!empty($item['options']['item_button_url'])) {
                        $html .= '<a href="' . $item['options']['item_button_url'] . '" class="' . $item_button_class . '" data-caption="' . $item['options']['item_title'] . '" data-type="iframe">';
                    } else {
                        $html .= '<a href="' . Route::_("index.php?Itemid={$id}") . '" class="' . $item_button_class . '" data-caption="' . $item['options']['item_title'] . '" data-type="iframe">';
                    }
                    if (!empty($item['options']['item_button_icon'])) {
                        $html .= '<i class="uk-margin-small-right ' . $item['options']['item_button_icon'] . '"></i>';
                    }
                    if (!empty($item['options']['item_button_text'])) {
                        $html .= $item['options']['item_button_text'];
                    }
                    $html .= '</a>';
                    $html .= '</div>';
                } else {
                    if (!empty($item['options']['item_button_url'])) {
                        $html .= '<a href="' . $item['options']['item_button_url'] . '" target="' . $item['options']['item_button_target'] . '" class="' . $item_button_class . '">';
                    } else {
                        $html .= '<a href="' . Route::_("index.php?Itemid={$id}") . '" target="' . $item['options']['item_button_target'] . '" class="' . $item_button_class . '">';
                    }
                    if (!empty($item['options']['item_button_icon'])) {
                        $html .= '<i class="uk-margin-small-right ' . $item['options']['item_button_icon'] . '"></i>';
                    }
                    if (!empty($item['options']['item_button_text'])) {
                        $html .= $item['options']['item_button_text'];
                    }
                    $html .= '</a>';
                }
            }
            $html .= '</div>';
            // #TODO another Layout
        } else {
            $html .= '';
        }
        $html .= '</li>';
    }
    $html .= '</ul>';
    $html .= '</div>';
}

echo $html;
